/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.map;

import de.datomino.peppergis.client.gui.AbstractHoverRenderer;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.DashLineColorRenderer;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.util.SegmentModelUtil;
import de.datomino.peppergis.type.SegmentType;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.datatypes.Tupel;

public class SegmentHoverRenderer
extends AbstractHoverRenderer<SegmentModel, ImmutableLineString> {
    private static final long serialVersionUID = -2649014472551340315L;
    protected static final Color HOVERCOLOR = new Color(127, 255, 127, 127);
    private Double maxUpp;
    private boolean forMotorSegment;
    private boolean forFootSegment;
    private boolean forBikeSegment;
    private Collection<SegmentModel> freeSegments = new HashSet<SegmentModel>();

    public SegmentHoverRenderer(NavigatorPanel navigatorPanel, Double maxUpp, GeoObjectBucketsModel<SegmentModel, ImmutableLineString> bucketsModel, ModelEnviroment modelEnviroment, boolean active, Component parent) {
        super(navigatorPanel, maxUpp, ModelEnviroment.getMessageResolver().resolveMessage("gui.street.street", new Serializable[0]), bucketsModel, modelEnviroment, active, parent);
        this.maxUpp = maxUpp;
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        if (upp > this.maxUpp || !this.forMotorSegment && !this.forFootSegment && !this.forBikeSegment) {
            return Collections.emptyList();
        }
        CoordinateFactory factory = this.getNavigatorPanel().getCoordinateFactory();
        Coordinate bottomLeft = factory.createCoordinate(realBoundaryBottomLeft);
        Coordinate topRight = factory.createCoordinate(realBoundaryTopRight);
        Collection segments = this.bucketsModel.findObjects(bottomLeft, topRight);
        for (SegmentModel segment : segments) {
            if (!this.isValid(segment)) continue;
            Tupel<Color, Color> colorTupel = SegmentModelUtil.getSegmentColor(segment);
            if (this.hover != null && this.hover.contains(segment)) {
                colorTupel = new Tupel<Color, Color>(HOVERCOLOR, HOVERCOLOR);
            }
            DashLineColorRenderer colorRenderer = new DashLineColorRenderer(upp, false, super.getNavigatorPanel().getCoordinateFactory());
            colorRenderer.render(g2d, segment.getGeom(), colorTupel, 1.0f);
        }
        return Collections.emptyList();
    }

    private boolean isValid(SegmentModel segment) {
        SegmentType segmentType = segment.getSegmentType();
        boolean valid = this.forMotorSegment && segmentType.isForMotor();
        valid |= this.forFootSegment && segmentType.isForFoot();
        valid |= this.forBikeSegment && segmentType.isForBike();
        return valid |= this.freeSegments.contains(segment);
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    @Override
    protected void renderHover(Collection<SegmentModel> s) {
    }

    public void addFreeSegment(SegmentModel segment) {
        if (segment != null) {
            this.freeSegments.add(segment);
        }
    }

    public boolean isForMotorSegment() {
        return this.forMotorSegment;
    }

    public void setForMotorSegment(boolean forMotorSegment) {
        this.forMotorSegment = forMotorSegment;
    }

    public boolean isForFootSegment() {
        return this.forFootSegment;
    }

    public void setForFootSegment(boolean forFootSegment) {
        this.forFootSegment = forFootSegment;
    }

    public boolean isForBikeSegment() {
        return this.forBikeSegment;
    }

    public void setForBikeSegment(boolean forBikeSegment) {
        this.forBikeSegment = forBikeSegment;
    }
}

