/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.map;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.map.BasicSegmentPane;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicArrowButton;

public class SegmentDialog
extends CommonDialog {
    private static final long serialVersionUID = 4350017100416954345L;
    private List<SegmentModel> segments;
    private int currentIndex = 0;
    private ModelEnviroment modelEnviroment;
    private BasicSegmentPane basicSegmentPane;
    private JLabel indexLabel;

    public SegmentDialog(Window parent, List<SegmentModel> segments, ModelEnviroment modelEnviroment) {
        super((Component)parent, "", Dialog.ModalityType.APPLICATION_MODAL);
        this.segments = segments;
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
        if (this.segments.size() > 1) {
            this.add((Component)this.createControlPanel(), "First");
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setTitle(String.valueOf(this.segments.get(this.currentIndex).getIdImportRef()));
        this.pack();
        this.setDefaultCloseOperation(2);
        SwingUtils.centerDialog(this, this.getParent());
        if (visible) {
            this.modelEnviroment.getUndoManager().startTransaction();
        }
        super.setVisible(visible);
    }

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = 4578396289778907053L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SegmentDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        SegmentModel segment = this.segments.get(this.currentIndex);
        this.basicSegmentPane = new BasicSegmentPane(segment, false);
        return this.basicSegmentPane;
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = -8276826685540448350L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SegmentDialog.this.basicSegmentPane.updateSegmentStatus();
                Long osmId = ((SegmentModel)SegmentDialog.this.segments.get(SegmentDialog.this.currentIndex)).getIdImportRef();
                SegmentDialog.this.modelEnviroment.getUndoManager().finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.update", new Serializable[0]) + " - " + String.valueOf(osmId));
                SegmentDialog.this.dispose();
            }
        };
    }

    private JPanel createControlPanel() {
        this.setTitle(String.valueOf(this.segments.get(this.currentIndex).getIdImportRef()));
        JPanel controlPanel = new JPanel(new FlowLayout());
        BasicArrowButton leftButton = new BasicArrowButton(7);
        leftButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        leftButton.setAction(new AbstractAction(){
            private static final long serialVersionUID = -3518442307029297627L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SegmentDialog.this.nextSegment(-1);
            }
        });
        controlPanel.add(leftButton);
        this.indexLabel = new JLabel(this.currentIndex + 1 + "/" + this.segments.size());
        controlPanel.add(this.indexLabel);
        BasicArrowButton rightButton = new BasicArrowButton(3);
        rightButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        rightButton.setAction(new AbstractAction(){
            private static final long serialVersionUID = -5004252883187583290L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SegmentDialog.this.nextSegment(1);
            }
        });
        controlPanel.add(rightButton);
        return controlPanel;
    }

    private void nextSegment(int step) {
        this.currentIndex += step;
        if (this.currentIndex < 0) {
            this.currentIndex = this.segments.size() - 1;
        } else if (this.currentIndex > this.segments.size() - 1) {
            this.currentIndex = 0;
        }
        this.indexLabel.setText(this.currentIndex + 1 + "/" + this.segments.size());
        this.basicSegmentPane.setSegment(this.segments.get(this.currentIndex));
        this.basicSegmentPane.repaint(10L);
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.segments != null) {
            super.setEnabled(b);
        }
        this.basicSegmentPane.setEnabled(b);
    }
}

