/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.map;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.type.SegmentStatus;
import de.datomino.peppergis.type.SegmentType;
import de.datomino.util.swing.SpringUtilities;
import java.io.Serializable;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class BasicSegmentPane
extends JPanel {
    private static final long serialVersionUID = 4743255238496334253L;
    private SegmentModel segment;
    private JTextField osmId;
    private JTextField type;
    private JCheckBox motor;
    private JCheckBox foot;
    private JCheckBox bike;
    private boolean editable;

    public BasicSegmentPane(SegmentModel segment, boolean editable) {
        super(new SpringLayout());
        this.segment = segment;
        this.editable = editable;
        this.buildLayout();
        this.loadValue();
    }

    private void buildLayout() {
        super.add(new JLabel("OSM " + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.id", new Serializable[0])));
        this.osmId = new JTextField();
        this.osmId.setEditable(false);
        super.add(this.osmId);
        super.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.type", new Serializable[0])));
        this.type = new JTextField();
        this.type.setEditable(false);
        super.add(this.type);
        super.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.status", new Serializable[0])));
        super.add(new JLabel(""));
        super.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.motorcar", new Serializable[0])));
        this.motor = new JCheckBox();
        this.motor.setEnabled(this.editable);
        super.add(this.motor);
        super.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.foot", new Serializable[0])));
        this.foot = new JCheckBox();
        this.foot.setEnabled(this.editable);
        super.add(this.foot);
        super.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.bike", new Serializable[0])));
        this.bike = new JCheckBox();
        this.bike.setEnabled(this.editable);
        super.add(this.bike);
        SpringUtilities.makeCompactGrid(this, 6, 2, 5, 5, 5, 5);
    }

    public void updateSegmentStatus() {
        int factor = this.motor.isSelected() ? 100 : 0;
        factor += this.foot.isSelected() ? 10 : 0;
        SegmentStatus newStatus = SegmentStatus.getSegmentStatus(factor += this.bike.isSelected() ? 1 : 0);
        if (newStatus != null && newStatus != this.segment.getSegmentStatus()) {
            this.segment.setSegmentStatus(newStatus);
        }
    }

    public void setSegment(SegmentModel segment) {
        this.segment = segment;
        this.loadValue();
    }

    private void loadValue() {
        SegmentStatus segmentStatus;
        if (this.segment == null) {
            return;
        }
        this.osmId.setText(String.valueOf(this.segment.getIdImportRef()));
        SegmentType segmentType = this.segment.getSegmentType();
        this.type.setText(ModelEnviroment.getMessageResolver().resolveMessageForEnum(segmentType));
        SegmentStatus segmentStatus2 = segmentStatus = this.segment.getSegmentStatus() == null ? SegmentStatus.NORMAL : this.segment.getSegmentStatus();
        if (segmentType.isForMotor()) {
            this.motor.setSelected(!segmentStatus.isBadForMotor());
        } else {
            this.motor.setEnabled(false);
        }
        if (segmentType.isForFoot()) {
            this.foot.setSelected(!segmentStatus.isBadForFoot());
        } else {
            this.foot.setEnabled(false);
        }
        if (segmentType.isForBike()) {
            this.bike.setSelected(!segmentStatus.isBadForBike());
        } else {
            this.bike.setEnabled(false);
        }
    }
}

