/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.login;

import com.caucho.hessian.client.HessianRuntimeException;
import de.datomino.peppergis.client.auth.DefaultUserInformation;
import de.datomino.peppergis.client.auth.SuperUserInformation;
import de.datomino.peppergis.client.auth.UserInformation;
import de.datomino.peppergis.client.communication.AllCaller;
import de.datomino.peppergis.client.communication.UserCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.dto.auth.SaltNonceDto;
import de.datomino.peppergis.exception.UserAlreadyLogedInException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import org.ktde.ee.rmi.AuthenticationException;
import org.ktde.ee.rmi.KickedAuthenticationException;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;

public class LoginPane
extends JPanel {
    private static final long serialVersionUID = 1824793832844282137L;
    private JTextField userName;
    private JPasswordField password;

    public LoginPane() {
        super(new BorderLayout());
        JPanel panel = new JPanel(new GridLayout(2, 1));
        this.userName = new JTextField();
        panel.add(this.createDecoratedTextField(this.userName, "Benutzer"));
        this.password = new JPasswordField();
        panel.add(this.createDecoratedTextField(this.password, "Passwort"));
        this.add((Component)panel, "Center");
    }

    private JComponent createDecoratedTextField(JTextField textField, String label) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(textField);
        panel.setBorder(new TitledBorder(label));
        return panel;
    }

    public String getUserName() {
        return this.userName.getText();
    }

    public String getPassword() {
        return new String(this.password.getPassword());
    }

    public static UserInformation performLogin(AllCaller allCaller, Properties properties, Component parentWindow) {
        String curUser = properties.getProperty("client.username");
        String curPwSalt = properties.getProperty("client.pwsalt");
        UserCaller userCaller = allCaller.getUserCaller();
        boolean freyAutoLoginEnabled = StringUtil.isTrue(properties.getProperty("frey.autoLogin.enabled"));
        boolean loggedIn = false;
        UserModel userModel = null;
        UserInformation userInformation = null;
        String freyUser = properties.getProperty("frey.autoLogin.user");
        if (freyAutoLoginEnabled && !StringUtil.isBlank(freyUser)) {
            userModel = allCaller.getUserCaller().createAdminUserIfNotExists(freyUser);
            Tripel<String, String, UserModel> l = LoginPane.login(userModel.getLogin(), "", userCaller);
            if (l != null) {
                loggedIn = true;
                curUser = l.getElement1();
                curPwSalt = l.getElement2();
                userModel = l.getElement3();
            }
        } else if (curUser != null) {
            SaltNonceDto saltNonceDto = userCaller.requestLogin(curUser);
            String hash = StringUtil.getMd5String(saltNonceDto.getNonce() + curPwSalt);
            try {
                userModel = allCaller.getUserCaller().login(curUser, hash);
                loggedIn = true;
            }
            catch (AuthenticationException authenticationException) {
            }
            catch (UserAlreadyLogedInException userAlreadyLogedInException) {
            }
            catch (HessianRuntimeException hessianRuntimeException) {
                // empty catch block
            }
        }
        if (!loggedIn) {
            final LoginPane loginPane = new LoginPane();
            block7: do {
                Timer timer = new Timer(500, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        loginPane.userName.requestFocusInWindow();
                    }
                });
                timer.setRepeats(false);
                timer.start();
                ImageIcon imageIcon = new ImageIcon(new ImageIcon(LoginPane.class.getResource("/images/pepper.png")).getImage().getScaledInstance(46, 46, 1));
                int d = JOptionPane.showOptionDialog(parentWindow, loginPane, "Login", 2, 3, imageIcon, null, null);
                loginPane.setFocusToLogin();
                switch (d) {
                    case 0: {
                        curUser = loginPane.getUserName();
                        String passwordString = loginPane.getPassword();
                        userInformation = LoginPane.loginSuperUser(curUser, passwordString, userCaller);
                        if (userInformation == null) {
                            Tripel<String, String, UserModel> l = LoginPane.login(curUser, passwordString, userCaller);
                            if (l == null) continue block7;
                            loggedIn = true;
                            curUser = l.getElement1();
                            curPwSalt = l.getElement2();
                            userModel = l.getElement3();
                            userInformation = new DefaultUserInformation(userModel);
                            break;
                        }
                        loggedIn = true;
                        curPwSalt = "dummyPwSal";
                        break;
                    }
                    default: {
                        System.exit(0);
                    }
                }
            } while (!loggedIn);
        }
        if (loggedIn) {
            properties.setProperty("client.username", curUser);
            properties.setProperty("client.pwsalt", curPwSalt);
        } else {
            properties.remove("client.username");
            properties.remove("client.pwsalt");
        }
        return userInformation;
    }

    private static UserInformation loginSuperUser(String curUser, String passwordString, UserCaller userCaller) {
        try {
            userCaller.loginSuperUser(curUser, passwordString);
            return new SuperUserInformation();
        }
        catch (AuthenticationException ex) {
            return null;
        }
    }

    private void setFocusToLogin() {
        this.userName.requestFocusInWindow();
    }

    private static Tripel<String, String, UserModel> login(String curUser, String passwordString, UserCaller userCaller) {
        block7: {
            SaltNonceDto saltNonceDto = userCaller.requestLogin(curUser);
            String curPwSalt = StringUtil.getMd5String(saltNonceDto.getSalt() + passwordString);
            String hash = StringUtil.getMd5String(saltNonceDto.getNonce() + curPwSalt);
            try {
                UserModel userModel = userCaller.login(curUser, hash);
                return new Tripel<String, String, UserModel>(curUser, curPwSalt, userModel);
            }
            catch (AuthenticationException e) {
                JOptionPane.showMessageDialog(null, ModelEnviroment.getMessageResolver().resolveMessage("messages.admin.wrongUserOrPassword", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
            }
            catch (UserAlreadyLogedInException e) {
                int i = JOptionPane.showConfirmDialog(null, ModelEnviroment.getMessageResolver().resolveMessage("messages.admin.kickUserAlreadyLoggedIn.confirm", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0);
                if (i != 0) break block7;
                try {
                    UserModel userModel = userCaller.login(curUser, hash, true);
                    return new Tripel<String, String, UserModel>(curUser, curPwSalt, userModel);
                }
                catch (KickedAuthenticationException e1) {
                    JOptionPane.showMessageDialog(null, ModelEnviroment.getMessageResolver().resolveMessage("messages.admin.kickUserAlreadyLoggedIn.kicked", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]), 0);
                    System.exit(0);
                }
                catch (AuthenticationException e1) {
                    throw new RuntimeException(e1);
                }
                catch (UserAlreadyLogedInException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
        return null;
    }
}

