/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.location;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.navigator.DefaultNavigatorPanel;
import de.datomino.peppergis.client.gui.renderer.common.DefaultSimplePointRenderer;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.international.country.Country;
import de.datomino.util.international.country.CountryUtil;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.StringUtil;

public class ImportedLocationAddressPane
extends JPanel {
    private static final long serialVersionUID = 7236247239321994383L;
    private ImportedLocationModel importedLocation;
    private JTextField country;
    private JTextField postcode;
    private JTextField district;
    private JTextField city;
    private JTextField street;
    private JTextField housenumber;
    private JTextField housenumberExtension;
    private JTextField x;
    private JTextField y;
    private ModelEnviroment modelEnviroment;
    private boolean basicEnabled;
    private boolean coordinateEnabled;
    private DefaultNavigatorPanel navigatorPanel;
    private DefaultSimplePointRenderer defaultSimplePointRenderer;

    public ImportedLocationAddressPane(ImportedLocationModel importedLocation, ModelEnviroment modelEnviroment, boolean basicEnabled) {
        this(importedLocation, modelEnviroment, basicEnabled, false);
    }

    public ImportedLocationAddressPane(ImportedLocationModel importedLocation, ModelEnviroment modelEnviroment, boolean basicEnabled, boolean coordinateEnabled) {
        super(new BorderLayout());
        this.importedLocation = importedLocation;
        this.modelEnviroment = modelEnviroment;
        this.basicEnabled = basicEnabled;
        this.coordinateEnabled = coordinateEnabled;
        this.buildLayout();
        this.fillValues();
    }

    public void setImportedLocation(ImportedLocationModel importedLocation) {
        this.importedLocation = importedLocation;
        this.fillValues();
    }

    private void fillValues() {
        ImmutablePoint geom;
        Country country = this.importedLocation.getCountry();
        this.country.setText(country == null ? "" : country.getVehicleSign());
        this.postcode.setText(StringUtil.nullToEmpty(this.importedLocation.getPostcode()));
        this.city.setText(StringUtil.nullToEmpty(this.importedLocation.getCity()));
        this.district.setText(StringUtil.nullToEmpty(this.importedLocation.getDistrict()));
        this.street.setText(StringUtil.nullToEmpty(this.importedLocation.getStreet()));
        this.housenumber.setText(StringUtil.nullToEmpty(this.importedLocation.getHousenumber()));
        this.housenumberExtension.setText(StringUtil.nullToEmpty(this.importedLocation.getHousenumberExtension()));
        if (this.coordinateEnabled && (geom = this.importedLocation.getGeoLocation()) != null) {
            ImmutablePoint trans = (ImmutablePoint)geom.getTransformed(Wgs84Factory.INSTANCE);
            this.x.setText(trans.getCoordinate().getXString());
            this.y.setText(trans.getCoordinate().getYString());
            this.defaultSimplePointRenderer.setPoint(trans);
        }
    }

    public void centerCoord() {
        Collection points = this.defaultSimplePointRenderer.getPoint();
        if (points != null && !points.isEmpty()) {
            if (points.size() == 1) {
                this.navigatorPanel.center(((ImmutablePoint)points.iterator().next()).getCoordinate());
            } else {
                ArrayList<Coordinate> coords = new ArrayList<Coordinate>(points.size());
                for (ImmutablePoint point : points) {
                    coords.add(point.getCoordinate());
                }
                this.navigatorPanel.center(coords, 5);
            }
        }
    }

    private void buildLayout() {
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.country", new Serializable[0])));
        this.country = new JTextField(10);
        panel.add(this.country);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.postcode", new Serializable[0])));
        this.postcode = new JTextField(10);
        panel.add(this.postcode);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.city", new Serializable[0])));
        this.city = new JTextField(10);
        panel.add(this.city);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.district", new Serializable[0])));
        this.district = new JTextField(10);
        panel.add(this.district);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.street", new Serializable[0])));
        this.street = new JTextField(10);
        panel.add(this.street);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.housenumber", new Serializable[0])));
        this.housenumber = new JTextField(3);
        panel.add(this.housenumber);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.housenumberExtension", new Serializable[0])));
        this.housenumberExtension = new JTextField(3);
        panel.add(this.housenumberExtension);
        if (this.coordinateEnabled) {
            panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gis.coordinate.longitude", new Serializable[0])));
            this.x = new JTextField(3);
            panel.add(this.x);
            panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gis.coordinate.latitude", new Serializable[0])));
            this.y = new JTextField(3);
            panel.add(this.y);
            SpringUtilities.makeCompactGrid(panel, 9, 2, 5, 5, 2, 2);
            this.navigatorPanel = new DefaultNavigatorPanel(this);
            this.defaultSimplePointRenderer = new DefaultSimplePointRenderer(Color.GREEN);
            this.navigatorPanel.addRenderer(this.defaultSimplePointRenderer);
            this.add((Component)this.navigatorPanel, "Center");
        } else {
            SpringUtilities.makeCompactGrid(panel, 7, 2, 5, 5, 2, 2);
        }
        this.add((Component)panel, "North");
        this.setEnabled(this.basicEnabled);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.country.setEditable(enabled);
        this.postcode.setEditable(enabled);
        this.city.setEditable(enabled);
        this.district.setEditable(enabled);
        this.street.setEditable(enabled);
        this.housenumber.setEditable(enabled);
        this.housenumberExtension.setEditable(enabled);
        if (this.coordinateEnabled) {
            this.x.setEditable(enabled);
            this.y.setEditable(enabled);
        }
    }

    public void adaptValuesToModel() {
        LogisticLocationDto<Object> locationDto = new LogisticLocationDto<Object>(null, null, null, CountryUtil.searchCountryFuzzy(this.country.getText()), this.postcode.getText(), this.city.getText(), this.district.getText(), this.street.getText(), this.housenumber.getText(), this.housenumberExtension.getText());
        if (LocationModelUtil.changedAddress(this.importedLocation, locationDto)) {
            this.importedLocation.setCountry(CountryUtil.searchCountryFuzzy(this.country.getText()));
            this.importedLocation.setPostcode(this.postcode.getText());
            this.importedLocation.setCity(this.city.getText());
            this.importedLocation.setDistrict(this.district.getText());
            this.importedLocation.setStreet(this.street.getText());
            Integer housenumber = null;
            try {
                housenumber = Integer.valueOf(this.housenumber.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.importedLocation.setHousenumber(housenumber);
            this.importedLocation.setHousenumberExtension(this.housenumberExtension.getText());
        }
    }
}

