/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.location;

import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.client.geometric.GeoClientHelper;
import de.datomino.peppergis.client.gui.location.AbstractControlPanel;
import de.datomino.peppergis.client.gui.location.AbstractLocationEditorPane;
import de.datomino.peppergis.client.gui.location.GeomEditorMapMouseManipulator;
import de.datomino.peppergis.client.gui.location.GeomEditorResult;
import de.datomino.peppergis.client.gui.location.SearchLocationAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.map.SegmentDialog;
import de.datomino.peppergis.client.gui.map.SegmentHoverRenderer;
import de.datomino.peppergis.client.gui.osm.ThreadingOsmNavigatorRenderer;
import de.datomino.peppergis.client.gui.renderer.AbstractLineRenderer;
import de.datomino.peppergis.client.gui.renderer.CoordinateEditorLayerRenderer;
import de.datomino.peppergis.client.gui.renderer.DashLineRenderer;
import de.datomino.peppergis.client.gui.renderer.MapScaleRenderer;
import de.datomino.peppergis.client.gui.renderer.SolidLineRenderer;
import de.datomino.peppergis.client.gui.renderer.ZoomingRenderer;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.geo.AbstractImmutableGeoObject;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.BucketsFetchCallback;
import de.datomino.util.geo.model.DefaultGeoObjectBucketsModel;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.model.GeomExtractor;
import de.datomino.util.geo.util.GeoUtils;
import de.datomino.util.swing.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.OpenStreetmapViewFactory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.swing.AbstractToggleAction;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractGeomEditorMapPane<C extends JComponent>
extends JPanel {
    private static final long serialVersionUID = 2270917739713777946L;
    protected Coordinate coordinate;
    protected SegmentModel selectedMotorSegment;
    protected SegmentModel motorSegment;
    protected SegmentModel selectedFootSegment;
    protected SegmentModel footSegment;
    protected SegmentModel selectedBikeSegment;
    protected SegmentModel bikeSegment;
    protected boolean motorSegmentUpdate;
    protected boolean footSegmentUpdate;
    protected boolean bikeSegmentUpdate;
    protected NavigatorPanel navigatorPanel;
    private JSpinner xSpinner;
    private JSpinner ySpinner;
    protected CoordinateEditorLayerRenderer coordinateEditorLayerRenderer;
    private SegmentHoverRenderer segmentHoverRenderer;
    private JComboBox<String> coordinateFormat;
    protected C parent;
    private DefaultGeoObjectBucketsModel<SegmentModel, ImmutableLineString> segmentBucketsModel;
    protected boolean routeSegmentEditable;
    private AbstractToggleAction showMotorSegmentAction;
    private AbstractToggleAction showFootSegmentAction;
    private AbstractToggleAction showBikeSegmentAction;
    protected GeoClientHelper geoClientHelper;
    private SearchLocationAction searchLocationAction;

    public AbstractGeomEditorMapPane() {
    }

    public AbstractGeomEditorMapPane(LayoutManager layout) {
        super(layout);
    }

    public AbstractGeomEditorMapPane(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public AbstractGeomEditorMapPane(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    protected void initializedMapPanel() {
        this.navigatorPanel = new NavigatorPanel(this.coordinate, OpenStreetmapViewFactory.INSTANCE, (Container)this);
        this.navigatorPanel.setPanning(true);
        this.navigatorPanel.getPanningAction().setSelected(true);
        this.navigatorPanel.setCursor(Cursor.getDefaultCursor());
        ThreadingOsmNavigatorRenderer osmNavigatorRenderer = new ThreadingOsmNavigatorRenderer(ModelEnviroment.getProperties());
        osmNavigatorRenderer.setNavigatorPanel(this.navigatorPanel);
        this.navigatorPanel.addRenderer(osmNavigatorRenderer);
        if (this.routeSegmentEditable) {
            this.showMotorSegmentAction = new AbstractToggleAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.motorcar", new Serializable[0])){
                private static final long serialVersionUID = 5296326736752642676L;

                @Override
                public void turnOn() {
                    AbstractGeomEditorMapPane.this.showFootSegmentAction.setSelected(false);
                    AbstractGeomEditorMapPane.this.showBikeSegmentAction.setSelected(false);
                    AbstractGeomEditorMapPane.this.segmentHoverRenderer.turnOn();
                    AbstractGeomEditorMapPane.this.segmentHoverRenderer.setForMotorSegment(true);
                    AbstractGeomEditorMapPane.this.repaint(10L);
                }

                @Override
                public void turnOff() {
                    AbstractGeomEditorMapPane.this.segmentHoverRenderer.setSelected(false);
                    AbstractGeomEditorMapPane.this.segmentHoverRenderer.setForMotorSegment(false);
                    AbstractGeomEditorMapPane.this.repaint(10L);
                }
            };
            this.showFootSegmentAction = new AbstractToggleAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.foot", new Serializable[0])){
                private static final long serialVersionUID = 5296326736752642676L;

                @Override
                public void turnOn() {
                    AbstractGeomEditorMapPane.this.showMotorSegmentAction.setSelected(false);
                    AbstractGeomEditorMapPane.this.showBikeSegmentAction.setSelected(false);
                    AbstractGeomEditorMapPane.this.segmentHoverRenderer.turnOn();
                    AbstractGeomEditorMapPane.this.segmentHoverRenderer.setForFootSegment(true);
                    AbstractGeomEditorMapPane.this.repaint(10L);
                }

                @Override
                public void turnOff() {
                    AbstractGeomEditorMapPane.this.segmentHoverRenderer.setSelected(false);
                    AbstractGeomEditorMapPane.this.segmentHoverRenderer.setForFootSegment(false);
                    AbstractGeomEditorMapPane.this.repaint(10L);
                }
            };
            this.showBikeSegmentAction = new AbstractToggleAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.bike", new Serializable[0])){
                private static final long serialVersionUID = -4769279087966042279L;

                @Override
                public void turnOn() {
                    AbstractGeomEditorMapPane.this.showMotorSegmentAction.setSelected(false);
                    AbstractGeomEditorMapPane.this.showFootSegmentAction.setSelected(false);
                    AbstractGeomEditorMapPane.this.segmentHoverRenderer.turnOn();
                    AbstractGeomEditorMapPane.this.segmentHoverRenderer.setForBikeSegment(true);
                    AbstractGeomEditorMapPane.this.repaint(10L);
                }

                @Override
                public void turnOff() {
                    AbstractGeomEditorMapPane.this.segmentHoverRenderer.setSelected(false);
                    AbstractGeomEditorMapPane.this.segmentHoverRenderer.setForBikeSegment(false);
                    AbstractGeomEditorMapPane.this.repaint(10L);
                }
            };
            this.segmentHoverRenderer = new SegmentHoverRenderer(this.navigatorPanel, AbstractLocationEditorPane.DEFAULTMAXUPP, (GeoObjectBucketsModel)this.getSegmentBucketsModel(), this.getModelEnvironment(), false, (Component)this.parent){
                private static final long serialVersionUID = -6881303010231234006L;

                @Override
                protected void mouseClicked(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
                    super.mouseClicked(x, y, clickCount, modifiers, mouseButton);
                    Collection segments = super.findObjects(x, y, super.getMindistForHover(x, y));
                    if (!segments.isEmpty()) {
                        if (mouseButton == MouseButton.BUTTON2) {
                            AbstractGeomEditorMapPane.this.selectSegment(segments);
                        } else if (mouseButton == MouseButton.BUTTON1) {
                            AbstractGeomEditorMapPane.this.editSegment(segments);
                        }
                    }
                }

                @Override
                public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
                    Collection<OnTopRendering> onTops = super.paintOnto(g2d, realBoundaryBottomLeft, realBoundaryTopRight, upp);
                    AbstractGeomEditorMapPane.this.paintLinkOnSegment(g2d, upp);
                    return onTops;
                }

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                }
            };
            this.segmentHoverRenderer.setNavigatorPanel(this.navigatorPanel);
            this.navigatorPanel.addRenderer(this.segmentHoverRenderer);
        }
        this.coordinateEditorLayerRenderer = new CoordinateEditorLayerRenderer(true);
        this.coordinateEditorLayerRenderer.setNavigatorPanel(this.navigatorPanel);
        this.navigatorPanel.addRenderer(this.coordinateEditorLayerRenderer);
        MapScaleRenderer renderer = new MapScaleRenderer(ModelEnviroment.getMessageResolver().resolveMessage("messages.common.mapScale", new Serializable[0]));
        renderer.setNavigatorPanel(this.navigatorPanel);
        this.navigatorPanel.addRenderer(renderer);
        ZoomingRenderer zoomingRenderer = new ZoomingRenderer(this.navigatorPanel);
        zoomingRenderer.setNavigatorPanel(this.navigatorPanel);
        this.navigatorPanel.addRenderer(zoomingRenderer);
        this.navigatorPanel.addPreferredMouseManipulatorForClick(zoomingRenderer);
        GeomEditorMapMouseManipulator coordinateMapListener = new GeomEditorMapMouseManipulator(this);
        this.navigatorPanel.setMouseManipulator(null);
        this.navigatorPanel.addMouseListener(coordinateMapListener);
        this.navigatorPanel.addMouseMotionListener(coordinateMapListener);
        this.navigatorPanel.addMouseWheelListener(coordinateMapListener);
    }

    protected JPanel creatControlPanel(boolean withSearchRendering) {
        AbstractControlPanel panel = new AbstractControlPanel(this.getNavigatorPanel(), this.getModelEnvironment(), this.showMotorSegmentAction, this.showBikeSegmentAction, this.showFootSegmentAction, withSearchRendering, this.routeSegmentEditable){
            private static final long serialVersionUID = -4920878313870527966L;

            @Override
            public void update() {
                AbstractGeomEditorMapPane.this.update();
            }

            @Override
            protected void doAfterCoordinateFound(Coordinate coordinate) {
                AbstractGeomEditorMapPane.this.doAfterFindingCoordinate(coordinate);
            }

            @Override
            protected void doAfterCoordinateFound(ImmutablePoint point) {
                AbstractGeomEditorMapPane.this.doAfterFindingCoordinate(point);
            }
        };
        this.xSpinner = panel.getxSpinner();
        this.ySpinner = panel.getySpinner();
        this.searchLocationAction = panel.getSearchLocationAction();
        this.coordinateFormat = panel.getCoordinateFormat();
        return panel;
    }

    protected void doAfterFindingCoordinate(ImmutablePoint point) {
    }

    protected void doAfterFindingCoordinate(Coordinate coordinate) {
    }

    public void gotoCoordinate() {
        Coordinate c = this.coordinateEditorLayerRenderer.getCoordinate();
        if (GeoUtils.isNullCoordinate(c)) {
            c = Wgs84Factory.INSTANCE.createCoordinate(0.0, 0.0);
        }
        this.navigatorPanel.gotoCoordinate(c);
        this.navigatorPanel.center(c);
        this.navigatorPanel.repaint(10L);
    }

    public boolean isChanged() {
        return !new EqualsBuilder().append(this.selectedBikeSegment, this.bikeSegment).append(this.selectedFootSegment, this.footSegment).append(this.selectedMotorSegment, this.motorSegment).isEquals();
    }

    public void update() {
        Coordinate newCoordinate;
        Double newX = Double.valueOf(this.xSpinner.getValue().toString());
        Double newY = Double.valueOf(this.ySpinner.getValue().toString());
        String coordinateFactoryName = (String)this.coordinateFormat.getSelectedItem();
        CoordinateFactory factory = CoordinateFactory.getInstance(coordinateFactoryName);
        if (factory == null) {
            factory = Wgs84Factory.INSTANCE;
        }
        if (GeoUtil.isNullPoint(ImmutableGeoObjectFactory.createImmutablePoint(newCoordinate = factory.createCoordinate(newX, newY)))) {
            String s = ClientFormUtil.getNumberString(newX) + ", " + ClientFormUtil.getNumberString(newY);
            JOptionPane.showMessageDialog(this, ModelEnviroment.getMessageResolver().resolveMessage("messages.attribute.error.format.integer", new Serializable[]{s}), "", 2);
            this.setCoordinate(this.coordinate, false);
            return;
        }
        if (newCoordinate != null && !newCoordinate.equals(this.coordinate)) {
            this.coordinate = newCoordinate;
            this.coordinateEditorLayerRenderer.setCoordinate(this.coordinate);
        }
        this.gotoCoordinate();
        if (this.selectedMotorSegment != null && !this.selectedMotorSegment.equals(this.motorSegment)) {
            this.motorSegment = this.selectedMotorSegment;
            this.motorSegmentUpdate = true;
        }
        if (this.selectedFootSegment != null && !this.selectedFootSegment.equals(this.footSegment)) {
            this.footSegment = this.selectedFootSegment;
            this.footSegmentUpdate = true;
        }
        if (this.selectedBikeSegment != null && !this.selectedBikeSegment.equals(this.bikeSegment)) {
            this.bikeSegment = this.selectedBikeSegment;
            this.bikeSegmentUpdate = true;
        }
        this.navigatorPanel.repaint(10L);
        this.updateParent();
    }

    public void restoreSegments() {
        this.selectedBikeSegment = this.bikeSegment;
        this.selectedFootSegment = this.footSegment;
        this.selectedMotorSegment = this.motorSegment;
        this.updateParent();
    }

    public Coordinate getCoordinateOnMap() {
        String coordinateFactoryName = (String)this.coordinateFormat.getSelectedItem();
        CoordinateFactory factory = CoordinateFactory.getInstance(coordinateFactoryName);
        return factory.createCoordinate(this.coordinateEditorLayerRenderer.getCoordinate());
    }

    public void setCoordinate(Coordinate coordinate, boolean updated) {
        String coordinateFactoryName;
        CoordinateFactory factory;
        if (coordinate == null) {
            coordinate = Wgs84Factory.INSTANCE.createCoordinate(0.0, 0.0);
        }
        if ((factory = CoordinateFactory.getInstance(coordinateFactoryName = (String)this.coordinateFormat.getSelectedItem())) == null) {
            factory = Wgs84Factory.INSTANCE;
        }
        Coordinate c = factory.createCoordinate(coordinate);
        if (updated) {
            this.coordinate = c;
        }
        this.coordinateEditorLayerRenderer.setCoordinate(c);
        this.xSpinner.setValue(c.getX());
        this.ySpinner.setValue(c.getY());
    }

    public void setSegments(SegmentModel motorSegment, SegmentModel footSegment, SegmentModel bikeSegment, boolean init) {
        this.motorSegment = motorSegment;
        this.selectedMotorSegment = motorSegment;
        this.footSegment = footSegment;
        this.selectedFootSegment = footSegment;
        this.bikeSegment = bikeSegment;
        this.selectedBikeSegment = bikeSegment;
        if (this.segmentHoverRenderer != null) {
            this.segmentHoverRenderer.addFreeSegment(motorSegment);
            this.segmentHoverRenderer.addFreeSegment(footSegment);
            this.segmentHoverRenderer.addFreeSegment(bikeSegment);
        }
    }

    public GeomEditorResult getResult() {
        return new GeomEditorResult(this.coordinate, this.motorSegment, this.footSegment, this.bikeSegment, this.motorSegmentUpdate, this.footSegmentUpdate, this.bikeSegmentUpdate);
    }

    public GeomEditorResult getSelectedResult() {
        return new GeomEditorResult(this.coordinate, this.selectedMotorSegment, this.selectedFootSegment, this.selectedBikeSegment, true, true, true);
    }

    public CoordinateEditorLayerRenderer getCoordinateEditorLayerRenderer() {
        return this.coordinateEditorLayerRenderer;
    }

    public NavigatorPanel getNavigatorPanel() {
        return this.navigatorPanel;
    }

    public SearchLocationAction getSearchLocationAction() {
        return this.searchLocationAction;
    }

    public DefaultGeoObjectBucketsModel<SegmentModel, ImmutableLineString> getSegmentBucketsModel() {
        if (this.segmentBucketsModel == null) {
            this.segmentBucketsModel = new DefaultGeoObjectBucketsModel<SegmentModel, ImmutableLineString>(this.navigatorPanel.getCoordinateFactory().getRefScale() * 5000.0, this.navigatorPanel.getCoordinateFactory(), new GeomExtractor<SegmentModel, ImmutableLineString>(){

                @Override
                public ImmutableLineString getGeom(SegmentModel object) {
                    return object.getGeom();
                }
            });
            this.segmentBucketsModel.setFetchCallback(new BucketsFetchCallback<SegmentModel, ImmutableLineString>(){

                @Override
                public Collection<SegmentModel> fetch(Coordinate topLeft, Coordinate bottomRight) {
                    return AbstractGeomEditorMapPane.this.getModelEnvironment().getAllCaller().getStreetNetCaller().fetchSegments(topLeft, bottomRight);
                }
            });
        }
        return this.segmentBucketsModel;
    }

    private void paintLinkOnSegment(Graphics2D g2d, double upp) {
        if (this.selectedMotorSegment != null && this.selectedMotorSegment.getGeom() != null && this.segmentHoverRenderer.isForMotorSegment()) {
            this.paintLineString(g2d, upp, this.selectedMotorSegment, AbstractLineRenderer.LineType.DASH, new Tupel<Color, Object>(PeppergisConstants.MOTOR_SEGMENT_COLOR, null));
        }
        if (this.motorSegment != null && this.motorSegment.getGeom() != null && this.segmentHoverRenderer.isForMotorSegment()) {
            this.paintLineString(g2d, upp, this.motorSegment, AbstractLineRenderer.LineType.SOLID, new Tupel<Color, Object>(PeppergisConstants.MOTOR_SEGMENT_COLOR, null));
        }
        if (this.selectedFootSegment != null && this.selectedFootSegment.getGeom() != null && this.segmentHoverRenderer.isForFootSegment()) {
            this.paintLineString(g2d, upp, this.selectedFootSegment, AbstractLineRenderer.LineType.DASH, new Tupel<Color, Object>(PeppergisConstants.FOOT_SEGMENT_COLOR, null));
        }
        if (this.footSegment != null && this.footSegment.getGeom() != null && this.segmentHoverRenderer.isForFootSegment()) {
            this.paintLineString(g2d, upp, this.footSegment, AbstractLineRenderer.LineType.SOLID, new Tupel<Color, Object>(PeppergisConstants.FOOT_SEGMENT_COLOR, null));
        }
        if (this.selectedBikeSegment != null && this.selectedBikeSegment.getGeom() != null && this.segmentHoverRenderer.isForBikeSegment()) {
            this.paintLineString(g2d, upp, this.selectedBikeSegment, AbstractLineRenderer.LineType.DASH, new Tupel<Color, Object>(PeppergisConstants.BIKE_SEGMENT_COLOR, null));
        }
        if (this.bikeSegment != null && this.bikeSegment.getGeom() != null && this.segmentHoverRenderer.isForBikeSegment()) {
            this.paintLineString(g2d, upp, this.bikeSegment, AbstractLineRenderer.LineType.SOLID, new Tupel<Color, Object>(PeppergisConstants.BIKE_SEGMENT_COLOR, null));
        }
    }

    private void paintLineString(Graphics2D g2d, double upp, SegmentModel segment, AbstractLineRenderer.LineType type, Tupel<Color, Color> colorTupel) {
        ImmutableLineString lineString = segment.getGeom();
        ImmutablePoint point = ImmutableGeoObjectFactory.createImmutablePoint(this.getCoordinateEditorLayerRenderer().getCoordinate());
        ImmutablePoint shortestPerpendicular = GeoUtil.getShortestPerpendicular(point, lineString).getElement2();
        AbstractLineRenderer lineRenderer = null;
        if (type == AbstractLineRenderer.LineType.DASH) {
            lineRenderer = new DashLineRenderer(upp, 5.0f, false, this.navigatorPanel.getCoordinateFactory());
            colorTupel.setElement2(null);
        } else if (type == AbstractLineRenderer.LineType.SOLID) {
            lineRenderer = new SolidLineRenderer(upp, false, this.navigatorPanel.getCoordinateFactory());
        }
        AbstractImmutableGeoObject geoObject = GeoUtils.getLineString(point, shortestPerpendicular);
        if (geoObject instanceof ImmutableLineString) {
            ((AbstractLineRenderer)lineRenderer).render(g2d, (ImmutableLineString)geoObject, colorTupel, 1.0f);
        }
    }

    private void selectSegment(Collection<SegmentModel> segments) {
        int d;
        boolean b = true;
        SegmentModel next = segments.iterator().next();
        if (this.segmentHoverRenderer.isForMotorSegment()) {
            if (next.getSegmentType().isForMotor()) {
                if (next.getSegmentStatus() != null && next.getSegmentStatus().isBadForMotor()) {
                    b = false;
                } else {
                    this.selectedMotorSegment = next;
                }
            } else {
                d = JOptionPane.showConfirmDialog(this, ModelEnviroment.getMessageResolver().resolveMessage("messages.confirm.freestreet", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.confirm", new Serializable[0]), 2);
                switch (d) {
                    case 0: {
                        this.selectedMotorSegment = next;
                        this.segmentHoverRenderer.addFreeSegment(next);
                        break;
                    }
                }
            }
        }
        if (this.segmentHoverRenderer.isForFootSegment()) {
            if (next.getSegmentType().isForFoot()) {
                if (next.getSegmentStatus() != null && next.getSegmentStatus().isBadForFoot()) {
                    b = false;
                } else {
                    this.selectedFootSegment = next;
                }
            } else {
                d = JOptionPane.showConfirmDialog(this, ModelEnviroment.getMessageResolver().resolveMessage("messages.confirm.freestreet", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.confirm", new Serializable[0]), 2);
                switch (d) {
                    case 0: {
                        this.selectedFootSegment = next;
                        this.segmentHoverRenderer.addFreeSegment(next);
                        break;
                    }
                }
            }
        }
        if (this.segmentHoverRenderer.isForBikeSegment()) {
            if (next.getSegmentType().isForBike()) {
                if (next.getSegmentStatus() != null && next.getSegmentStatus().isBadForBike()) {
                    b = false;
                } else {
                    this.selectedBikeSegment = next;
                }
            } else {
                d = JOptionPane.showConfirmDialog(this, ModelEnviroment.getMessageResolver().resolveMessage("messages.confirm.freestreet", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.confirm", new Serializable[0]), 2);
                switch (d) {
                    case 0: {
                        this.selectedBikeSegment = next;
                        this.segmentHoverRenderer.addFreeSegment(next);
                        break;
                    }
                }
            }
        }
        if (b) {
            this.navigatorPanel.repaint(10L);
        } else {
            JOptionPane.showMessageDialog(this, ModelEnviroment.getMessageResolver().resolveMessage("messages.error.segment.invalidVehicle", new Serializable[0]), "", 0);
        }
    }

    private void editSegment(Collection<SegmentModel> segments) {
        ArrayList<SegmentModel> list = new ArrayList<SegmentModel>(segments);
        Collections.sort(list, new Comparator<SegmentModel>(){

            @Override
            public int compare(SegmentModel o1, SegmentModel o2) {
                return o1.getIdImportRef().compareTo(o2.getIdImportRef());
            }
        });
        SegmentDialog dialog = new SegmentDialog(SwingUtils.findWindowParent(this.parent), list, this.getModelEnvironment());
        dialog.setVisible(true);
    }

    public JSpinner getxSpinner() {
        return this.xSpinner;
    }

    public void setxSpinner(JSpinner xSpinner) {
        this.xSpinner = xSpinner;
    }

    public JSpinner getySpinner() {
        return this.ySpinner;
    }

    public void setySpinner(JSpinner ySpinner) {
        this.ySpinner = ySpinner;
    }

    public void setAddressToSearch(LocationWrapper wrapper) {
        if (this.searchLocationAction != null) {
            this.searchLocationAction.setAddress(wrapper);
        }
    }

    protected abstract void updateParent();

    protected abstract ModelEnviroment getModelEnvironment();
}

