/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.letter;

import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.type.LetterDeliveryType;
import de.datomino.peppergis.util.FormUtil;
import java.awt.GridLayout;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;

public class LetterOptionsPane
extends JPanel {
    private static final long serialVersionUID = -6803398779355274436L;
    private JSpinner dateSpinner;
    private EnumComboBox<LetterDeliveryType> typeCombox;

    public LetterOptionsPane() {
        super(new GridLayout(2, 2));
        this.initialize(null);
    }

    public LetterOptionsPane(JPanel parentPanel) {
        super(new GridLayout(2, 2));
        this.initialize(parentPanel);
    }

    private void initialize(JPanel parentPanel) {
        this.dateSpinner = new JSpinner(new SpinnerDateModel(new Date(), null, null, 5));
        if (parentPanel == null) {
            this.dateSpinner.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        }
        JSpinner.DateEditor editor = new JSpinner.DateEditor(this.dateSpinner, FormUtil.DATEFORMAT);
        this.dateSpinner.setEditor(editor);
        JLabel label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.date", new Serializable[0]));
        if (parentPanel == null) {
            this.add(label);
            this.add(this.dateSpinner);
        } else {
            parentPanel.add(label);
            parentPanel.add(this.dateSpinner);
        }
        this.typeCombox = new EnumComboBox<LetterDeliveryType>(LetterDeliveryType.class, false);
        if (parentPanel == null) {
            this.typeCombox.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        }
        label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("de.datomino.peppergis.type.SubscriptionDeliveryType", new Serializable[0]));
        if (parentPanel == null) {
            this.add(label);
            this.add(this.typeCombox);
        } else {
            parentPanel.add(label);
            parentPanel.add(this.typeCombox);
        }
    }

    public void setOptionEnabled(boolean enabled) {
        ClientSwingUtil.setSpinnerEnable(this.dateSpinner, enabled);
        this.typeCombox.setEnabled(enabled);
    }

    public Date getDate() {
        return (Date)this.dateSpinner.getValue();
    }

    public Set<LetterDeliveryType> getTypes() {
        HashSet<LetterDeliveryType> types = new HashSet<LetterDeliveryType>();
        if (this.typeCombox.getSelectedValue() == LetterDeliveryType.ALL) {
            for (LetterDeliveryType type : LetterDeliveryType.values()) {
                types.add(type);
            }
        } else {
            types.add(this.typeCombox.getSelectedValue());
        }
        return types;
    }

    public void setDate(Date date) {
        if (date != null) {
            this.dateSpinner.setValue(date);
        }
    }

    public void setType(Collection<LetterDeliveryType> types) {
        if (types != null) {
            if (types.size() == 1) {
                this.typeCombox.setSelectedValue((LetterDeliveryType)((Enum)types.iterator().next()));
            } else {
                this.typeCombox.setSelectedValue(LetterDeliveryType.ALL);
            }
        }
    }

    public int getRowCount() {
        return 3;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.dateSpinner.setEnabled(enabled);
        this.typeCombox.setEnabled(enabled);
    }
}

