/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.letter;

import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.gui.AbstractLayerRenderer;
import de.datomino.peppergis.client.gui.DefaultPointRenderer;
import de.datomino.peppergis.client.gui.letter.LetterDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.map.RendererNode;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.util.LetterModelUtil;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class LetterLayerRenderer
extends AbstractLayerRenderer {
    private List<Tupel<LetterModel, Integer>> letters;
    private LetterModel selectedLetter;
    private Map<AreaObjectModel, Color> areaObjectColorCache = new HashMap<AreaObjectModel, Color>();
    private Map<LetterModel, Rectangle2D.Double> drawedLettersOnMap = new HashMap<LetterModel, Rectangle2D.Double>();

    public LetterLayerRenderer(Component parent, ModelEnviroment modelEnviroment, boolean active) {
        this(parent, modelEnviroment, active, false);
    }

    public LetterLayerRenderer(Component parent, ModelEnviroment modelEnviroment, boolean active, boolean withIndex) {
        super(active, withIndex, parent, modelEnviroment);
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        if (this.letters == null || this.letters.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<ImmutablePoint, Set<Tripel<ImmutableLineString, ImmutableLineString, ImmutableLineString>>> map = new HashMap<ImmutablePoint, Set<Tripel<ImmutableLineString, ImmutableLineString, ImmutableLineString>>>();
        for (Tupel<LetterModel, Integer> letter : this.letters) {
            LocationModel location = letter.getElement1().getLocation();
            if (location == null) continue;
            LocationWrapper wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
            SegmentModel motorSegment = LocationModelUtil.getRouteSegment(location, RouteVehicleType.MOTORCAR, this.modelEnviroment);
            ImmutableLineString motorLineString = motorSegment == null ? null : motorSegment.getGeom();
            SegmentModel footSegment = LocationModelUtil.getRouteSegment(location, RouteVehicleType.FOOT, this.modelEnviroment);
            ImmutableLineString footLineString = footSegment == null ? null : footSegment.getGeom();
            SegmentModel bikeSegment = LocationModelUtil.getRouteSegment(location, RouteVehicleType.BIKE, this.modelEnviroment);
            ImmutableLineString bikeLineString = bikeSegment == null ? null : bikeSegment.getGeom();
            HashSet<Tripel<ImmutableLineString, ImmutableLineString, ImmutableLineString>> set = (HashSet<Tripel<ImmutableLineString, ImmutableLineString, ImmutableLineString>>)map.get(wrapper.getGeoLocation());
            if (set == null) {
                set = new HashSet<Tripel<ImmutableLineString, ImmutableLineString, ImmutableLineString>>();
                map.put(wrapper.getGeoLocation(), set);
            }
            set.add(new Tripel<ImmutableLineString, ImmutableLineString, ImmutableLineString>(motorLineString, footLineString, bikeLineString));
        }
        this.drawSegments(map, g2d, upp);
        DefaultPointRenderer pointRenderer = new DefaultPointRenderer(g2d, upp, this.navigatorPanel.getCoordinateFactory());
        double margin = 10.0 * Math.pow(upp, -0.2) * upp;
        this.drawedLettersOnMap = pointRenderer.drawLetters(this.letters, margin, this.areaObjectColorCache, this.withIndex, Color.WHITE);
        if (this.selectedLetter != null) {
            this.createInfobox(pointRenderer, this.selectedLetter, margin);
        }
        return Collections.emptyList();
    }

    @Override
    public void mouseClickFinished(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
        if (this.modelEnviroment != null && this.letters != null && clickCount > 1) {
            Point2D.Double real = this.navigatorPanel.getReal(x, y);
            ArrayList<LetterModel> letters = new ArrayList<LetterModel>();
            for (LetterModel letter : this.drawedLettersOnMap.keySet()) {
                Rectangle2D.Double rectangle = this.drawedLettersOnMap.get(letter);
                if (!rectangle.contains(real)) continue;
                letters.add(letter);
            }
            if (!letters.isEmpty()) {
                LetterDialog dialog = new LetterDialog(super.getParentWindow(), letters, this.modelEnviroment);
                dialog.setVisible(true);
            }
        }
    }

    public void setLetters(List<Tupel<LetterModel, Integer>> letters) {
        this.letters = letters;
    }

    private Color getColorOfAreaObject(AreaObjectModel areaObject) {
        Color colorOfAreaObject = this.areaObjectColorCache.get(areaObject);
        if (colorOfAreaObject == null) {
            colorOfAreaObject = Color.BLACK;
        }
        return colorOfAreaObject;
    }

    public boolean showInfobox(Point2D.Double real) {
        this.selectedLetter = null;
        Set<LetterModel> letters = this.drawedLettersOnMap.keySet();
        for (LetterModel letter : letters) {
            Rectangle2D.Double rectangle = this.drawedLettersOnMap.get(letter);
            if (!rectangle.contains(real)) continue;
            this.selectedLetter = letter;
            return true;
        }
        return false;
    }

    private void createInfobox(DefaultPointRenderer pointRenderer, LetterModel letter, double margin) {
        Rectangle2D.Double rectangle = this.drawedLettersOnMap.get(letter);
        if (rectangle == null) {
            return;
        }
        List<String> infoBox = LetterModelUtil.getInfoBoxString(letter);
        double left = rectangle.getCenterX();
        double top = rectangle.getCenterY();
        Rectangle2D.Double rectangleOfBox = new Rectangle2D.Double();
        rectangleOfBox.height = (double)infoBox.size() * margin * 2.0;
        rectangleOfBox.width = (double)FormUtil.getMaxWordCount(infoBox) * margin;
        rectangleOfBox.x = left;
        rectangleOfBox.y = top - rectangleOfBox.height;
        Color color = this.getColorOfAreaObject(letter.getAreaObject());
        RendererNode node = new RendererNode(null, null, Color.BLACK, Color.WHITE, margin);
        pointRenderer.drawShape(rectangleOfBox, node, margin / 10.0);
        double marginTop = 0.0;
        for (String info : infoBox) {
            Coordinate c = this.navigatorPanel.getCoordinateFactory().createCoordinate(left + margin / 2.0, top - margin * 1.5 - marginTop);
            RendererNode n = new RendererNode(info, c, margin * 0.75);
            n.setFontground(color);
            pointRenderer.drawText(n);
            marginTop += margin * 2.0;
        }
    }

    @Override
    public String getName() {
        return "LetterLayerRenderer";
    }
}

