/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.letter;

import de.datomino.peppergis.client.gui.AbstractMapEditorPanel;
import de.datomino.peppergis.client.gui.DefaultPointRenderer;
import de.datomino.peppergis.client.gui.PausableInternalFrame;
import de.datomino.peppergis.client.gui.filter.pattern.legend.listener.PatterLegendSelectionEvent;
import de.datomino.peppergis.client.gui.letter.LetterDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.map.RendererNode;
import de.datomino.peppergis.client.gui.renderer.AbstractFilterableMarkerNavigatorRenderer;
import de.datomino.peppergis.client.gui.renderer.area.AreaPointRenderer;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.LetterFilterPatternSetupModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.filter.LetterFilterModel;
import de.datomino.peppergis.client.util.LetterModelUtil;
import de.datomino.peppergis.client.util.filter.AbstractFilterPatternSetupRendererSelektor;
import de.datomino.peppergis.client.util.filter.letter.LetterFilterPatternSetupRendererSelektor;
import de.datomino.peppergis.client.util.model.letter.LetterLocationObject;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.CyclingIterator;
import de.datomino.util.collection.Transformer;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.model.time.TimeBasedGeoObjectBucketsModel;
import de.datomino.util.geo.model.time.TimeRange;
import de.datomino.util.geo.swing.ObjectMarkerNavigatorRenderer;
import de.datomino.util.geo.swing.PaintUtil;
import de.datomino.util.geo.swing.renderer.AbstractRenderer;
import de.datomino.util.geo.swing.renderer.DefaultRendererProperties;
import de.datomino.util.geo.swing.renderer.PointRenderer;
import de.datomino.util.geo.swing.renderer.RendererChecker;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.time.TimeUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class LetterFilterableMarkerRenderer
extends AbstractFilterableMarkerNavigatorRenderer<LetterModel, LetterLocationObject, ImmutablePoint, RendererProperties, RendererProperties, DefaultRendererProperties, LetterFilterModel> {
    private static final long serialVersionUID = -900631221474032854L;
    private static final Color MARK_GREEN_COLOR = new Color(0, 153, 0);
    private AbstractMapEditorPanel editorPanel;
    private Map<AreaObjectModel, Color> areaObjectColorCache = new LinkedHashMap<AreaObjectModel, Color>();
    private Map<LetterLocationObject, Tupel<ImmutablePoint, Double>> drawedLettersOnMap = new LinkedHashMap<LetterLocationObject, Tupel<ImmutablePoint, Double>>();
    private AreaPointRenderer areaPointRenderer = null;
    private LetterFilterPatternSetupRendererSelektor letterFilterPatternSetupSelektor;
    private CyclingIterator<Color> cyclingColorIterator;
    protected AreaLayerModel layer;
    private TimeRange timeRange;

    public LetterFilterableMarkerRenderer(String name, String title, AbstractMapEditorPanel editorPanel, Double maxUpp, GeoObjectBucketsModel<LetterLocationObject, ImmutablePoint> bucketsModel, AreaLayerModel layer) {
        super(name, title, editorPanel.getNavigatorPanel(), null, null, new DummyPointRenderer(), maxUpp, bucketsModel, true);
        this.editorPanel = editorPanel;
        ((DummyPointRenderer)this.getPointRenderer()).setLetterRenderer(this);
        this.cyclingColorIterator = new CyclingIterator<Color>(PaintUtil.RANDOM_COLORS);
        this.layer = layer;
    }

    @Override
    public synchronized Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        this.drawedLettersOnMap.clear();
        return super.paintOnto(g2d, realBoundaryBottomLeft, realBoundaryTopRight, upp);
    }

    @Override
    protected void drawHover(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, Collection<LetterLocationObject> hovers, double upp) {
        double margin = 10.0 * upp;
        for (LetterLocationObject letterLocationObject : hovers) {
            if (letterLocationObject == null) continue;
            this.createInfobox((LetterModel)letterLocationObject.getModel(), margin, letterLocationObject.getImmutablePoint());
        }
    }

    @Override
    protected void paintSpecialElements(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        for (LetterLocationObject letter : this.drawedLettersOnMap.keySet()) {
            int count = 0;
            Tupel<ImmutablePoint, Double> tupel = this.drawedLettersOnMap.get(letter);
            CoordinateFactory coordinateFactory = this.getNavigatorPanel().getCoordinateFactory();
            Rectangle2D.Double rectangle = DefaultPointRenderer.getRectangle(((ImmutablePoint)tupel.getElement1().getTransformed(coordinateFactory)).getCoordinate(), tupel.getElement2() * 2.0, tupel.getElement2() * 1.5);
            Color colorOfAreaObject = this.areaObjectColorCache.get(((LetterModel)letter.getModel()).getAreaObject());
            for (Tupel<ImmutablePoint, Double> t : this.drawedLettersOnMap.values()) {
                Rectangle2D.Double r = DefaultPointRenderer.getRectangle(((ImmutablePoint)t.getElement1().getTransformed(coordinateFactory)).getCoordinate(), t.getElement2() * 2.0, tupel.getElement2() * 1.5);
                if (!r.contains(rectangle)) continue;
                ++count;
            }
            if (count <= true) continue;
            Coordinate c = coordinateFactory.createCoordinate(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            RendererNode node = new RendererNode(String.valueOf(count), c, tupel.getElement2());
            node.setFontground(colorOfAreaObject);
            this.areaPointRenderer.drawText(node);
        }
    }

    private void createInfobox(LetterModel letter, double margin, ImmutablePoint geom) {
        List<String> infoBox = LetterModelUtil.getInfoBoxString(letter);
        Color colorOfAreaObject = this.areaObjectColorCache.get(letter.getAreaObject());
        if (geom != null && this.areaPointRenderer != null) {
            this.areaPointRenderer.drawInfoBox(infoBox, geom.getCoordinate(), colorOfAreaObject, margin);
        }
    }

    public void setLetterFilterPatternSetupModel(LetterFilterPatternSetupModel letterFilterPatternSetupModel, ModelEnviroment modelEnviroment) {
        this.clearRendererCache();
        LetterFilterPatternSetupRendererSelektor letterFilterPatternSetupRendererSelektor = this.letterFilterPatternSetupSelektor = letterFilterPatternSetupModel == null ? null : new LetterFilterPatternSetupRendererSelektor(letterFilterPatternSetupModel, modelEnviroment);
        if (this.letterFilterPatternSetupSelektor == null) {
            this.setRendererChecker(null);
        } else {
            this.setRendererChecker(new RendererChecker<LetterLocationObject>(){

                @Override
                public boolean isToBeRendered(LetterLocationObject w) {
                    return LetterFilterableMarkerRenderer.this.letterFilterPatternSetupSelektor.isToBeRendered(w.getModel());
                }
            });
        }
        this.getNavigatorPanel().repaint(10L);
    }

    @Override
    protected AbstractFilterPatternSetupRendererSelektor<?, LetterModel, ?, ?, ?, ?, ?, ?, ?> getFilterPatternSetupRendererSelektor() {
        return this.letterFilterPatternSetupSelektor;
    }

    @Override
    protected int getCycles() {
        return 1;
    }

    @Override
    public void showMarked(Collection<LetterLocationObject> markedObjects) {
        if (markedObjects == null) {
            return;
        }
        Collection<LetterModel> letters = this.createLetterCollection(markedObjects);
        LinkedList<LetterLocationObject> markedObjectsOnlyInLayer = new LinkedList<LetterLocationObject>();
        for (LetterLocationObject sub : markedObjects) {
            if (!this.isProperLayer(sub)) continue;
            markedObjectsOnlyInLayer.add(sub);
        }
        CollectionUtil.transform(markedObjectsOnlyInLayer, letters, new Transformer<LetterLocationObject, LetterModel>(){

            @Override
            public LetterModel transform(LetterLocationObject t) {
                return (LetterModel)t.getModel();
            }
        });
        this.editorPanel.updatePanelAfterMark(this.getRenderObjectType(), letters);
    }

    protected boolean isProperLayer(LetterLocationObject sub) {
        return ((LetterModel)sub.getModel()).getAreaLayer() == this.layer;
    }

    protected Collection<LetterModel> createLetterCollection(Collection<LetterLocationObject> markedObjects) {
        return new HashSet<LetterModel>(markedObjects.size());
    }

    @Override
    protected void showClicked(Collection<LetterLocationObject> cs) {
        ArrayList<LetterLocationObject> filtered = new ArrayList<LetterLocationObject>(cs.size());
        for (LetterLocationObject locationObject : cs) {
            if (!this.isProperLayer(locationObject)) continue;
            filtered.add(locationObject);
        }
        if (!filtered.isEmpty()) {
            ArrayList<LetterModel> letters = new ArrayList<LetterModel>(filtered.size());
            CollectionUtil.transform(filtered, letters, new Transformer<LetterLocationObject, LetterModel>(){

                @Override
                public LetterModel transform(LetterLocationObject object) {
                    return (LetterModel)object.getModel();
                }
            });
            LetterDialog letterDialog = new LetterDialog(SwingUtils.findWindowParent(this.getNavigatorPanel()), letters, this.editorPanel.getModelEnviroment());
            letterDialog.setInternalFrame(this.getInternalFrame());
            letterDialog.setVisible(true);
        }
    }

    protected PausableInternalFrame getInternalFrame() {
        return null;
    }

    @Override
    protected boolean isToDrawObject(LetterLocationObject s) {
        if (this.timeRange == null) {
            return false;
        }
        LetterModel model = (LetterModel)s.getModel();
        AreaLayerModel areaLayer = model.getAreaLayer();
        if (this.layer == null || areaLayer != null && areaLayer.equals(this.layer)) {
            Date date = model.getDate();
            Date start = this.timeRange.getStart();
            Date end = this.timeRange.getEnd();
            return TimeUtil.isSamedDay(date, start) || TimeUtil.isSamedDay(date, end) || date.after(start) && date.before(end);
        }
        return false;
    }

    @Override
    public AbstractFilterableMarkerNavigatorRenderer.RenderObjectType getRenderObjectType() {
        return AbstractFilterableMarkerNavigatorRenderer.RenderObjectType.LETTERRENDERER;
    }

    public void removeMarkedLetters(Collection<LetterModel> letters) {
        HashSet<LetterModel> set = new HashSet<LetterModel>(letters);
        Collection markedObjects = this.getMarkedObjects();
        ArrayList<LetterLocationObject> list = new ArrayList<LetterLocationObject>(letters.size());
        for (LetterLocationObject letterLocationObject : markedObjects) {
            if (!set.contains(letterLocationObject.getModel())) continue;
            list.add(letterLocationObject);
        }
        this.removeMarkedObjects(list);
    }

    @Override
    protected Iterable<? extends Model> getChangeListeningModels(LetterLocationObject s) {
        return ((LetterModel)s.getModel()).iterableLetterAttributeValues();
    }

    @Override
    public void defaultSelectionChanged(PatterLegendSelectionEvent<LetterFilterModel> event) {
        super.defaultSelectionChanged(event);
        if (this.letterFilterPatternSetupSelektor != null) {
            this.letterFilterPatternSetupSelektor.setShowFilterDefault(event.isSelected());
        }
        this.editorPanel.getNavigatorPanel().repaint(10L);
    }

    @Override
    public void filterSelectionChanged(PatterLegendSelectionEvent<LetterFilterModel> event) {
        super.filterSelectionChanged(event);
        if (this.letterFilterPatternSetupSelektor != null) {
            this.letterFilterPatternSetupSelektor.turnFilter(event.getObjectFilter(), event.isSelected());
        }
        this.editorPanel.getNavigatorPanel().repaint(10L);
    }

    public void setTimeRange(TimeRange timeRange) {
        this.timeRange = timeRange;
        ((TimeBasedGeoObjectBucketsModel)this.getBucketsModel()).setCurrentTimeRange(timeRange);
        this.getNavigatorPanel().repaint(10L);
    }

    @Override
    public GeoObjectBucketsModel<LetterLocationObject, ImmutablePoint> getBucketsModel() {
        return super.getBucketsModel();
    }

    public AreaPointRenderer getAreaPointRenderer() {
        return this.areaPointRenderer;
    }

    protected static class DummyPointRenderer
    extends AbstractRenderer<DefaultRendererProperties, ImmutablePoint, LetterLocationObject>
    implements PointRenderer<DefaultRendererProperties, LetterLocationObject> {
        protected LetterFilterableMarkerRenderer renderer;
        private boolean showHouseNumber = false;

        protected DummyPointRenderer() {
        }

        @Override
        public DefaultRendererProperties createRendererProperties(LetterLocationObject u) {
            return new DefaultRendererProperties();
        }

        @Override
        public void render(Graphics2D g2d, LetterLocationObject object, ImmutablePoint geom, DefaultRendererProperties rendererProperties) {
            double upp = rendererProperties.getUpp();
            double margin = 10.0 * Math.pow(upp, -0.2) * upp;
            this.renderer.areaPointRenderer = new AreaPointRenderer(g2d, upp, geom.getCoordinateFactory());
            Color colorOfAreaObject = Color.WHITE;
            AreaObjectModel areaObject = ((LetterModel)object.getModel()).getAreaObject();
            if (areaObject != null && (colorOfAreaObject = (Color)this.renderer.areaObjectColorCache.get(areaObject)) == null) {
                colorOfAreaObject = (Color)this.renderer.cyclingColorIterator.next();
                this.renderer.areaObjectColorCache.put(areaObject, colorOfAreaObject);
            }
            colorOfAreaObject = new Color(colorOfAreaObject.getRed(), colorOfAreaObject.getGreen(), colorOfAreaObject.getBlue(), 150);
            if (this.renderer.getMarkedObjects().contains(object)) {
                colorOfAreaObject = ObjectMarkerNavigatorRenderer.MARK_COLOR;
            }
            RendererNode node = this.createRendererNode(object, geom, margin, colorOfAreaObject);
            this.renderer.areaPointRenderer.drawBuilding(node, false);
            this.renderer.drawedLettersOnMap.put(object, new Tupel<ImmutablePoint, Double>(geom, margin));
        }

        protected RendererNode createRendererNode(LetterLocationObject object, ImmutablePoint geom, double margin, Color colorOfAreaObject) {
            String string = null;
            if (this.showHouseNumber) {
                LocationModel location = ((LetterModel)object.getModel()).getLocation();
                LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
                string = FormUtil.getStringDisplay(locationWrapper.getHousenumber() == null ? null : String.valueOf(locationWrapper.getHousenumber())) + FormUtil.getStringDisplay(locationWrapper.getHousenumberExtension());
            }
            return new RendererNode(string, geom.getCoordinate(), this.getFrameColor((LetterModel)object.getModel()), colorOfAreaObject, margin);
        }

        protected Color getFrameColor(LetterModel model) {
            return Color.BLACK;
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Dimension getOptimalPreviewDimension() {
            return new Dimension(10, 10);
        }

        public void setLetterRenderer(LetterFilterableMarkerRenderer letterRenderer) {
            this.renderer = letterRenderer;
            if (StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("letter.renderer.houseNumber.show"))) {
                this.showHouseNumber = true;
            }
        }

        @Override
        public void render(Graphics2D g2d, LetterLocationObject u, Collection<ImmutablePoint> geom, DefaultRendererProperties rendererProperties) {
            for (ImmutablePoint point : geom) {
                this.render(g2d, u, point, rendererProperties);
            }
        }
    }
}

