/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.letter;

import de.datomino.peppergis.client.gui.area.AreaLayerComboBox;
import de.datomino.peppergis.client.gui.area.AreaObjectComboBox;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.LetterDeliveryType;
import de.datomino.util.common.PrimitiveUtil;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.time.TimeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.Transformer;
import org.ktde.util.StringUtil;

public class BasicLetterPane
extends JPanel {
    private static final long serialVersionUID = -3647790887499691564L;
    private LetterModel letterModel;
    private JTextField letterNumber;
    private JTextArea information;
    private AreaObjectComboBox area;
    private AreaLayerComboBox layer;
    private ModelEnviroment modelEnviroment;
    private EnumComboBox<LetterDeliveryType> letterDeliveryType;
    private JFormattedTextField date;
    private JTextField firstName;
    private JTextField lastName;
    private JTextField companyName;

    public BasicLetterPane(LetterModel letterModel, ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.letterModel = letterModel;
        this.buildLayout();
        this.setLetterModel(letterModel);
    }

    public void setLetterModel(LetterModel letterModel) {
        this.letterModel = letterModel;
        if (this.letterModel == null) {
            this.letterNumber.setText("");
            this.information.setText("");
            this.area.setSelectedIndex(0);
            this.layer.setSelectedIndex(0);
            this.letterDeliveryType.setSelectedValue(LetterDeliveryType.OWN);
            Date now = new Date();
            this.date.setValue(now);
            this.firstName.setText("");
            this.lastName.setText("");
            this.companyName.setText("");
        } else {
            this.letterNumber.setText(this.letterModel.getLetterNumber());
            this.information.setText(this.letterModel.getInformation());
            this.information.setCaretPosition(0);
            AreaObjectModel areaObjectModel = this.letterModel.getAreaObject();
            AreaLayerModel areaLayerModel = this.letterModel.getAreaLayer();
            if (areaObjectModel == null) {
                this.layer.setSelectedIndex(0);
                if (areaLayerModel == null) {
                    this.area.setSelectedIndex(0);
                } else {
                    this.layer.setSelectedItem(areaLayerModel);
                }
            } else {
                areaLayerModel = areaObjectModel.getAreaLayer();
                this.layer.setSelectedItem(areaLayerModel);
                this.area.setSelectedItem(areaObjectModel);
            }
            LetterDeliveryType deliveryType = this.letterModel.getDeliveryType();
            if (deliveryType == null) {
                deliveryType = LetterDeliveryType.OWN;
            }
            this.letterDeliveryType.setSelectedValue(deliveryType);
            this.date.setValue(this.letterModel.getDate());
            this.firstName.setText(StringUtil.nullToEmpty(letterModel.getFirstName()));
            this.lastName.setText(StringUtil.nullToEmpty(letterModel.getLastName()));
            this.companyName.setText(StringUtil.nullToEmpty(letterModel.getCompanyName()));
        }
    }

    public void adaptValuesToModel() {
        if (this.letterModel != null) {
            this.letterModel.setInformation(this.information.getText());
            AreaObjectModel areaObject = (AreaObjectModel)this.area.getSelectedItem();
            this.letterModel.setAreaObject(areaObject);
            this.letterModel.setAreaLayer((AreaLayerModel)this.layer.getSelectedItem());
            this.letterModel.setDeliveryType(this.letterDeliveryType.getSelectedValue());
            Date dateValue = (Date)this.date.getValue();
            if (dateValue != null) {
                dateValue = TimeUtil.normalize(dateValue);
            }
            this.letterModel.setDate(dateValue);
            this.letterModel.setFirstName(this.firstName.getText());
            this.letterModel.setLastName(this.lastName.getText());
            this.letterModel.setCompanyName(this.companyName.getText());
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.information.setEnabled(enabled);
        this.layer.setEnabled(enabled);
        this.area.setEnabled(enabled);
        this.letterDeliveryType.setEnabled(enabled);
        this.date.setEditable(enabled);
        this.firstName.setEditable(enabled);
        this.lastName.setEditable(enabled);
        this.companyName.setEditable(enabled);
    }

    private void buildLayout() {
        JPanel outerPanel = new JPanel(new BorderLayout());
        JPanel mainPanel = new JPanel(new SpringLayout());
        mainPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.letterNumber", new Serializable[0])));
        this.letterNumber = new JTextField(30);
        this.letterNumber.setEditable(false);
        mainPanel.add(this.letterNumber);
        mainPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.customer.firstName", new Serializable[0])));
        this.firstName = new JTextField(30);
        this.firstName.setEditable(false);
        mainPanel.add(this.firstName);
        mainPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.customer.lastName", new Serializable[0])));
        this.lastName = new JTextField(30);
        this.lastName.setEditable(false);
        mainPanel.add(this.lastName);
        mainPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.customer.companyName", new Serializable[0])));
        this.companyName = new JTextField(30);
        this.companyName.setEditable(false);
        mainPanel.add(this.companyName);
        mainPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.layer", new Serializable[0])));
        this.layer = new AreaLayerComboBox(this.modelEnviroment, true, AreaObjectGenInfoDiscriminator.values(), true, false);
        this.layer.addActionListener(new LayerActionListener());
        mainPanel.add(this.layer);
        mainPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.area", new Serializable[0])));
        this.area = new AreaObjectComboBox(true){
            private static final long serialVersionUID = 3101821871856266950L;

            @Override
            protected String getStringRepresentation(AreaObjectModel t) {
                return AreaObjectModelUtil.getShortcutAndDisplayname(t);
            }
        };
        mainPanel.add(this.area);
        mainPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(LetterDeliveryType.class.getName(), new Serializable[0])));
        this.letterDeliveryType = new EnumComboBox<LetterDeliveryType>(LetterDeliveryType.class, false);
        mainPanel.add(this.letterDeliveryType);
        mainPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.date", new Serializable[0])));
        this.date = new JFormattedTextField(new SimpleDateFormat("yyyy-MM-dd"));
        mainPanel.add(this.date);
        JLabel label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]));
        label.setVerticalAlignment(1);
        mainPanel.add(label);
        this.information = new JTextArea(5, 30);
        mainPanel.add(new JScrollPane(this.information));
        SpringUtilities.makeCompactGrid(mainPanel, 9, 2, 5, 5, 2, 2);
        outerPanel.add((Component)mainPanel, "West");
        this.add((Component)outerPanel, "North");
    }

    private class LayerActionListener
    implements ActionListener {
        private LayerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AreaLayerModel newLayer = (AreaLayerModel)BasicLetterPane.this.layer.getSelectedItem();
            if (newLayer == null) {
                BasicLetterPane.this.area.setModels(null);
            } else {
                AreaLayerModel currentLayer;
                AreaObjectModel selectedItem = (AreaObjectModel)BasicLetterPane.this.area.getSelectedItem();
                AreaLayerModel areaLayerModel = currentLayer = selectedItem == null ? null : selectedItem.getAreaLayer();
                if (!PrimitiveUtil.equalsNullSafe(currentLayer, newLayer)) {
                    DefaultComboBoxModel dcm = (DefaultComboBoxModel)BasicLetterPane.this.area.getModel();
                    dcm.removeAllElements();
                    ArrayList<AreaObjectModel> list = new ArrayList<AreaObjectModel>(newLayer.countAreaObjects());
                    for (AreaObjectModel areaObject : newLayer.iterableAreaObjects()) {
                        list.add(areaObject);
                    }
                    Collections.sort(list, ComparatorUtils.chainedComparator(ComparatorUtils.transformedComparator(ComparatorUtils.naturalComparator(), new Transformer(){

                        @Override
                        public Object transform(Object input) {
                            return StringUtil.nullToEmpty(((AreaObjectModel)input).getShortcut());
                        }
                    }), ComparatorUtils.transformedComparator(ComparatorUtils.naturalComparator(), new Transformer(){

                        @Override
                        public Object transform(Object input) {
                            return StringUtil.nullToEmpty(((AreaObjectModel)input).getDisplayname());
                        }
                    })));
                    dcm.addElement("");
                    for (AreaObjectModel areaObjectModel : list) {
                        dcm.addElement(areaObjectModel);
                    }
                }
            }
        }
    }
}

