/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.image;

import de.datomino.peppergis.client.gui.common.AbstractStringListCellRenderer;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.ImageModel;
import de.datomino.peppergis.client.model.base.ImageModelImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FileUtils;

public class ImageListChooserPane
extends JPanel {
    private static final long serialVersionUID = -7019003583243294507L;
    private JList images;
    private JTextField name;
    private JLabel imagePreview;
    private AddImageAction addImageAction;
    private RemoveImageAction removeImageAction;
    private ModelEnviroment modelEnviroment;
    private boolean editable;

    public ImageListChooserPane(ModelEnviroment modelEnviroment) {
        this(modelEnviroment, true);
    }

    public ImageListChooserPane(ModelEnviroment modelEnviroment, boolean editable) {
        super(new BorderLayout());
        this.editable = editable;
        this.modelEnviroment = modelEnviroment;
        this.buildLayout(editable);
        this.loadImages();
    }

    private void loadImages() {
        Collection<ImageModel> images = this.modelEnviroment.getAllCaller().getBaseCaller().getAllImages();
        DefaultListModel dlm = (DefaultListModel)this.images.getModel();
        for (ImageModel imageModel : images) {
            dlm.addElement(imageModel);
        }
    }

    private void buildLayout(boolean editable) {
        JSplitPane split = new JSplitPane(1);
        JPanel listPanel = new JPanel(new BorderLayout());
        this.images = new JList(new DefaultListModel());
        this.images.setSelectionMode(0);
        this.images.addListSelectionListener(new ImageListSelectionListener());
        this.images.setCellRenderer(new AbstractStringListCellRenderer(this.images.getCellRenderer()){

            @Override
            protected String getString(Object value) {
                ImageModel imageModel = (ImageModel)value;
                return imageModel.getName();
            }
        });
        JScrollPane scroll = new JScrollPane(this.images);
        scroll.setHorizontalScrollBarPolicy(32);
        listPanel.add((Component)scroll, "Center");
        if (editable) {
            JPanel buttonPanel = new JPanel(new BorderLayout());
            this.addImageAction = new AddImageAction();
            JButton add = new JButton(this.addImageAction);
            buttonPanel.add((Component)add, "East");
            this.removeImageAction = new RemoveImageAction();
            JButton remove = new JButton(this.removeImageAction);
            buttonPanel.add((Component)remove, "West");
            listPanel.add((Component)buttonPanel, "South");
        }
        split.setLeftComponent(listPanel);
        JPanel imagePanel = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)new JLabel(" " + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0]) + " "), "West");
        this.name = new JTextField(10);
        this.name.getDocument().addDocumentListener(new ImageDocumentListener());
        this.name.setEditable(editable);
        topPanel.add((Component)this.name, "Center");
        imagePanel.add((Component)topPanel, "North");
        this.imagePreview = new JLabel();
        this.imagePreview.setVerticalAlignment(0);
        this.imagePreview.setHorizontalAlignment(0);
        imagePanel.add((Component)new JScrollPane(this.imagePreview), "Center");
        split.setRightComponent(imagePanel);
        this.add((Component)split, "Center");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.editable) {
            boolean selected = enabled && !this.images.isSelectionEmpty();
            this.addImageAction.setEnabled(enabled);
            this.name.setEditable(selected);
            this.removeImageAction.setEnabled(selected);
        }
    }

    public Long getSelectedImageModelId() {
        ImageModel imageModel = (ImageModel)this.images.getSelectedValue();
        return imageModel == null ? null : imageModel.getId();
    }

    public ImageModel getSelectedImage() {
        return (ImageModel)this.images.getSelectedValue();
    }

    private class ImageDocumentListener
    implements DocumentListener {
        private ImageDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ImageModel imageModel = (ImageModel)ImageListChooserPane.this.images.getSelectedValue();
            imageModel.setName(ImageListChooserPane.this.name.getText());
            ImageListChooserPane.this.images.repaint(1L);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ImageModel imageModel = (ImageModel)ImageListChooserPane.this.images.getSelectedValue();
            imageModel.setName(ImageListChooserPane.this.name.getText());
            ImageListChooserPane.this.images.repaint(1L);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ImageModel imageModel = (ImageModel)ImageListChooserPane.this.images.getSelectedValue();
            imageModel.setName(ImageListChooserPane.this.name.getText());
            ImageListChooserPane.this.images.repaint(1L);
        }
    }

    private class ImageListSelectionListener
    implements ListSelectionListener {
        private ImageListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ImageListChooserPane.this.setEnabled(ImageListChooserPane.this.isEnabled());
            ImageModel imageModel = (ImageModel)ImageListChooserPane.this.images.getSelectedValue();
            if (imageModel != null) {
                ImageListChooserPane.this.name.setText(imageModel.getName());
                byte[] data = imageModel.getData();
                ImageListChooserPane.this.imagePreview.setIcon(data == null || data.length == 0 ? null : new ImageIcon(data));
            }
        }
    }

    private class AddImageAction
    extends AbstractAction {
        private static final long serialVersionUID = 6657036072270732347L;

        private AddImageAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int d;
            File dir;
            JFileChooser fc = new JFileChooser();
            fc.setMultiSelectionEnabled(false);
            for (FileFilter fileFilter : fc.getChoosableFileFilters()) {
                fc.removeChoosableFileFilter(fileFilter);
            }
            fc.setFileSelectionMode(0);
            FileNameExtensionFilter first = new FileNameExtensionFilter("GIF", "gif", "GIF");
            fc.addChoosableFileFilter(first);
            fc.addChoosableFileFilter(new FileNameExtensionFilter("JPEG", "jpg", "jpeg", "JPG", "JPEG"));
            fc.addChoosableFileFilter(new FileNameExtensionFilter("PNG", "png", "PNG"));
            fc.setFileFilter(first);
            String directory = ModelEnviroment.getProperties().getProperty("global.file.directory");
            if (directory != null && (dir = new File(directory)).exists()) {
                fc.setCurrentDirectory(dir);
            }
            if ((d = fc.showOpenDialog(ImageListChooserPane.this)) == 0) {
                File dir2 = fc.getCurrentDirectory();
                try {
                    ModelEnviroment.getProperties().setDynamicProperty("global.file.directory", dir2.getCanonicalPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                File file = fc.getSelectedFile();
                ImageModelImpl imageModel = new ImageModelImpl();
                imageModel.setName(ModelEnviroment.getMessageResolver().resolveMessage("messages.images.newImage", new Serializable[0]));
                try {
                    byte[] data = FileUtils.readFileToByteArray(file);
                    imageModel.setData(data);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                DefaultListModel dlm = (DefaultListModel)ImageListChooserPane.this.images.getModel();
                dlm.addElement(imageModel);
                ImageListChooserPane.this.images.setSelectedValue(imageModel, true);
                ImageListChooserPane.this.name.select(0, ImageListChooserPane.this.name.getText().length());
                ImageListChooserPane.this.name.requestFocusInWindow();
            }
        }
    }

    private class RemoveImageAction
    extends AbstractAction {
        private static final long serialVersionUID = 4820863861952262954L;

        private RemoveImageAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.remove", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImageModel imageModel = (ImageModel)ImageListChooserPane.this.images.getSelectedValue();
            imageModel.delete();
            DefaultListModel dlm = (DefaultListModel)ImageListChooserPane.this.images.getModel();
            dlm.removeElement(imageModel);
        }
    }
}

