/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.image;

import de.datomino.peppergis.client.gui.image.ImageComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.ImageModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImageComboBoxChooserPane
extends JPanel {
    private static final long serialVersionUID = 303170632458214565L;
    private ImageComboBox images;
    private JLabel imagePreview;
    private ModelEnviroment modelEnviroment;

    public ImageComboBoxChooserPane(ModelEnviroment modelEnviroment) {
        this("North", modelEnviroment);
    }

    public ImageComboBoxChooserPane(String orientation, ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.buildLayout(orientation);
    }

    private void buildLayout(String orientation) {
        this.images = new ImageComboBox(this.modelEnviroment.getAllCaller().getBaseCaller().getAllImages(), true);
        this.images.addActionListener(new ImageActionListener());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.images, "North");
        this.add((Component)panel, orientation);
        this.imagePreview = new JLabel();
        this.imagePreview.setVerticalAlignment(0);
        this.imagePreview.setHorizontalAlignment(0);
        this.imagePreview.setPreferredSize(new Dimension(100, 100));
        this.add((Component)this.imagePreview, "Center");
    }

    public ImageModel getSelectedItem() {
        return (ImageModel)this.images.getSelectedItem();
    }

    public void setSelectedItem(ImageModel imageModel) {
        this.images.setSelectedItem(imageModel);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.images.setEnabled(enabled);
    }

    public void addActionListener(ActionListener actionListener) {
        this.images.addActionListener(actionListener);
    }

    private class ImageActionListener
    implements ActionListener {
        private ImageActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImageModel image = (ImageModel)ImageComboBoxChooserPane.this.images.getSelectedItem();
            if (image == null) {
                ImageComboBoxChooserPane.this.imagePreview.setIcon(null);
            } else {
                ImageComboBoxChooserPane.this.imagePreview.setIcon(new ImageIcon(image.getData()));
            }
        }
    }
}

