/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.filter.pattern.renderer;

import de.datomino.peppergis.client.gui.filter.AbstractFilterComboBox;
import de.datomino.peppergis.client.gui.filter.pattern.renderer.FilterPatternParameterTableModel;
import de.datomino.peppergis.client.gui.renderer.editor.ValueEditor;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModel;
import de.datomino.peppergis.client.util.wrapper.common.filter.ModelFilterPatternParameter;
import de.datomino.peppergis.type.RendererType;
import de.datomino.peppergis.type.filter.FilterPatternParameter;
import de.datomino.peppergis.type.filter.FilterPatternRelation;
import de.datomino.peppergis.type.filter.ObjectFilter;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.ktde.util.datatypes.Tripel;

public abstract class AbstractRendererPane<T extends Model, S extends Model, U extends Model, V extends Model, W extends Model, X extends ImmutableGeoObject, Y extends RendererProperties, Z extends Model>
extends JPanel {
    private static final long serialVersionUID = 4254429580005782816L;
    private FilterPatternRelation<T, S, U, V, AttributeValueFilterModel, Z, AreaLayerModel> modelFilterPatternRelation;
    private JTable table;
    private FilterPatternParameterTableModel<V> filterPatternParameterTableModel;

    public AbstractRendererPane() {
        super(new BorderLayout());
        this.buildLayout();
    }

    private void buildLayout() {
        this.filterPatternParameterTableModel = new FilterPatternParameterTableModel(this);
        this.table = new JTable(this.filterPatternParameterTableModel);
        this.table.setDefaultRenderer(ObjectFilter.class, new DefaultTableCellRenderer());
        AbstractFilterComboBox<V> comboBox = this.createNewFilterComboBox();
        this.table.setDefaultEditor(ObjectFilter.class, new AbstractFilterComboBox.CellEditor(comboBox));
        this.table.setDefaultRenderer(Component.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return (Component)value;
            }
        });
        this.table.setDefaultEditor(Component.class, new TableCellEditor(){

            @Override
            public boolean stopCellEditing() {
                return true;
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                return false;
            }

            @Override
            public void removeCellEditorListener(CellEditorListener l) {
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                return true;
            }

            @Override
            public Object getCellEditorValue() {
                return null;
            }

            @Override
            public void cancelCellEditing() {
            }

            @Override
            public void addCellEditorListener(CellEditorListener l) {
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return (Component)value;
            }
        });
        this.table.setRowHeight((int)((double)this.table.getRowHeight() * 1.5));
        this.table.setTableHeader(null);
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    protected abstract AbstractFilterComboBox<V> createNewFilterComboBox();

    public abstract RendererType getRendererType();

    protected abstract String[] getParameterKeys();

    protected abstract ValueEditor<?> getParameterEditor(String var1);

    public void setFilterPatternRelation(FilterPatternRelation<T, S, U, V, AttributeValueFilterModel, Z, AreaLayerModel> modelFilterPatternRelation) {
        this.modelFilterPatternRelation = modelFilterPatternRelation;
        if (modelFilterPatternRelation == null) {
            List emptyList = Collections.emptyList();
            this.filterPatternParameterTableModel = new FilterPatternParameterTableModel(this);
            this.filterPatternParameterTableModel.setParameters(emptyList);
            this.table.setModel(this.filterPatternParameterTableModel);
        } else {
            if (modelFilterPatternRelation.getRendererType() != this.getRendererType()) {
                throw new IllegalArgumentException();
            }
            List parameters = this.modelFilterPatternRelation.getFilterPatternParameter();
            this.filterPatternParameterTableModel = new FilterPatternParameterTableModel(this);
            this.filterPatternParameterTableModel.setParameters(parameters);
            this.table.setModel(this.filterPatternParameterTableModel);
        }
    }

    public void adaptValuesToModel() {
        if (this.modelFilterPatternRelation != null) {
            this.modelFilterPatternRelation.setRendererType(this.getRendererType());
            List<FilterPatternParameter<U, T, S, V, AttributeValueFilterModel, Z, AreaLayerModel>> parameters = this.modelFilterPatternRelation.getFilterPatternParameter();
            for (FilterPatternParameter filterPatternParameter : parameters) {
                filterPatternParameter.setRelation(null);
                ((Model)filterPatternParameter.getAttachedObject()).delete();
            }
            List<Tripel<String, ObjectFilter<V, AttributeValueFilterModel>, ValueEditor<?>>> currentValues = this.filterPatternParameterTableModel.getParameterList();
            for (Tripel<String, ObjectFilter<V, AttributeValueFilterModel>, ValueEditor<?>> tripel : currentValues) {
                ModelFilterPatternParameter<S, U, T, V, Z> filterPatternParameter = this.createNewFilterPatternParameter();
                String parameterKey = tripel.getElement1();
                filterPatternParameter.setRelation(this.modelFilterPatternRelation);
                filterPatternParameter.setParameterKey(parameterKey);
                String serializedValue = tripel.getElement3().getSerializedValue();
                filterPatternParameter.setParameterValue(serializedValue);
                filterPatternParameter.setObjectFilter(tripel.getElement2());
            }
        }
    }

    protected abstract ModelFilterPatternParameter<U, T, S, V, Z> createNewFilterPatternParameter();

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.table.setEnabled(enabled);
    }
}

