/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.filter.pattern.legend.print;

import de.datomino.peppergis.client.gui.filter.pattern.legend.AbstractLegendPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModel;
import de.datomino.peppergis.client.util.wrapper.common.filter.ModelFilterPatternSetup;
import de.datomino.peppergis.type.RendererType;
import de.datomino.peppergis.type.filter.ObjectFilter;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.ktde.util.datatypes.Quad;
import org.ktde.util.datatypes.Tupel;

public class FilterLegendPrintPane<T extends Model, S extends Model, U extends Model, V extends Model, W extends Model, X extends Model>
extends AbstractLegendPane<T, S, U, V, X> {
    private static final long serialVersionUID = -2182120800192768293L;
    private AbstractLegendPane.SymbolType symbolType;
    private ModelEnviroment modelEnviroment;
    private ModelFilterPatternSetup<S, T, U, V, X> modelFilterPatternSetup;
    private List<Tupel<ObjectFilter<V, AttributeValueFilterModel>, JCheckBox>> checkBoxes;
    private List<Tupel<ObjectFilter<V, AttributeValueFilterModel>, JTextField>> textFields;
    private JCheckBox defaultCheckbox;
    private JTextField defaultTextField;
    private Map<ObjectFilter<V, AttributeValueFilterModel>, RendererType> rendererTypeMap;
    private Map<ObjectFilter<V, AttributeValueFilterModel>, List<Tupel<String, String>>> highestParamMap;
    private List<Tupel<String, String>> defaultParams;
    private RendererType defaultRendererType;

    public FilterLegendPrintPane(ModelFilterPatternSetup<S, T, U, V, X> modelFilterPatternSetup, AbstractLegendPane.SymbolType symbolType, ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.symbolType = symbolType;
        this.modelFilterPatternSetup = modelFilterPatternSetup;
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
    }

    private void buildLayout() {
        JPanel panel = new JPanel(new SpringLayout());
        Quad<Map<ObjectFilter<V, AttributeValueFilterModel>, List<Tupel<String, String>>>, Map<ObjectFilter<V, AttributeValueFilterModel>, RendererType>, List<Tupel<String, String>>, RendererType> rendererInformation = this.getRendererInformation(this.modelFilterPatternSetup);
        this.highestParamMap = rendererInformation.getElement1();
        this.rendererTypeMap = rendererInformation.getElement2();
        this.defaultParams = rendererInformation.getElement3();
        this.defaultRendererType = rendererInformation.getElement4();
        int size = this.highestParamMap.size();
        this.checkBoxes = new ArrayList<Tupel<ObjectFilter<V, AttributeValueFilterModel>, JCheckBox>>(size);
        this.textFields = new ArrayList<Tupel<ObjectFilter<V, AttributeValueFilterModel>, JTextField>>(size);
        for (Map.Entry<ObjectFilter<V, AttributeValueFilterModel>, List<Tupel<String, String>>> entry : this.highestParamMap.entrySet()) {
            ObjectFilter<V, AttributeValueFilterModel> objectFilter = entry.getKey();
            String name = objectFilter == null ? ModelEnviroment.getMessageResolver().resolveMessage("messages.default.default", new Serializable[0]) : objectFilter.getName();
            final JCheckBox checkBox = new JCheckBox(name, true);
            panel.add(checkBox);
            this.checkBoxes.add(new Tupel<ObjectFilter<V, AttributeValueFilterModel>, JCheckBox>(objectFilter, checkBox));
            RendererType rendererType = this.rendererTypeMap.get(objectFilter);
            List<Tupel<String, String>> params = entry.getValue();
            for (Tupel<String, String> dParam : this.defaultParams) {
                boolean found = false;
                for (Tupel<String, String> param : params) {
                    if (!dParam.getElement1().equals(param.getElement1())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                params.add(dParam);
            }
            panel.add(this.createRendererPanel(rendererType, params, this.symbolType, this.modelEnviroment));
            final JTextField textField = new JTextField(name, 20);
            panel.add(textField);
            this.textFields.add(new Tupel<ObjectFilter<V, AttributeValueFilterModel>, JTextField>(objectFilter, textField));
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    textField.setEnabled(checkBox.isSelected());
                }
            });
        }
        this.defaultCheckbox = new JCheckBox("", true);
        panel.add(this.defaultCheckbox);
        RendererType rendererType = this.defaultRendererType == null ? RendererType.INVISIBLE : this.defaultRendererType;
        panel.add(this.createRendererPanel(rendererType, this.defaultParams, this.symbolType, this.modelEnviroment));
        this.defaultTextField = new JTextField(20);
        panel.add(this.defaultTextField);
        SpringUtilities.makeCompactGrid(panel, size + 1, 3, 5, 5, 2, 2);
        this.add((Component)panel, "North");
    }

    public List<Tupel<Image, String>> getSelectedFilters() {
        LinkedList<Tupel<Image, String>> list = new LinkedList<Tupel<Image, String>>();
        Iterator<Tupel<ObjectFilter<V, AttributeValueFilterModel>, JCheckBox>> cIter = this.checkBoxes.iterator();
        Iterator<Tupel<ObjectFilter<V, AttributeValueFilterModel>, JTextField>> tIter = this.textFields.iterator();
        while (cIter.hasNext()) {
            Tupel<ObjectFilter<V, AttributeValueFilterModel>, JCheckBox> cNext = cIter.next();
            Tupel<ObjectFilter<V, AttributeValueFilterModel>, JTextField> tNext = tIter.next();
            if (!cNext.getElement2().isSelected()) continue;
            ObjectFilter<V, AttributeValueFilterModel> objectFilter = cNext.getElement1();
            RendererType rendererType = this.rendererTypeMap.get(objectFilter);
            List<Tupel<String, String>> params = this.highestParamMap.get(objectFilter);
            for (Tupel<String, String> dParam : this.defaultParams) {
                boolean found = false;
                for (Tupel<String, String> param : params) {
                    if (!dParam.getElement1().equals(param.getElement1())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                params.add(dParam);
            }
            try {
                Image image = this.createRendererPreviewPane(rendererType, params, this.symbolType, this.modelEnviroment).paintImage(200, 80);
                list.add(new Tupel<Image, String>(image, tNext.getElement2().getText()));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.defaultCheckbox.isSelected()) {
            RendererType rendererType = this.defaultRendererType == null ? RendererType.INVISIBLE : this.defaultRendererType;
            try {
                Image image = this.createRendererPreviewPane(rendererType, this.defaultParams, this.symbolType, this.modelEnviroment).paintImage(200, 80);
                list.add(new Tupel<Image, String>(image, this.defaultTextField.getText()));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return list;
    }
}

