/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.filter.pattern.legend;

import de.datomino.peppergis.client.gui.filter.pattern.legend.AbstractLegendPane;
import de.datomino.peppergis.client.gui.filter.pattern.legend.FilterPatternLegendPane;
import de.datomino.peppergis.client.gui.filter.pattern.legend.listener.PatternLegendSelectionListener;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.util.wrapper.common.filter.ModelFilterPatternSetup;
import de.datomino.util.swing.SwingUtils;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class FilterPatternLegendDialog<T extends Model, S extends Model, U extends Model, V extends Model, W extends Model, X extends Model>
extends JDialog {
    private static final long serialVersionUID = -2144634658536762842L;
    private CardLayout cardLayout;
    private Component previous;
    private int cardCount = 0;
    private boolean markable;
    private Set<V> selectedFiltersList;
    private Set<V> allInitiallySelectedFilters;
    private FilterPatternLegendPane<T, S, U, V, W, X> filterPatternLegendPane;
    private List<PatternLegendSelectionListener<V>> patternLegendSelectionListeners = new LinkedList<PatternLegendSelectionListener<V>>();

    public FilterPatternLegendDialog(Window parent, String title, boolean markable, JInternalFrame parentIntenalFrame) {
        super(parent, title, Dialog.ModalityType.MODELESS);
        try {
            this.setIconImage(ImageIO.read(FilterPatternLegendDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.markable = markable;
        this.cardLayout = new CardLayout();
        this.getContentPane().setLayout(this.cardLayout);
        this.pack();
        int width = this.getWidth();
        int height = this.getHeight();
        this.setSize(Math.max(200, width), Math.max(100, height));
        SwingUtils.topRightDialog(this, parent);
        Point location = this.getLocation();
        this.setLocation(location.x, location.y);
        this.selectedFiltersList = new HashSet<V>();
        this.allInitiallySelectedFilters = new HashSet<V>();
        if (parentIntenalFrame != null) {
            parentIntenalFrame.addInternalFrameListener(new FilterPatternLegendDialogInternalFrameListener());
        }
    }

    public void setFilterPatternSetup(ModelFilterPatternSetup<S, T, U, V, X> modelFilterPatternSetup, AbstractLegendPane.SymbolType symbolType, ModelEnviroment modelEnviroment) {
        String cardName = Integer.toString(this.cardCount);
        this.filterPatternLegendPane = new FilterPatternLegendPane(symbolType, modelFilterPatternSetup, modelEnviroment, this.markable, this);
        for (PatternLegendSelectionListener<V> patternLegendSelectionListener : this.patternLegendSelectionListeners) {
            this.filterPatternLegendPane.addPatternLegendSelectionListener(patternLegendSelectionListener);
        }
        JScrollPane comp = new JScrollPane(this.filterPatternLegendPane);
        this.getContentPane().add((Component)comp, cardName);
        this.cardLayout.show(this.getContentPane(), cardName);
        if (this.previous != null) {
            this.getContentPane().remove(this.previous);
        }
        this.previous = comp;
        this.pack();
        int width = this.getWidth();
        int height = this.getHeight();
        this.setSize(Math.max(200, width), Math.max(100, height));
    }

    public void setSelectedFiltersList(Set<V> selectedFiltersList) {
        this.selectedFiltersList = selectedFiltersList;
    }

    public Set<V> getSelectedFiltersList() {
        return this.selectedFiltersList;
    }

    public void addToSelectedFiltersList(V selectedFilter) {
        this.selectedFiltersList.add(selectedFilter);
    }

    public void removeFromSelectedFiltersList(Model selectedFilter) {
        if (this.selectedFiltersList.contains(selectedFilter)) {
            this.selectedFiltersList.remove(selectedFilter);
        }
    }

    public Set<V> getAllInitiallySelectedFilters() {
        return this.allInitiallySelectedFilters;
    }

    public void setAllInitiallySelectedFilters(Set<V> allInitiallySelectedFilters) {
        this.allInitiallySelectedFilters = allInitiallySelectedFilters;
    }

    public void addToInitialFiltersList(V addedSelectedFilter) {
        this.allInitiallySelectedFilters.add(addedSelectedFilter);
    }

    public void addPatternLegendSelectionListener(PatternLegendSelectionListener<V> patternLegendSelectionListener) {
        this.patternLegendSelectionListeners.add(patternLegendSelectionListener);
        if (this.filterPatternLegendPane != null) {
            this.filterPatternLegendPane.addPatternLegendSelectionListener(patternLegendSelectionListener);
        }
    }

    public void removePatternLegendSelectionListener(PatternLegendSelectionListener<V> patternLegendSelectionListener) {
        this.patternLegendSelectionListeners.remove(patternLegendSelectionListener);
        if (this.filterPatternLegendPane != null) {
            this.filterPatternLegendPane.removePatternLegendSelectionListener(patternLegendSelectionListener);
        }
    }

    public List<V> getAllFilters() {
        return new ArrayList<V>(this.allInitiallySelectedFilters);
    }

    public Boolean isShowDefaultSelected() {
        return this.filterPatternLegendPane.isShowDefaultSelected();
    }

    private class FilterPatternLegendDialogInternalFrameListener
    extends InternalFrameAdapter {
        private boolean wasVisible;

        private FilterPatternLegendDialogInternalFrameListener() {
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent e) {
            if (this.wasVisible) {
                FilterPatternLegendDialog.this.setVisible(true);
            }
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent e) {
            this.wasVisible = FilterPatternLegendDialog.this.isVisible();
            if (this.wasVisible) {
                FilterPatternLegendDialog.this.setVisible(false);
            }
        }
    }
}

