/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.filter.pattern.legend;

import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.swing.renderer.Renderer;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public abstract class AbstractRendererPreViewPane<T extends ImmutableGeoObject, S extends RendererProperties>
extends JPanel {
    private static final long serialVersionUID = 5122511581554307923L;
    private Renderer<S, T, ?> renderer;
    private Rectangle rectToDraw;

    public AbstractRendererPreViewPane(Renderer<S, T, ?> renderer) {
        this.renderer = renderer;
        if (this.renderer != null) {
            Dimension optimalPreviewDimension = this.renderer.getOptimalPreviewDimension();
            double dist = this.getExpansionDistance() * 2.0;
            optimalPreviewDimension.setSize(optimalPreviewDimension.getWidth() + dist, optimalPreviewDimension.getHeight() + dist);
            this.setPreferredSize(optimalPreviewDimension);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D graphics2d = (Graphics2D)g;
        AffineTransform affineTransform = graphics2d.getTransform();
        affineTransform.scale(-1.0, 1.0);
        affineTransform.translate(-this.getHeight(), 0.0);
        graphics2d.setTransform(affineTransform);
        Color bg = new Color(0, 0, 0, 0);
        graphics2d.setBackground(bg);
        if (this.renderer != null) {
            this.setSize(this.getPreferredSize());
            S rendererProperties = this.renderer.createRendererProperties(null);
            if (rendererProperties != null) {
                rendererProperties.setUpp(1.0);
            }
            T geom = this.rectToDraw == null ? this.createGeom(graphics2d) : this.createGeom(this.rectToDraw);
            this.renderer.renderForPreview(graphics2d, null, geom, rendererProperties);
            if (this.isDrawBorder()) {
                Rectangle rect = graphics2d.getClipBounds();
                rect.setSize(rect.width - 1, rect.height - 1);
                graphics2d.setColor(Color.BLACK);
                graphics2d.draw(rect);
            }
        }
    }

    protected double getExpansionDistance() {
        return 1.0;
    }

    protected boolean isDrawBorder() {
        return true;
    }

    protected abstract T createGeom(Graphics2D var1);

    protected abstract T createGeom(Rectangle var1);

    public Image paintImage(int width, int height) throws InterruptedException {
        Dimension oSize = this.getSize();
        this.setSize(width, height);
        BufferedImage bufferedImage = new BufferedImage(width, height, 6);
        this.paint(bufferedImage.getGraphics());
        this.setSize(oSize);
        return bufferedImage;
    }
}

