/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.filter.pattern.legend;

import de.datomino.peppergis.client.gui.filter.pattern.legend.AbstractRendererPreViewPane;
import de.datomino.peppergis.client.gui.filter.pattern.legend.PointRendererPreviewPane;
import de.datomino.peppergis.client.gui.filter.pattern.legend.PolygonRendererPreviewPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModel;
import de.datomino.peppergis.client.util.filter.RendererFactory;
import de.datomino.peppergis.client.util.wrapper.common.filter.ModelFilterPatternSetup;
import de.datomino.peppergis.type.RendererType;
import de.datomino.peppergis.type.filter.FilterPatternParameter;
import de.datomino.peppergis.type.filter.FilterPatternRelation;
import de.datomino.peppergis.type.filter.ObjectFilter;
import de.datomino.util.geo.swing.renderer.Renderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.ktde.util.datatypes.Quad;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractLegendPane<T extends Model, S extends Model, U extends Model, V extends Model, X extends Model>
extends JPanel {
    private static final long serialVersionUID = 7263093865053149465L;

    public AbstractLegendPane(LayoutManager layoutManager) {
        super(layoutManager);
    }

    protected Quad<Map<ObjectFilter<V, AttributeValueFilterModel>, List<Tupel<String, String>>>, Map<ObjectFilter<V, AttributeValueFilterModel>, RendererType>, List<Tupel<String, String>>, RendererType> getRendererInformation(ModelFilterPatternSetup<S, T, U, V, X> modelFilterPatternSetup) {
        LinkedHashMap highestParamMap = new LinkedHashMap();
        LinkedHashMap rendererTypeMap = new LinkedHashMap();
        RendererType defaultRendererType = null;
        Iterator iter = modelFilterPatternSetup.getRelations().iterator();
        LinkedList defaultParams = new LinkedList();
        while (iter.hasNext()) {
            FilterPatternRelation modelFilterPatternRelation = iter.next();
            block1: for (FilterPatternParameter filterPatternParameter : modelFilterPatternRelation.getFilterPatternParameter()) {
                List<Tupel<String, String>> params;
                ObjectFilter objectFilter = filterPatternParameter.getObjectFilter();
                if (objectFilter == null) {
                    params = defaultParams;
                    if (defaultRendererType == null) {
                        defaultRendererType = modelFilterPatternRelation.getRendererType();
                    }
                } else {
                    RendererType setRendererType;
                    params = (List)highestParamMap.get(objectFilter);
                    if (params == null) {
                        params = new LinkedList();
                        highestParamMap.put(objectFilter, params);
                    }
                    if ((setRendererType = (RendererType)((Object)rendererTypeMap.get(objectFilter))) == null) {
                        rendererTypeMap.put(objectFilter, modelFilterPatternRelation.getRendererType());
                    }
                }
                for (Tupel tupel : params) {
                    if (!((String)tupel.getElement1()).equals(filterPatternParameter.getParameterKey())) continue;
                    continue block1;
                }
                params.add(new Tupel<String, String>(filterPatternParameter.getParameterKey(), filterPatternParameter.getParameterValue()));
            }
        }
        return new Quad(highestParamMap, rendererTypeMap, defaultParams, defaultRendererType);
    }

    protected Component createRendererPanel(RendererType rendererType, List<Tupel<String, String>> params, SymbolType symbolType, ModelEnviroment modelEnviroment) {
        AbstractRendererPreViewPane<?, ?> rendererPreViewPane = this.createRendererPreviewPane(rendererType, params, symbolType, modelEnviroment);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(rendererPreViewPane, "West");
        return panel;
    }

    protected AbstractRendererPreViewPane<?, ?> createRendererPreviewPane(RendererType rendererType, List<Tupel<String, String>> params, SymbolType symbolType, ModelEnviroment modelEnviroment) {
        AbstractRendererPreViewPane rendererPreViewPane;
        Renderer renderer = RendererFactory.getInstance().createRenderer(rendererType, params, modelEnviroment, null, true, null);
        switch (symbolType) {
            case AREA: {
                rendererPreViewPane = new PolygonRendererPreviewPane(renderer);
                break;
            }
            case POINT: {
                rendererPreViewPane = new PointRendererPreviewPane(renderer);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return rendererPreViewPane;
    }

    public static enum SymbolType {
        AREA,
        POINT;

    }
}

