/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.filter;

import de.datomino.peppergis.client.gui.filter.AbstractFilterList;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.util.wrapper.common.filter.ModelObjectFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;

public abstract class AbstractModifiableFilterList<T extends Model>
extends AbstractFilterList<T> {
    private static final long serialVersionUID = -3564261083863786410L;
    private Action removeAction;
    private Action addAction;

    public AbstractModifiableFilterList(ModelEnviroment modelEnviroment) {
        super(modelEnviroment);
        this.buildLayout();
    }

    private void buildLayout() {
        JPanel buttonPane = new JPanel(new BorderLayout());
        this.removeAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.remove", new Serializable[0])){
            private static final long serialVersionUID = 1729931115804035100L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JList filters = AbstractModifiableFilterList.this.getFilters();
                AbstractFilterList.FilterListItem filterListItem = (AbstractFilterList.FilterListItem)filters.getSelectedValue();
                DefaultListModel dlm = (DefaultListModel)filters.getModel();
                dlm.removeElement(filterListItem);
                AbstractModifiableFilterList.this.doRemoveAction(filterListItem.getFilterModel());
            }
        };
        JButton remove = new JButton(this.removeAction);
        this.removeAction.setEnabled(false);
        buttonPane.add((Component)remove, "West");
        this.addAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0])){
            private static final long serialVersionUID = 4790690410918486244L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelObjectFilter filterModel = AbstractModifiableFilterList.this.createNewFilter();
                JList filters = AbstractModifiableFilterList.this.getFilters();
                DefaultListModel dlm = (DefaultListModel)filters.getModel();
                dlm.addElement(new AbstractFilterList.FilterListItem(AbstractModifiableFilterList.this, filterModel));
                AbstractModifiableFilterList.this.doAddAction(filterModel);
            }
        };
        JButton add = new JButton(this.addAction);
        buttonPane.add((Component)add, "East");
        this.add((Component)buttonPane, "South");
    }

    protected abstract void doAddAction(ModelObjectFilter<T> var1);

    protected abstract void doRemoveAction(ModelObjectFilter<T> var1);

    protected abstract ModelObjectFilter<T> createNewFilter();

    @Override
    protected void filterSelected(ModelObjectFilter<T> filterModel) {
        this.setRemoveActionEnabled();
    }

    private void setRemoveActionEnabled() {
        boolean enabled = this.isEnabled();
        if (enabled) {
            JList filters = this.getFilters();
            AbstractFilterList.FilterListItem filterListItem = (AbstractFilterList.FilterListItem)filters.getSelectedValue();
            boolean bl = enabled = filterListItem != null;
            if (enabled) {
                ModelObjectFilter filterModel = filterListItem.getFilterModel();
                Boolean modifiable = filterModel.getModifiable();
                enabled = modifiable == null || modifiable != false;
            }
        }
        this.removeAction.setEnabled(enabled);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setRemoveActionEnabled();
        this.addAction.setEnabled(enabled);
    }
}

