/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.filter;

import de.datomino.peppergis.client.gui.attribute.filter.AbstractAttributeFilterPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModel;
import de.datomino.peppergis.client.util.wrapper.common.filter.ModelObjectFilter;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class AbstractFilterPane<T extends Model, S extends Model, U extends Model>
extends JPanel {
    private static final long serialVersionUID = 6342479660172066056L;
    private AbstractAttributeFilterPane<S, U> attributeFilterPane;
    private JTextField name;
    private Window parent;
    private ModelEnviroment modelEnviroment;
    private ModelObjectFilter<T> modelObjectFilter;

    public AbstractFilterPane(Window parent, ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.parent = parent;
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
    }

    private void buildLayout() {
        JPanel topPane = new JPanel(new SpringLayout());
        JPanel headerPane = new JPanel(new BorderLayout());
        headerPane.add((Component)new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.filter.name", new Serializable[0])), "West");
        this.name = new JTextField(30);
        this.name.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.textUpdate(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.textUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.textUpdate(e);
            }

            private void textUpdate(DocumentEvent e) {
                if (AbstractFilterPane.this.modelObjectFilter != null) {
                    AbstractFilterPane.this.modelObjectFilter.setName(AbstractFilterPane.this.name.getText());
                }
            }
        });
        headerPane.add((Component)this.name, "Center");
        topPane.add(headerPane);
        Component component = this.getSpecialParameterComponent();
        int rows = 1;
        if (component != null) {
            topPane.add(component);
            ++rows;
        }
        SpringUtilities.makeCompactGrid(topPane, rows, 1, 5, 5, 2, 2);
        this.add((Component)topPane, "North");
        this.attributeFilterPane = this.createAttributeFilterPane();
        this.add(this.attributeFilterPane, "Center");
    }

    protected abstract AbstractAttributeFilterPane<S, U> createAttributeFilterPane();

    protected abstract Component getSpecialParameterComponent();

    protected abstract void setSpecialFilterValues(ModelObjectFilter<T> var1);

    protected abstract void adaptSpecialValuesToModel(ModelObjectFilter<T> var1);

    protected abstract void setSpecialEnabled(boolean var1);

    protected ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }

    protected Window getParentWindow() {
        return this.parent;
    }

    public void setFilter(ModelObjectFilter<T> modelObjectFilter) {
        this.modelObjectFilter = modelObjectFilter;
        if (modelObjectFilter == null) {
            this.name.setText("");
            this.attributeFilterPane.setFilter(null);
        } else {
            String name = modelObjectFilter.getName();
            this.name.setText(name == null ? "" : name);
            this.attributeFilterPane.setFilter((AttributeValueFilterModel)modelObjectFilter.getAttributeValueFilter());
        }
        this.setSpecialFilterValues(modelObjectFilter);
    }

    public void adaptValuesToModel() {
        if (this.modelObjectFilter != null) {
            this.modelObjectFilter.setName(this.name.getText());
            this.modelObjectFilter.setAttributeValueFilter(this.attributeFilterPane.getCurrentAttributeValueFilter());
            this.adaptSpecialValuesToModel(this.modelObjectFilter);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.name.setEditable(enabled);
        this.attributeFilterPane.setEnabled(enabled);
        this.setSpecialEnabled(enabled);
    }

    public void addNameChangedListener(DocumentListener documentListener) {
        this.name.getDocument().addDocumentListener(documentListener);
    }
}

