/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.filter;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModel;
import de.datomino.peppergis.client.util.wrapper.common.filter.ModelObjectFilter;
import de.datomino.peppergis.type.filter.ObjectFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractFilterList<T extends Model>
extends JPanel {
    private static final long serialVersionUID = -2779949467903434102L;
    private JList filters;
    private ModelEnviroment modelEnviroment;

    public AbstractFilterList(ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
        this.fillValues();
    }

    protected void fillValues() {
        Collection<ModelObjectFilter<T>> filterModels = this.fetchFilters();
        DefaultListModel dlm = (DefaultListModel)this.filters.getModel();
        for (ModelObjectFilter<T> filterModel : filterModels) {
            dlm.addElement(new FilterListItem(filterModel));
        }
    }

    private void buildLayout() {
        this.filters = new JList(new DefaultListModel());
        this.filters.setSelectionMode(0);
        this.filters.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ModelObjectFilter filterModel = AbstractFilterList.this.getSelectedFilter();
                AbstractFilterList.this.filterSelected(filterModel);
            }
        });
        JScrollPane scroll = new JScrollPane(this.filters);
        scroll.setHorizontalScrollBarPolicy(32);
        this.add((Component)scroll, "Center");
    }

    protected abstract void filterSelected(ModelObjectFilter<T> var1);

    protected abstract Collection<ModelObjectFilter<T>> fetchFilters();

    protected ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }

    public ModelObjectFilter<T> getSelectedFilter() {
        FilterListItem filterListItem = (FilterListItem)this.filters.getSelectedValue();
        ModelObjectFilter filterModel = filterListItem == null ? null : filterListItem.getFilterModel();
        return filterModel;
    }

    public void setSelectedFilter(ObjectFilter<T, AttributeValueFilterModel> filter) {
        this.filters.clearSelection();
        if (filter != null) {
            DefaultListModel dlm = (DefaultListModel)this.filters.getModel();
            for (int i = 0; i < dlm.getSize(); ++i) {
                FilterListItem filterListItem = (FilterListItem)dlm.elementAt(i);
                if (!((Model)filter.getAttachedObject()).equals(filterListItem.getFilterModel().getAttachedObject())) continue;
                this.filters.setSelectedIndex(i);
                return;
            }
            throw new RuntimeException();
        }
    }

    protected JList getFilters() {
        return this.filters;
    }

    protected class FilterListItem {
        private ModelObjectFilter<T> filterModel;

        public FilterListItem(ModelObjectFilter<T> filterModel) {
            this.filterModel = filterModel;
        }

        public ModelObjectFilter<T> getFilterModel() {
            return this.filterModel;
        }

        public String toString() {
            return this.getFilterModel().getName();
        }
    }
}

