/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.filter;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.filter.AbstractFilterPane;
import de.datomino.peppergis.client.gui.filter.AbstractModifiableFilterList;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModel;
import de.datomino.peppergis.client.util.wrapper.common.filter.ModelObjectFilter;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.type.attribute.AttributeValueFilterType;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JSplitPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class AbstractFilterConfigurationDialog<T extends Model, S extends Model, U extends Model>
extends CommonDialog {
    private static final long serialVersionUID = -3513897345120246840L;
    private AbstractModifiableFilterList<T> areaFilterList;
    private AbstractFilterPane<T, S, U> filterPane;
    private ModelEnviroment modelEnviroment;
    private Window parent;
    private JSplitPane splitPane;

    public AbstractFilterConfigurationDialog(Window parent, String title) {
        super((Component)parent, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.parent = parent;
        this.modelEnviroment = new ModelEnviroment(this);
        this.modelEnviroment.getUndoManager().startTransaction();
        this.buildLayout();
        this.pack();
        Dimension dim = this.getSize();
        Dimension pDim = parent.getSize();
        int maxWidth = (int)(pDim.getWidth() * 0.8);
        int maxHeight = (int)(pDim.getHeight() * 0.8);
        int width = Math.min(dim.width, maxWidth);
        this.setSize(new Dimension(width, Math.min(dim.height, maxHeight)));
        SwingUtils.centerDialog(this, parent);
        this.splitPane.setDividerLocation(width / 2);
        SwingUtils.centerDialog(this, parent);
    }

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = 9222600591913346560L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractFilterConfigurationDialog.this.modelEnviroment.getUndoManager().rollbackTransaction();
                AbstractFilterConfigurationDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        this.splitPane = new JSplitPane();
        this.areaFilterList = new AbstractModifiableFilterList<T>(this.modelEnviroment){
            private static final long serialVersionUID = -6774472337309851150L;

            @Override
            protected void filterSelected(ModelObjectFilter<T> filterModel) {
                Boolean modifiable;
                super.filterSelected(filterModel);
                AbstractFilterConfigurationDialog.this.filterPane.adaptValuesToModel();
                AbstractFilterConfigurationDialog.this.filterPane.setFilter(filterModel);
                boolean enabled = filterModel == null ? false : (modifiable = filterModel.getModifiable()) == null || modifiable != false;
                AbstractFilterConfigurationDialog.this.filterPane.setEnabled(enabled);
            }

            @Override
            protected ModelObjectFilter<T> createNewFilter() {
                return AbstractFilterConfigurationDialog.this.createNewFilter();
            }

            @Override
            protected void doAddAction(ModelObjectFilter<T> filterModel) {
            }

            @Override
            protected void doRemoveAction(ModelObjectFilter<T> filterModel) {
                AbstractFilterConfigurationDialog.this.filterPane.setFilter(null);
                AbstractFilterConfigurationDialog.this.deleteCascading(filterModel);
            }

            @Override
            protected Collection<ModelObjectFilter<T>> fetchFilters() {
                return AbstractFilterConfigurationDialog.this.fetchFilters();
            }
        };
        this.splitPane.setLeftComponent(this.areaFilterList);
        this.filterPane = this.createFilterPane();
        this.filterPane.addNameChangedListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractFilterConfigurationDialog.this.areaFilterList.repaint(1L);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractFilterConfigurationDialog.this.areaFilterList.repaint(1L);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractFilterConfigurationDialog.this.areaFilterList.repaint(1L);
            }
        });
        this.filterPane.setEnabled(false);
        this.splitPane.setRightComponent(this.filterPane);
        return this.splitPane;
    }

    protected abstract ModelObjectFilter<T> createNewFilter();

    protected abstract AbstractFilterPane<T, S, U> createFilterPane();

    protected abstract Collection<ModelObjectFilter<T>> fetchFilters();

    protected void doAfterOkAction() {
    }

    private void deleteCascading(ModelObjectFilter<T> filterModel) {
        ((Model)filterModel.getAttachedObject()).delete();
        AttributeValueFilterModel attributeValueFilterModel = (AttributeValueFilterModel)filterModel.getAttributeValueFilter();
        this.deleteCascading(attributeValueFilterModel);
    }

    private void deleteCascading(AttributeValueFilterModel attributeValueFilterModel) {
        if (attributeValueFilterModel != null) {
            attributeValueFilterModel.delete();
            if (attributeValueFilterModel.getAttributeValueFilterType() == AttributeValueFilterType.SIMPLE) {
                attributeValueFilterModel.getSimpleAttriubteValueFilter().delete();
            } else {
                for (AttributeValueFilterModel subAttributeValueFilterModel : attributeValueFilterModel.iterableChildAttributeValueFilters()) {
                    this.deleteCascading(subAttributeValueFilterModel);
                }
            }
        }
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = -7232675972414494355L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractFilterConfigurationDialog.this.filterPane.adaptValuesToModel();
                AbstractFilterConfigurationDialog.this.modelEnviroment.getUndoManager().finishTransaction("");
                try {
                    AbstractFilterConfigurationDialog.this.modelEnviroment.getUndoManager().storeTransactions();
                    AbstractFilterConfigurationDialog.this.dispose();
                    AbstractFilterConfigurationDialog.this.doAfterOkAction();
                }
                catch (ValidateException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
    }

    protected ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }

    protected Window getParentWindow() {
        return this.parent;
    }
}

