/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.file;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public final class FileChooseUtil {
    private static final String GLOBAL_FILE_DIRECTORY_KEY = "global.file.directory";

    private FileChooseUtil() {
    }

    public static File chooseSaveFile(Component parent) {
        return FileChooseUtil.chooseSaveFile(parent, null);
    }

    public static File chooseSaveFile(Component parent, String extension) {
        return FileChooseUtil.chooseSaveFile(parent, extension, false);
    }

    private static File chooseSaveFile(Component parent, String extension, boolean directoryOnly) {
        int d;
        File dir;
        String directory = ModelEnviroment.getProperties().getProperty(GLOBAL_FILE_DIRECTORY_KEY);
        JFileChooser fileChooser = directory == null ? new JFileChooser() : ((dir = new File(directory)).isDirectory() ? new JFileChooser(dir) : new JFileChooser());
        if (extension != null) {
            fileChooser.addChoosableFileFilter(new FileChooseFileFilter(extension));
        }
        if (directoryOnly) {
            fileChooser.setFileSelectionMode(1);
        }
        if ((d = fileChooser.showSaveDialog(parent)) == 0) {
            FileFilter fileFilter;
            File file = fileChooser.getSelectedFile();
            if (file != null) {
                try {
                    String newDir = file.isDirectory() ? file.getCanonicalPath() : file.getParentFile().getCanonicalPath();
                    ModelEnviroment.getProperties().setDynamicProperty(GLOBAL_FILE_DIRECTORY_KEY, newDir);
                }
                catch (IOException newDir) {
                    // empty catch block
                }
            }
            if ((fileFilter = fileChooser.getFileFilter()) instanceof FileChooseFileFilter) {
                String selectedExtension = ((FileChooseFileFilter)fileFilter).getExtension();
                if (!file.getName().toLowerCase().endsWith("." + selectedExtension.toLowerCase())) {
                    file = new File(file.getParentFile(), file.getName() + "." + selectedExtension);
                }
            }
            return file;
        }
        return null;
    }

    public static File chooseSaveDirectory(Component parent) {
        return FileChooseUtil.chooseSaveFile(parent, null, true);
    }

    private static class FileChooseFileFilter
    extends FileFilter {
        private String extension;

        public FileChooseFileFilter(String extension) {
            this.extension = extension;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String s = f.getName();
            int i = s.lastIndexOf(46);
            return i > 0 && i < s.length() - 1 && s.substring(i + 1).toLowerCase().equals(this.extension);
        }

        @Override
        public String getDescription() {
            return "*." + this.extension;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

