/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.customer.contact;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractContactPane<T extends Model>
extends JPanel {
    private static final long serialVersionUID = -3011587102126092635L;
    private JList contacts;
    private JTextField value;
    private JTextField firstName;
    private JTextField lastName;
    private AddAction addAction;
    private RemoveAction removeAction;
    private T lastSelected;
    private CustomerModel customer;

    public AbstractContactPane() {
        super(new BorderLayout());
        this.buildLayout();
    }

    private void buildLayout() {
        JPanel listPanel = new JPanel(new BorderLayout());
        this.contacts = new JList(new DefaultListModel());
        listPanel.add((Component)new JScrollPane(this.contacts), "Center");
        this.contacts.setSelectionMode(0);
        this.contacts.addListSelectionListener(new ContactListSelectionListener());
        this.contacts.setCellRenderer(new ContactListRenderer());
        JPanel buttonPanel = new JPanel(new BorderLayout());
        this.removeAction = new RemoveAction();
        this.removeAction.setEnabled(false);
        buttonPanel.add((Component)new JButton(this.removeAction), "West");
        this.addAction = new AddAction();
        buttonPanel.add((Component)new JButton(this.addAction), "East");
        listPanel.add((Component)buttonPanel, "South");
        this.add((Component)listPanel, "Center");
        JPanel valuePanel = new JPanel(new SpringLayout());
        valuePanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(this.getValueMessageKey(), new Serializable[0])));
        this.value = new JTextField(20);
        valuePanel.add(this.value);
        valuePanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.customer.firstName", new Serializable[0])));
        this.firstName = new JTextField(20);
        valuePanel.add(this.firstName);
        valuePanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.customer.lastName", new Serializable[0])));
        this.lastName = new JTextField(20);
        valuePanel.add(this.lastName);
        SpringUtilities.makeCompactGrid(valuePanel, 3, 2, 5, 5, 2, 2);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)valuePanel, "North");
        this.add((Component)panel, "East");
        this.setBorder(new TitledBorder(ModelEnviroment.getMessageResolver().resolveMessage(this.getTitleMessageKey(), new Serializable[0])));
    }

    private void reorgOrder() {
        DefaultListModel dlm = (DefaultListModel)this.contacts.getModel();
        for (int i = 0; i < dlm.getSize(); ++i) {
            Model t = (Model)dlm.elementAt(i);
            this.setOrder(t, i);
        }
    }

    public void setValues(Iterable<T> values) {
        DefaultListModel dlm = (DefaultListModel)this.contacts.getModel();
        dlm.removeAllElements();
        for (Model value : values) {
            dlm.addElement(value);
        }
        this.reorgOrder();
    }

    public void setCustomer(CustomerModel customer) {
        this.customer = customer;
        Iterable<T> contacts = this.getContactsFromCustomer(customer);
        this.setValues(contacts);
    }

    protected CustomerModel getCustomer() {
        return this.customer;
    }

    protected abstract Iterable<T> getContactsFromCustomer(CustomerModel var1);

    protected abstract String getValueMessageKey();

    protected abstract String getTitleMessageKey();

    protected abstract String getValue(T var1);

    protected abstract String getFirstName(T var1);

    protected abstract String getLastName(T var1);

    protected abstract void setValues(T var1, String var2, String var3, String var4);

    protected abstract void setOrder(T var1, Integer var2);

    protected abstract Integer getOrder(T var1);

    protected abstract T createNewContact(Integer var1);

    private class ContactListRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 4822179820877090185L;

        private ContactListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Model t = (Model)value;
            return super.getListCellRendererComponent((JList<?>)list, AbstractContactPane.this.getValue(t), index, isSelected, cellHasFocus);
        }
    }

    private class ContactListSelectionListener
    implements ListSelectionListener {
        private ContactListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Model t;
            if (AbstractContactPane.this.lastSelected != null) {
                AbstractContactPane.this.setValues(AbstractContactPane.this.lastSelected, AbstractContactPane.this.value.getText(), AbstractContactPane.this.firstName.getText(), AbstractContactPane.this.lastName.getText());
            }
            if ((t = (Model)AbstractContactPane.this.contacts.getSelectedValue()) == null) {
                AbstractContactPane.this.removeAction.setEnabled(false);
                AbstractContactPane.this.value.setText("");
                AbstractContactPane.this.firstName.setText("");
                AbstractContactPane.this.lastName.setText("");
            } else {
                AbstractContactPane.this.removeAction.setEnabled(true);
                AbstractContactPane.this.value.setText(AbstractContactPane.this.getValue(t));
                AbstractContactPane.this.firstName.setText(AbstractContactPane.this.getFirstName(t));
                AbstractContactPane.this.lastName.setText(AbstractContactPane.this.getLastName(t));
            }
            AbstractContactPane.this.lastSelected = t;
        }
    }

    private class RemoveAction
    extends AbstractAction {
        private static final long serialVersionUID = 8732545219804383400L;

        public RemoveAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.remove", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Model t = (Model)AbstractContactPane.this.contacts.getSelectedValue();
            DefaultListModel dlm = (DefaultListModel)AbstractContactPane.this.contacts.getModel();
            dlm.removeElement(t);
            t.delete();
        }
    }

    private class AddAction
    extends AbstractAction {
        private static final long serialVersionUID = 8135690274224266418L;

        public AddAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultListModel dlm = (DefaultListModel)AbstractContactPane.this.contacts.getModel();
            Object t = AbstractContactPane.this.createNewContact(dlm.getSize());
            dlm.addElement(t);
        }
    }
}

