/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.customer;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.offer.SenderModel;
import java.awt.Component;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;

public class SenderComboBox
extends JComboBox {
    private static final long serialVersionUID = 4215528150341663967L;
    private ModelEnviroment modelEnviroment;
    private boolean allowEmpty;

    public SenderComboBox(ModelEnviroment modelEnviroment, boolean allowEmpty) {
        super(new DefaultComboBoxModel());
        this.modelEnviroment = modelEnviroment;
        this.allowEmpty = allowEmpty;
        this.setRenderer(new SenderRenderer());
        this.loadSenders();
    }

    private void loadSenders() {
        List<SenderModel> senders = this.modelEnviroment.getAllCaller().getOfferCaller().getAllSenders();
        DefaultComboBoxModel dcm = (DefaultComboBoxModel)this.getModel();
        dcm.removeAllElements();
        if (this.allowEmpty) {
            dcm.addElement("");
        }
        for (SenderModel senderModel : senders) {
            dcm.addElement(senderModel);
        }
    }

    @Override
    public SenderModel getSelectedItem() {
        Object object = super.getSelectedItem();
        if (object == null || object instanceof String) {
            return null;
        }
        return (SenderModel)object;
    }

    private class SenderRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 4658876020891955949L;

        private SenderRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null || value instanceof String) {
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
            SenderModel senderModel = (SenderModel)value;
            return super.getListCellRendererComponent((JList<?>)list, senderModel.getName(), index, isSelected, cellHasFocus);
        }
    }
}

