/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.customer;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.offer.MediaModel;
import java.awt.Component;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class MediaComboBox
extends JComboBox {
    private static final long serialVersionUID = -2313205314301893886L;
    private ModelEnviroment modelEnviroment;
    private boolean allowEmpty;

    public MediaComboBox(ModelEnviroment modelEnviroment, boolean allowEmpty) {
        super(new DefaultComboBoxModel());
        this.modelEnviroment = modelEnviroment;
        this.allowEmpty = allowEmpty;
        this.setRenderer(new MediaRenderer(this.getRenderer()));
        this.loadValues();
    }

    private void loadValues() {
        Collection<MediaModel> media = this.modelEnviroment.getAllCaller().getOfferCaller().getAllMedia();
        DefaultComboBoxModel dlm = (DefaultComboBoxModel)this.getModel();
        if (this.allowEmpty) {
            dlm.addElement(" ");
        }
        for (MediaModel med : media) {
            dlm.addElement(med);
        }
    }

    public MediaModel getSelectedMediaModel() {
        Object value = this.getSelectedItem();
        if (value instanceof MediaModel) {
            return (MediaModel)value;
        }
        return null;
    }

    private class MediaRenderer
    implements ListCellRenderer {
        private ListCellRenderer parent;

        public MediaRenderer(ListCellRenderer parent) {
            this.parent = parent;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object sValue = value;
            if (value instanceof MediaModel) {
                sValue = ((MediaModel)value).getName();
            }
            return this.parent.getListCellRendererComponent(list, sValue, index, isSelected, cellHasFocus);
        }
    }
}

