/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.customer;

import de.datomino.peppergis.client.gui.area.AreaLayerComboBox;
import de.datomino.peppergis.client.gui.area.AreaObjectComboBox;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.subscription.SubscriptionAttributeValuePane;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.SubscriptionStatus;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.WidthUnifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.ktde.util.StringUtil;

public class CustomerSubscriptionPane
extends JPanel {
    private static final long serialVersionUID = 3003688557619488118L;
    private JTextField subscriptionNumber;
    private EnumComboBox<SubscriptionStatus> subscriptionStatus;
    private AreaLayerComboBox areaLayer;
    private AreaObjectComboBox areaObject;
    private SubscriptionAttributeValuePane subscriptionAttributeValuePane;
    private JTextArea information;
    private ModelEnviroment modelEnviroment;
    private SubscriptionModel selected;

    public CustomerSubscriptionPane(ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
    }

    private void buildLayout() {
        JPanel panel = new JPanel(new SpringLayout());
        JPanel sPanel = new JPanel(new SpringLayout());
        WidthUnifier widthUnifier1 = new WidthUnifier();
        WidthUnifier widthUnifier2 = new WidthUnifier();
        JLabel label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptionNumber", new Serializable[0]));
        sPanel.add(label);
        widthUnifier1.add(label);
        this.subscriptionNumber = new JTextField(20);
        this.subscriptionNumber.setEditable(false);
        sPanel.add(this.subscriptionNumber);
        widthUnifier2.add(this.subscriptionNumber);
        label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(SubscriptionStatus.class.getName(), new Serializable[0]));
        sPanel.add(label);
        widthUnifier1.add(label);
        this.subscriptionStatus = new EnumComboBox<SubscriptionStatus>(SubscriptionStatus.class, false);
        sPanel.add(this.subscriptionStatus);
        widthUnifier2.add(this.subscriptionStatus);
        label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.layer", new Serializable[0]));
        sPanel.add(label);
        widthUnifier1.add(label);
        this.areaLayer = new AreaLayerComboBox(this.modelEnviroment, true, AreaObjectGenInfoDiscriminator.values());
        sPanel.add(this.areaLayer);
        widthUnifier2.add(this.areaLayer);
        label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.area", new Serializable[0]));
        sPanel.add(label);
        widthUnifier1.add(label);
        this.areaObject = new AreaObjectComboBox(true);
        sPanel.add(this.areaObject);
        this.areaLayer.addActionListener(this.areaObject.createLayerChangeListener(this.areaLayer));
        widthUnifier2.add(this.areaObject);
        widthUnifier1.unifyWidth();
        widthUnifier2.unifyWidth();
        SpringUtilities.makeCompactGrid(sPanel, 2, 4, 2, 2, 2, 2);
        panel.add(sPanel);
        sPanel = new JPanel(new BorderLayout());
        JPanel lPanel = new JPanel(new BorderLayout());
        label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]));
        lPanel.add((Component)label, "North");
        sPanel.add((Component)lPanel, "West");
        this.information = new JTextArea(5, 30);
        sPanel.add((Component)new JScrollPane(this.information), "Center");
        panel.add(sPanel);
        this.subscriptionAttributeValuePane = new SubscriptionAttributeValuePane(this.modelEnviroment.getAllCaller().getSubscriptionCaller().getAllSubscriptionAttributeValueDescriptors(), 2, this.modelEnviroment, true);
        panel.add(this.subscriptionAttributeValuePane);
        SpringUtilities.makeCompactGrid(panel, 3, 1, 5, 5, 2, 2);
    }

    public void setSubscription(SubscriptionModel subscriptionModel) {
        this.selected = subscriptionModel;
        if (subscriptionModel == null) {
            this.subscriptionNumber.setText("");
            this.subscriptionStatus.setSelectedIndex(0);
            this.areaLayer.setSelectedIndex(0);
            this.areaObject.setSelectedIndex(0);
            this.information.setText("");
            this.subscriptionAttributeValuePane.clearValues();
        } else {
            this.subscriptionNumber.setText(StringUtil.nullToEmpty(subscriptionModel.getSubscriptionNumber()));
            SubscriptionStatus status = subscriptionModel.getStatus();
            if (status == null) {
                this.subscriptionStatus.setSelectedIndex(0);
            } else {
                this.subscriptionStatus.setSelectedItem((Object)status);
            }
            AreaObjectModel sAreaObject = subscriptionModel.getAreaObject();
            if (sAreaObject == null) {
                this.areaLayer.setSelectedIndex(0);
                this.areaObject.setSelectedIndex(0);
            } else {
                this.areaLayer.setSelectedItem(sAreaObject.getAreaLayer());
                this.areaObject.setSelectedItem(sAreaObject);
            }
            this.information.setText(StringUtil.nullToEmpty(subscriptionModel.getInformation()));
            this.subscriptionAttributeValuePane.fillValues(subscriptionModel);
            this.subscriptionAttributeValuePane.clearValues();
        }
    }

    public void adaptValuesToModel() {
        if (this.selected != null) {
            this.selected.setSubscriptionNumber(this.subscriptionNumber.getText());
            this.selected.setStatus(this.subscriptionStatus.getSelectedValue());
            this.selected.setAreaObject((AreaObjectModel)this.areaObject.getSelectedItem());
            this.selected.setInformation(this.information.getText());
            this.subscriptionAttributeValuePane.adaptValuesToModel(this.selected);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.subscriptionStatus.setEnabled(enabled);
        this.areaLayer.setEnabled(enabled);
        this.areaObject.setEnabled(enabled);
        this.information.setEditable(enabled);
        this.subscriptionAttributeValuePane.setEnabled(enabled);
    }
}

