/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.customer;

import de.datomino.peppergis.client.gui.address.AddressPane;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.customer.agency.AgencyComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.CustomerFaxContactModel;
import de.datomino.peppergis.client.model.base.CustomerMailContactModel;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.base.CustomerPhoneContactModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.offer.AgencyModel;
import de.datomino.peppergis.type.Salutation;
import de.datomino.peppergis.util.offer.OfferSharedUtil;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.WidthUnifier;
import java.awt.Color;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.ktde.util.StringUtil;

public class CustomerSearchParameterPane
extends JPanel {
    private static final long serialVersionUID = 3897631391628427904L;
    private JTextField customerNumber;
    private JTextField offerNumber;
    private AgencyComboBox agency;
    private JTextField companyName;
    private JTextField firstName;
    private JTextField lastName;
    private EnumComboBox<Salutation> salutation;
    private JTextField phone;
    private JTextField fax;
    private JTextField email;
    private JTextField bussinessPartnerNumber;
    private AddressPane address;
    private boolean markForSave;
    private ModelEnviroment modelEnviroment;

    public CustomerSearchParameterPane(ModelEnviroment modelEnviroment, boolean markForSave) {
        super(new SpringLayout());
        this.markForSave = markForSave;
        this.modelEnviroment = modelEnviroment;
        this.buildLayout(modelEnviroment);
    }

    private void buildLayout(ModelEnviroment modelEnviroment) {
        WidthUnifier widthUnifier1 = new WidthUnifier();
        WidthUnifier widthUnifier2 = new WidthUnifier();
        JPanel upperPanel = new JPanel(new SpringLayout());
        JLabel l = new JLabel("Agenturnummer");
        widthUnifier1.add(l);
        upperPanel.add(l);
        this.agency = new AgencyComboBox(modelEnviroment.getAllCaller().getBaseCaller().getAllAgencies(), true);
        upperPanel.add(this.agency);
        widthUnifier2.add(this.agency);
        l = new JLabel("DB-ID");
        widthUnifier1.add(l);
        upperPanel.add(l);
        this.customerNumber = new JTextField(20);
        upperPanel.add(this.customerNumber);
        this.customerNumber.setEnabled(false);
        widthUnifier2.add(this.customerNumber);
        l = new JLabel("Gesch\u00e4ftspartnernummer");
        widthUnifier1.add(l);
        upperPanel.add(l);
        this.bussinessPartnerNumber = new JTextField(20);
        widthUnifier2.add(this.bussinessPartnerNumber);
        upperPanel.add(this.bussinessPartnerNumber);
        l = new JLabel("Auftragsnummer");
        l.setForeground(Color.MAGENTA);
        widthUnifier1.add(l);
        upperPanel.add(l);
        this.offerNumber = new JTextField(20);
        upperPanel.add(this.offerNumber);
        widthUnifier2.add(this.offerNumber);
        l = new JLabel("Anrede" + (this.markForSave ? "*" : ""));
        widthUnifier1.add(l);
        upperPanel.add(l);
        this.salutation = new EnumComboBox<Salutation>(Salutation.class, true);
        upperPanel.add(this.salutation);
        widthUnifier2.add(this.salutation);
        l = new JLabel("Firmenname" + (this.markForSave ? "*" : ""));
        l.setForeground(Color.MAGENTA);
        widthUnifier1.add(l);
        upperPanel.add(l);
        this.companyName = new JTextField(20);
        upperPanel.add(this.companyName);
        widthUnifier2.add(this.companyName);
        l = new JLabel("Vorname");
        l.setForeground(Color.MAGENTA);
        widthUnifier1.add(l);
        upperPanel.add(l);
        this.firstName = new JTextField(20);
        upperPanel.add(this.firstName);
        widthUnifier2.add(this.firstName);
        l = new JLabel("Nachname" + (this.markForSave ? "*" : ""));
        l.setForeground(Color.MAGENTA);
        widthUnifier1.add(l);
        upperPanel.add(l);
        this.lastName = new JTextField(20);
        upperPanel.add(this.lastName);
        widthUnifier2.add(this.lastName);
        l = new JLabel("Telefonnummer" + (this.markForSave ? "*" : ""));
        widthUnifier1.add(l);
        upperPanel.add(l);
        this.phone = new JTextField(20);
        upperPanel.add(this.phone);
        widthUnifier2.add(this.phone);
        l = new JLabel("Faxnummer");
        widthUnifier1.add(l);
        upperPanel.add(l);
        this.fax = new JTextField(20);
        upperPanel.add(this.fax);
        widthUnifier2.add(this.fax);
        l = new JLabel("Email-Adresse");
        widthUnifier1.add(l);
        upperPanel.add(l);
        this.email = new JTextField(20);
        upperPanel.add(this.email);
        widthUnifier2.add(this.email);
        l = new JLabel("");
        widthUnifier1.add(l);
        upperPanel.add(l);
        l = new JLabel("");
        widthUnifier2.add(l);
        upperPanel.add(l);
        widthUnifier1.unifyWidth();
        widthUnifier2.unifyWidth();
        SpringUtilities.makeCompactGrid(upperPanel, 3, 8, 5, 5, 10, 5);
        this.add(upperPanel);
        this.address = new AddressPane(true, this.markForSave, this.modelEnviroment.getAllCaller().getBaseCaller().getDefaultCountry());
        this.add(this.address);
        SpringUtilities.makeCompactGrid(this, 2, 1, 5, 5, 2, 2);
        this.clearValues();
    }

    public void setCustomerModel(CustomerModel customerModel) {
        if (customerModel == null) {
            this.companyName.setText("");
            this.salutation.setSelectedIndex(0);
            this.firstName.setText("");
            this.lastName.setText("");
            this.phone.setText("");
            this.fax.setText("");
            this.email.setText("");
            this.address.setLocation((LocationModel)null);
            this.bussinessPartnerNumber.setText("");
        } else {
            this.companyName.setText(StringUtil.nullToEmpty(customerModel.getCompanyName()));
            this.salutation.setSelectedValue(customerModel.getSalutation());
            this.firstName.setText(StringUtil.nullToEmpty(customerModel.getFirstName()));
            this.lastName.setText(StringUtil.nullToEmpty(customerModel.getLastName()));
            this.bussinessPartnerNumber.setText(StringUtil.nullToEmpty(customerModel.getBusinessPartnerNumber()));
            String customerNumber = customerModel.getCustomerNumber();
            this.customerNumber.setText(StringUtil.nullToEmpty(OfferSharedUtil.removePrefix(customerNumber)));
            this.agency.setSelectedItem(customerModel.getAgency());
            Iterator<CustomerPhoneContactModel> iterPhone = customerModel.iteratePhoneContacts();
            if (iterPhone.hasNext()) {
                CustomerPhoneContactModel phoneContactModel = iterPhone.next();
                this.phone.setText(StringUtil.nullToEmpty(phoneContactModel.getPhoneNumber()));
            } else {
                this.phone.setText("");
            }
            Iterator<CustomerFaxContactModel> iterFax = customerModel.iterateFaxContacts();
            if (iterFax.hasNext()) {
                CustomerFaxContactModel faxContactModel = iterFax.next();
                this.fax.setText(StringUtil.nullToEmpty(faxContactModel.getFaxNumber()));
            } else {
                this.fax.setText("");
            }
            Iterator<CustomerMailContactModel> iterMail = customerModel.iterateMailContacts();
            if (iterMail.hasNext()) {
                CustomerMailContactModel faxContactModel = iterMail.next();
                this.email.setText(StringUtil.nullToEmpty(faxContactModel.getEmail()));
            } else {
                this.email.setText("");
            }
            this.address.setLocation(customerModel.getDefaultLocation());
        }
    }

    public String getCompanyName() {
        return this.companyName == null ? null : this.companyName.getText();
    }

    public String getCustomerNumber() {
        return this.customerNumber.getText();
    }

    public String getEmail() {
        return this.email == null ? null : this.email.getText();
    }

    public String getFax() {
        return this.fax == null ? null : this.fax.getText();
    }

    public String getFirstName() {
        return this.firstName == null ? null : this.firstName.getText();
    }

    public String getLastName() {
        return this.lastName == null ? null : this.lastName.getText();
    }

    public String getPhone() {
        return this.phone == null ? null : this.phone.getText();
    }

    public Salutation getSalutation() {
        return this.salutation == null ? null : this.salutation.getSelectedValue();
    }

    public AddressPane getAddressPane() {
        return this.address;
    }

    public String getAgencyName() {
        AgencyModel agency = (AgencyModel)this.agency.getSelectedItem();
        return agency == null ? "" : agency.getName();
    }

    public String getAgencyNumber() {
        AgencyModel agency = (AgencyModel)this.agency.getSelectedItem();
        return agency == null ? "" : agency.getAgencyNumber();
    }

    public AgencyModel getAgency() {
        return (AgencyModel)this.agency.getSelectedItem();
    }

    public String getOfferNumber() {
        return this.offerNumber.getText();
    }

    public AgencyComboBox getAgencyComboBox() {
        return this.agency;
    }

    public void setOfferNumber(String offerNumber) {
        this.offerNumber.setText(offerNumber);
    }

    public void clearValues() {
        this.agency.setSelectedIndex(0);
        this.companyName.setText("");
        this.firstName.setText("");
        this.lastName.setText("");
        this.salutation.setSelectedIndex(0);
        this.phone.setText("");
        this.fax.setText("");
        this.email.setText("");
        if (this.address != null) {
            this.address.clearValues();
        }
        String nextCustomerNumber = this.modelEnviroment.getAllCaller().getBaseCaller().getNextCustomerNumber();
        this.customerNumber.setText(OfferSharedUtil.removePrefix(nextCustomerNumber));
        this.bussinessPartnerNumber.setText("");
    }

    public String getBusinessPartnerNumber() {
        return this.bussinessPartnerNumber.getText();
    }
}

