/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class TreeExpansionRememberAndRestore {
    private JTree tree;
    private Collection<TreePath> treePaths;

    public TreeExpansionRememberAndRestore(JTree tree) {
        this.tree = tree;
    }

    public void remember() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        this.treePaths = this.getExpandedTreePath(new TreePath(root));
    }

    private Collection<TreePath> getExpandedTreePath(TreePath tp) {
        if (this.tree.isExpanded(tp)) {
            DefaultMutableTreeNode dtm = (DefaultMutableTreeNode)tp.getLastPathComponent();
            if (dtm.isLeaf()) {
                return Collections.singletonList(tp);
            }
            LinkedList<TreePath> tps = new LinkedList<TreePath>();
            for (int i = 0; i < dtm.getChildCount(); ++i) {
                Object[] nPath = new Object[tp.getPathCount() + 1];
                System.arraycopy(tp.getPath(), 0, nPath, 0, tp.getPathCount());
                nPath[nPath.length - 1] = dtm;
                TreePath sTp = new TreePath(nPath);
                tps.addAll(this.getExpandedTreePath(sTp));
            }
            if (tps.isEmpty()) {
                return Collections.singletonList(tp);
            }
            return tps;
        }
        return Collections.emptyList();
    }

    public void restore() {
    }
}

