/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common.tree;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class MoveInTreeAction<T>
extends AbstractAction {
    private static final long serialVersionUID = -384774528960133886L;
    private MoveInListType moveInListType;
    private JTree tree;

    public MoveInTreeAction(String name, MoveInListType moveInListType, JTree tree) {
        super(name);
        this.moveInListType = moveInListType;
        this.tree = tree;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode dmt = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)dmt.getParent();
            int index = parent.getIndex(dmt);
            T t = this.doBefore();
            parent.remove(dmt);
            Integer newIndex = null;
            switch (this.moveInListType) {
                case DOWN: {
                    newIndex = Math.min(index + 1, parent.getChildCount());
                    parent.insert(dmt, newIndex);
                    break;
                }
                case HIGHEST: {
                    newIndex = 0;
                    parent.insert(dmt, 0);
                    break;
                }
                case LOWEST: {
                    newIndex = parent.getChildCount();
                    parent.add(dmt);
                    break;
                }
                case UP: {
                    newIndex = Math.max(index - 1, 0);
                    parent.insert(dmt, newIndex);
                }
            }
            this.doAfter(t);
            if (newIndex != null) {
                this.tree.setSelectionPath(treePath);
            }
        }
    }

    protected T doBefore() {
        return null;
    }

    protected void doAfter(T t) {
    }

    public static enum MoveInListType {
        UP,
        DOWN,
        HIGHEST,
        LOWEST;

    }
}

