/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common.table;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class CheckBoxHeaderRenderer
extends MouseAdapter
implements TableCellRenderer {
    private JCheckBox checkbox;
    private String label;
    private int column;
    private boolean mousePressed = false;

    public CheckBoxHeaderRenderer(String label) {
        this.label = label;
    }

    @Override
    public Component getTableCellRendererComponent(final JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTableHeader header = table.getTableHeader();
        if (this.checkbox == null) {
            this.checkbox = new JCheckBox(this.label);
            this.checkbox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Object source = e.getSource();
                    if (source instanceof JCheckBox) {
                        boolean checked = e.getStateChange() == 1;
                        int y = table.getRowCount();
                        for (int x = 0; x < y; ++x) {
                            table.setValueAt(new Boolean(checked), x, 0);
                        }
                    }
                    table.repaint(10L);
                }
            });
            this.checkbox.setForeground(header.getForeground());
            this.checkbox.setBackground(header.getBackground());
            this.checkbox.setFont(header.getFont());
            this.checkbox.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.checkbox.setBorderPainted(true);
            this.checkbox.setHorizontalAlignment(0);
            header.addMouseListener(this);
        }
        this.column = column;
        return this.checkbox;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.mousePressed) {
            this.mousePressed = false;
            JTableHeader header = (JTableHeader)e.getSource();
            TableColumnModel cm = header.getTable().getColumnModel();
            if (cm.getColumnIndexAtX(e.getX()) == this.column && e.getClickCount() == 1) {
                this.checkbox.doClick();
            }
            header.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mousePressed = true;
    }
}

