/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common.list;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JList;

public class MoveInListAction<T>
extends AbstractAction {
    private static final long serialVersionUID = -384774528960133886L;
    private MoveInListType moveInListType;
    private JList list;

    public MoveInListAction(String name, MoveInListType moveInListType, JList list) {
        super(name);
        this.moveInListType = moveInListType;
        this.list = list;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i = this.list.getSelectedIndex();
        if (i >= 0) {
            Object o = this.list.getSelectedValue();
            DefaultListModel dlm = (DefaultListModel)this.list.getModel();
            T t = this.doBefore();
            dlm.removeElementAt(i);
            Integer newIndex = null;
            switch (this.moveInListType) {
                case DOWN: {
                    newIndex = Math.min(i + 1, dlm.getSize());
                    dlm.insertElementAt(o, newIndex);
                    break;
                }
                case HIGHEST: {
                    dlm.insertElementAt(o, 0);
                    newIndex = 0;
                    break;
                }
                case LOWEST: {
                    newIndex = dlm.getSize();
                    dlm.addElement(o);
                    break;
                }
                case UP: {
                    newIndex = Math.max(i - 1, 0);
                    dlm.insertElementAt(o, newIndex);
                }
            }
            if (newIndex != null) {
                this.list.setSelectedIndex(newIndex);
            }
            this.doAfter(t);
        }
    }

    protected T doBefore() {
        return null;
    }

    protected void doAfter(T t) {
    }

    public static enum MoveInListType {
        UP,
        DOWN,
        HIGHEST,
        LOWEST;

    }
}

