/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common.font;

import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.client.gui.common.font.FontResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.PlainDocument;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class FontChooserComboBox
extends JComboBox
implements ItemListener {
    private static final long serialVersionUID = -6762987422317946302L;
    private int previewFontSize;
    private String previewString = "AaBbCc";
    private int recentFontsCount = 5;
    private List<String> fontNames;
    private HashMap<String, Item> itemsCache = new HashMap();
    private LinkedList<String> recentFontNames;
    private HashMap<String, Item> recentItemsCache = new HashMap();

    public FontChooserComboBox(FontResource resource, String defaultFont) {
        this.loadFontNames(resource, defaultFont);
        this.recentFontNames = new LinkedList();
        JLabel label = new JLabel();
        this.previewFontSize = label.getFont().getSize();
        this.updateList(defaultFont);
        this.setEditable(true);
        this.setEditor(new FontChooserComboBoxEditor());
        this.setRenderer(new FontChooserComboBoxRenderer());
        this.addItemListener(this);
    }

    private void loadFontNames(FontResource resource, String defaultFont) {
        Object[] fontNames = new String[]{};
        switch (resource) {
            case LOCAL: {
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                fontNames = ge.getAvailableFontFamilyNames();
                Arrays.sort(fontNames);
                break;
            }
            case FOP: {
                fontNames = PeppergisConstants.FONT_NAME_FOP;
            }
        }
        this.fontNames = Arrays.asList(fontNames);
    }

    public int getPreviewFontSize() {
        return this.previewFontSize;
    }

    public void setPreviewFontSize(int previewFontSize) {
        this.previewFontSize = previewFontSize;
        this.updateList(this.getSelectedFontName());
    }

    public String getPreviewString() {
        return this.previewString;
    }

    public void setPreviewString(String previewString) {
        this.previewString = previewString != null && previewString.length() > 0 ? previewString : null;
        this.updateList(this.getSelectedFontName());
    }

    public int getRecentFontsCount() {
        return this.recentFontsCount;
    }

    public void setRecentFontsCount(int recentFontsCount) {
        this.recentFontsCount = recentFontsCount;
        boolean listChanged = false;
        while (this.recentFontNames.size() > recentFontsCount) {
            this.recentFontNames.removeLast();
            listChanged = true;
        }
        if (listChanged) {
            this.updateList(this.getSelectedFontName());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String fontName = this.getSelectedFontName();
        if (!(fontName == null || this.recentFontsCount <= 0 || this.recentFontNames.size() > 0 && this.recentFontNames.getFirst().equals(fontName))) {
            this.recentFontNames.remove(fontName);
            this.recentFontNames.addFirst(fontName);
            if (this.recentFontNames.size() > this.recentFontsCount) {
                this.recentFontNames.removeLast();
            }
            this.updateList(fontName);
        }
    }

    private void updateList(String selectedFontName) {
        this.removeAllItems();
        this.itemsCache.clear();
        this.recentItemsCache.clear();
        boolean recentSet = false;
        if (this.recentFontNames.size() > 0) {
            for (String recentFontName : this.recentFontNames) {
                Item item = new Item(recentFontName);
                this.addItem(item);
                this.recentItemsCache.put(recentFontName, item);
            }
            this.addItem(new Item(null));
            recentSet = true;
        }
        Item toSelect = null;
        for (String fontName : this.fontNames) {
            Item item = new Item(fontName);
            this.addItem(item);
            this.itemsCache.put(fontName, item);
            if (recentSet || !new EqualsBuilder().append(fontName, selectedFontName).isEquals()) continue;
            toSelect = item;
        }
        if (toSelect != null) {
            this.setSelectedItem(toSelect);
        }
    }

    public String getSelectedFontName() {
        if (this.getSelectedItem() != null) {
            return ((Item)this.getSelectedItem()).font.getName();
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, new JComboBox<E>().getPreferredSize().height);
    }

    public void setSelectedFont(String fontName) {
        Item item = this.recentItemsCache.get(fontName);
        if (item == null) {
            item = this.itemsCache.get(fontName);
        }
        if (item != null) {
            super.setSelectedItem(item);
        }
    }

    class Item
    extends JPanel {
        private static final long serialVersionUID = -8033962108648709598L;
        private final Font font;
        private final boolean isSeparator;

        private Item(String fontName) {
            if (fontName != null) {
                this.font = new Font(fontName, 0, FontChooserComboBox.this.previewFontSize);
                this.isSeparator = false;
            } else {
                this.font = null;
                this.isSeparator = true;
            }
            this.setOpaque(true);
            if (!this.isSeparator) {
                this.setLayout(new FlowLayout(0));
                JLabel labelHelp = new JLabel(this.font.getName());
                this.add(labelHelp);
                if (FontChooserComboBox.this.previewString != null) {
                    StringBuilder thisPreview = new StringBuilder();
                    for (int i = 0; i < FontChooserComboBox.this.previewString.length(); ++i) {
                        char c = FontChooserComboBox.this.previewString.charAt(i);
                        if (!this.font.canDisplay(c)) continue;
                        thisPreview.append(c);
                    }
                    JLabel labelFont = new JLabel(thisPreview.toString());
                    labelFont.setFont(this.font);
                    this.add(labelFont);
                }
            } else {
                this.setLayout(new BorderLayout());
                this.add((Component)new JSeparator(0), "Center");
            }
        }

        @Override
        public String toString() {
            if (this.font != null) {
                return this.font.getName();
            }
            return "";
        }

        public boolean equals(Object obj) {
            if (obj instanceof Item) {
                Item other = (Item)obj;
                return new EqualsBuilder().append(this.font, other.font).isEquals();
            }
            return false;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.font).toHashCode();
        }
    }

    class FontChooserComboBoxRenderer
    implements ListCellRenderer {
        FontChooserComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Item item = (Item)value;
            boolean s = isSelected && !item.isSeparator;
            item.setBackground(s ? list.getSelectionBackground() : list.getBackground());
            item.setForeground(s ? list.getSelectionForeground() : list.getForeground());
            return item;
        }
    }

    class FontChooserComboBoxEditor
    extends BasicComboBoxEditor {
        private FontChooserComboBoxEditor() {
            this.editor.setDocument(new AutoCompletionDocument());
            if (FontChooserComboBox.this.fontNames.size() > 0) {
                this.editor.setText(((String)FontChooserComboBox.this.fontNames.get(0)).toString());
            }
        }

        private String getMatch(String input) {
            for (String fontName : FontChooserComboBox.this.fontNames) {
                if (!fontName.toLowerCase().startsWith(input.toLowerCase())) continue;
                return fontName;
            }
            return null;
        }

        public void replaceSelection(String s) {
            AutoCompletionDocument doc = (AutoCompletionDocument)this.editor.getDocument();
            try {
                Caret caret = this.editor.getCaret();
                int i = Math.min(caret.getDot(), caret.getMark());
                int j = Math.max(caret.getDot(), caret.getMark());
                doc.replace(i, j - i, s, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        class AutoCompletionDocument
        extends PlainDocument {
            private static final long serialVersionUID = 3290350899522284359L;
            private JTextField textField;

            AutoCompletionDocument() {
                this.textField = FontChooserComboBoxEditor.this.editor;
            }

            @Override
            public void replace(int i, int j, String s, AttributeSet attributeset) throws BadLocationException {
                super.remove(i, j);
                this.insertString(i, s, attributeset);
            }

            @Override
            public void insertString(int i, String s, AttributeSet attributeset) throws BadLocationException {
                if (s != null && !"".equals(s)) {
                    String s1 = this.getText(0, i);
                    String s2 = FontChooserComboBoxEditor.this.getMatch(s1 + s);
                    int j = i + s.length() - 1;
                    if (s2 == null) {
                        s2 = FontChooserComboBoxEditor.this.getMatch(s1);
                        --j;
                    }
                    if (s2 != null) {
                        FontChooserComboBox.this.setSelectedFont(s2);
                    }
                    super.remove(0, this.getLength());
                    super.insertString(0, s2, attributeset);
                    this.textField.setSelectionStart(j + 1);
                    this.textField.setSelectionEnd(this.getLength());
                }
            }

            @Override
            public void remove(int i, int j) throws BadLocationException {
                int k = this.textField.getSelectionStart();
                if (k > 0) {
                    --k;
                }
                String s = FontChooserComboBoxEditor.this.getMatch(this.getText(0, k));
                super.remove(0, this.getLength());
                super.insertString(0, s, null);
                if (s != null) {
                    FontChooserComboBox.this.setSelectedFont(s);
                }
                try {
                    this.textField.setSelectionStart(k);
                    this.textField.setSelectionEnd(this.getLength());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

