/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.time.TimeUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.text.NumberFormatter;
import org.ktde.util.datatypes.Tupel;

public class TimeDialog
extends CommonDialog {
    private static final long serialVersionUID = -3612003685958684924L;
    private Date time;
    private boolean changed = false;
    private JFormattedTextField year;
    private JFormattedTextField month;
    private JFormattedTextField day;
    private JFormattedTextField hour;
    private JFormattedTextField minute;
    private String pattern;

    public TimeDialog(Date time, String pattern, Component parent) {
        super(parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.circle.time", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.time = time;
        this.pattern = pattern == null ? FormUtil.TIMEFORMAT : pattern;
        this.buildLayout();
        if (time != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(time);
            this.year.setValue(calendar.get(1));
            this.month.setValue(calendar.get(2) + 1);
            this.day.setValue(calendar.get(5));
            this.hour.setValue(calendar.get(11));
            this.minute.setValue(calendar.get(12));
        }
        this.pack();
        this.center();
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = 4725914530827731363L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeDialog.this.createNewTime();
                TimeDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        NumberFormat numberFormat = ModelEnviroment.getMessageResolver().getNumberFormat();
        JPanel timePane = new JPanel(new SpringLayout());
        NumberFormatter yearFormatter = new NumberFormatter(new DecimalFormat("####"));
        yearFormatter.setValueClass(Integer.class);
        this.year = new JFormattedTextField(yearFormatter);
        NumberFormatter monthFormatter = new NumberFormatter(numberFormat);
        monthFormatter.setValueClass(Integer.class);
        monthFormatter.setMinimum(Integer.valueOf(1));
        monthFormatter.setMaximum(Integer.valueOf(12));
        this.month = new JFormattedTextField(monthFormatter);
        NumberFormatter dayFormatter = new NumberFormatter(numberFormat);
        dayFormatter.setValueClass(Integer.class);
        dayFormatter.setMinimum(Integer.valueOf(1));
        dayFormatter.setMaximum(Integer.valueOf(31));
        this.day = new JFormattedTextField(dayFormatter);
        NumberFormatter hourFormatter = new NumberFormatter(numberFormat);
        hourFormatter.setValueClass(Integer.class);
        hourFormatter.setMinimum(Integer.valueOf(0));
        hourFormatter.setMaximum(Integer.valueOf(22));
        this.hour = new JFormattedTextField(hourFormatter);
        NumberFormatter minuteFormatter = new NumberFormatter(numberFormat);
        minuteFormatter.setValueClass(Integer.class);
        minuteFormatter.setMinimum(Integer.valueOf(0));
        minuteFormatter.setMaximum(Integer.valueOf(59));
        this.minute = new JFormattedTextField(minuteFormatter);
        int rowSize = 0;
        if (this.pattern.contains(FormUtil.DATEFORMAT)) {
            timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.year", new Serializable[0])));
            timePane.add(this.year);
            timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.month", new Serializable[0])));
            timePane.add(this.month);
            timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.day", new Serializable[0])));
            timePane.add(this.day);
            rowSize += 3;
        }
        if (this.pattern.contains(FormUtil.CLOCKFORMAT)) {
            timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.hour", new Serializable[0])));
            timePane.add(this.hour);
            timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.minute", new Serializable[0])));
            timePane.add(this.minute);
            rowSize += 2;
        }
        SpringUtilities.makeCompactGrid(timePane, rowSize, 2, 5, 5, 5, 5);
        return timePane;
    }

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = 984873373777250869L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeDialog.this.dispose();
            }
        };
    }

    private void createNewTime() {
        Date newTime = TimeUtil.createDate((Integer)this.year.getValue(), (Integer)this.month.getValue() - 1, (Integer)this.day.getValue(), (Integer)this.hour.getValue(), (Integer)this.minute.getValue(), 0);
        this.changed = !this.time.equals(newTime);
        if (this.changed) {
            this.time = newTime;
        }
    }

    public static Tupel<Date, Boolean> createAndShow(Date time, Component parent) {
        return TimeDialog.createAndShow(time, null, parent);
    }

    public static Tupel<Date, Boolean> createAndShow(Date time, String pattern, Component parent) {
        TimeDialog dialog = new TimeDialog(time, pattern, parent);
        dialog.setVisible(true);
        return new Tupel<Date, Boolean>(dialog.time, dialog.changed);
    }
}

