/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common;

import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.type.RendererType;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.time.TimeUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import org.ktde.swing.navigator.DefaultMouseManipulator;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.util.datatypes.Tupel;

public abstract class TimeBarChartPane<O>
extends JPanel {
    private static final long serialVersionUID = 5267588428430341763L;
    private List<TimeBarList> barLists;
    private TimeAxis axis;
    private Tupel<Point, Collection<Object>> hover = new Tupel(null, new HashSet());
    private Collection<Object> drag = new HashSet<Object>();
    private Map<Shape, Collection<Object>> drawed = new HashMap<Shape, Collection<Object>>();

    public TimeBarChartPane(Date currentTime, Date startTime, int increment, int blockCount, final boolean changeDate) {
        this.axis = new TimeAxis(currentTime, startTime, increment, blockCount);
        Timer timer = new Timer(60000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeBarChartPane.this.setCurrentTime(new Date());
                TimeBarChartPane.this.repaint(10L);
            }
        });
        timer.setRepeats(true);
        timer.start();
        DefaultMouseManipulator mouseManipulator = new DefaultMouseManipulator(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (this.dragged) {
                    return;
                }
                ((Collection)TimeBarChartPane.this.hover.getElement2()).clear();
                Point point = e.getPoint();
                Collection objects = TimeBarChartPane.this.findObjects(point);
                if (!objects.isEmpty()) {
                    TimeBarChartPane.this.hover.setElement1(point);
                    ((Collection)TimeBarChartPane.this.hover.getElement2()).addAll(objects);
                }
                TimeBarChartPane.this.repaint(10L);
            }

            @Override
            public void mouseClickFinished(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
                JPopupMenu popupMenu;
                Point point = new Point(x, y);
                Collection objects = TimeBarChartPane.this.findObjects(point);
                if (objects.isEmpty()) {
                    return;
                }
                if (mouseButton == MouseButton.BUTTON1 && clickCount == 2) {
                    TimeBarChartPane.this.handleDoubleClicked(objects);
                } else if (mouseButton == MouseButton.BUTTON3 && clickCount == 1 && (popupMenu = TimeBarChartPane.this.createPopupMenu(TimeBarChartPane.this.axis.getTime(point), objects)) != null) {
                    popupMenu.show(TimeBarChartPane.this, x, y);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (TimeBarChartPane.this.drag.isEmpty()) {
                    TimeBarChartPane.this.axis.handleClick(e.getX(), e.getY(), changeDate);
                } else {
                    TimeBarChartPane.this.fireDragAndDrop(TimeBarChartPane.this.axis.getTime(e.getPoint()), TimeBarChartPane.this.drag);
                    TimeBarChartPane.this.drag.clear();
                    TimeBarChartPane.this.setCursor(Cursor.getDefaultCursor());
                }
                super.mouseReleased(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                if (e.getButton() == 1) {
                    for (Shape shape : TimeBarChartPane.this.drawed.keySet()) {
                        for (Object o : (Collection)TimeBarChartPane.this.drawed.get(shape)) {
                            Point point = e.getPoint();
                            if (!shape.contains(point)) continue;
                            TimeBarChartPane.this.drag.add(o);
                        }
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                super.mouseDragged(e);
                if (!TimeBarChartPane.this.drag.isEmpty()) {
                    TimeBarChartPane.this.setCursor(DragSource.DefaultMoveDrop);
                }
            }
        };
        this.addMouseListener(mouseManipulator);
        this.addMouseMotionListener(mouseManipulator);
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.drawed.clear();
        this.axis.drawAxis((Graphics2D)g, this);
        this.drawBars(this.axis, (Graphics2D)g);
        this.drawHover(this.hover, (Graphics2D)g);
    }

    protected abstract List<TimeBar> createTimeBarList(O var1);

    protected void handleDoubleClicked(Collection<Object> os) {
    }

    protected void fireDragAndDrop(Date time, Collection<Object> os) {
    }

    protected JPopupMenu createPopupMenu(Date time, Collection<Object> os) {
        return null;
    }

    protected List<String> getObjectInfos(Collection<Object> os) {
        return Collections.emptyList();
    }

    public void setObjects(List<O> os, Date startTime) {
        this.barLists = new ArrayList<TimeBarList>();
        for (O o : os) {
            this.barLists.add(new TimeBarList(o));
        }
        if (startTime != null) {
            this.axis.setStartTime(startTime);
        }
        this.repaint(10L);
    }

    private void drawBars(TimeAxis axis, Graphics2D g2d) {
        int i = 0;
        for (TimeBarList bar : this.barLists) {
            bar.draw(axis, g2d, ++i);
        }
    }

    private void drawHover(Tupel<Point, Collection<Object>> hover, Graphics2D g2d) {
        List<String> infos = this.getObjectInfos(hover.getElement2());
        if (infos.isEmpty()) {
            return;
        }
        Point point = hover.getElement1();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int textHeight = fm.getHeight();
        int maxTextWidth = 0;
        for (String info : infos) {
            int textWidth = fm.stringWidth(info);
            if (textWidth <= maxTextWidth) continue;
            maxTextWidth = textWidth;
        }
        float boxHeight = (float)((double)(textHeight * infos.size()) * 1.5 + 10.0);
        Rectangle2D.Float rectangle = new Rectangle2D.Float(point.x, (float)point.y - boxHeight, maxTextWidth + 10, boxHeight);
        g2d.setColor(Color.WHITE);
        g2d.fill(rectangle);
        g2d.setColor(Color.BLACK);
        g2d.draw(rectangle);
        double marginTop = 0.0;
        for (String info : infos) {
            g2d.drawString(info, point.x + 5, (int)((double)((float)point.y - boxHeight + (float)(textHeight * 3 / 2)) + marginTop));
            marginTop += (double)textHeight * 1.5;
        }
    }

    private Collection<Object> findObjects(Point point) {
        HashSet<Object> found = new HashSet<Object>();
        for (Shape shape : this.drawed.keySet()) {
            for (Object o : this.drawed.get(shape)) {
                if (!shape.contains(point)) continue;
                found.add(o);
            }
        }
        return found;
    }

    public Date getCurrentTime() {
        return this.axis.currentTime;
    }

    public void setCurrentTime(Date currentTime) {
        this.axis.currentTime = currentTime;
    }

    public void setIncrement(int increment) {
        this.axis.increment = increment;
    }

    public class TimeBar {
        private Object barObject;
        private Date barStart;
        private int duration;
        private Color color;
        private RendererType rendererType = RendererType.PLAIN;
        private int barHeight;
        private TimeBarType type = TimeBarType.NORMAL;
        private boolean allowedMouseClick = false;

        public TimeBar(Object barObject, Date barStart, int duration, Color color, int barHeight) {
            this.barObject = barObject;
            this.barStart = barStart;
            this.duration = duration;
            this.color = color;
            this.barHeight = barHeight;
        }

        protected Color getColor(Date date) {
            return this.color;
        }

        public void setRendererType(RendererType rendererType) {
            this.rendererType = rendererType;
        }

        public void setAllowedMouseClick(boolean allowedMouseClick) {
            this.allowedMouseClick = allowedMouseClick;
        }

        public void addStart() {
            switch (this.type) {
                case NORMAL: {
                    this.type = TimeBarType.START;
                    break;
                }
                case END: {
                    this.type = TimeBarType.BOTH;
                    break;
                }
            }
        }

        public void addEnd() {
            switch (this.type) {
                case NORMAL: {
                    this.type = TimeBarType.END;
                    break;
                }
                case START: {
                    this.type = TimeBarType.BOTH;
                    break;
                }
            }
        }
    }

    private static enum TimeBarType {
        NORMAL,
        START,
        END,
        BOTH;


        private boolean isStart() {
            switch (this) {
                case START: 
                case BOTH: {
                    return true;
                }
            }
            return false;
        }

        private boolean isEnd() {
            switch (this) {
                case BOTH: 
                case END: {
                    return true;
                }
            }
            return false;
        }
    }

    private class TimeBarList {
        private O o;

        private TimeBarList(O o) {
            this.o = o;
        }

        private void draw(TimeAxis axis, Graphics2D g2d, int index) {
            List<TimeBar> bars = TimeBarChartPane.this.createTimeBarList(this.o);
            if (bars == null || bars.isEmpty()) {
                return;
            }
            double axisDuration = axis.increment * axis.blockCount;
            double secondPixel = (double)TimeBarChartPane.this.getWidth() / axisDuration;
            TimeBar pred = null;
            Rectangle2D.Float predRectangle = null;
            for (TimeBar bar : bars) {
                int barWidth = (int)((double)bar.duration * secondPixel);
                int middleY = (int)((double)(axis.topOffset + axis.tickOffset) + (double)TimeBarChartPane.this.axis.barMaxHeight * ((double)index - 0.5));
                int x = (int)((double)((bar.barStart.getTime() - axis.startTime.getTime()) / 1000L) * secondPixel);
                int y = (int)((double)middleY - (double)bar.barHeight * 0.5);
                Rectangle2D.Float rectangle = new Rectangle2D.Float(x, y, barWidth + 1, bar.barHeight);
                if (bar.rendererType == RendererType.PLAIN) {
                    g2d.setColor(bar.getColor(TimeBarChartPane.this.getCurrentTime()));
                    g2d.fill(rectangle);
                    g2d.setColor(Color.BLACK);
                    g2d.draw(rectangle);
                } else if (bar.rendererType == RendererType.HATCH_LINE) {
                    g2d.setColor(Color.WHITE);
                    g2d.fill(rectangle);
                    g2d.drawImage((Image)this.createDiagonal(((RectangularShape)rectangle).getWidth(), ((RectangularShape)rectangle).getHeight(), bar.getColor(TimeBarChartPane.this.getCurrentTime())), (int)((RectangularShape)rectangle).getX(), (int)((RectangularShape)rectangle).getY(), null);
                    g2d.setColor(Color.BLACK);
                    g2d.draw(rectangle);
                }
                if (bar.type.isStart() && !bar.barStart.before(axis.startTime)) {
                    Ellipse2D.Double circle = new Ellipse2D.Double();
                    circle.x = (int)((double)((bar.barStart.getTime() - axis.startTime.getTime()) / 1000L) * secondPixel) - axis.tickOffset / 2;
                    circle.y = middleY - axis.tickOffset / 2;
                    circle.width = circle.height = (double)axis.tickOffset;
                    g2d.setColor(Color.WHITE);
                    g2d.fill(circle);
                    g2d.setStroke(new BasicStroke(3.0f));
                    g2d.setColor(PeppergisConstants.TRACKING_CURRENT_COLOR);
                    g2d.draw(circle);
                    TimeBarChartPane.this.drawed.put(circle, CollectionUtil.buildHashSet(bar.barObject));
                    g2d.setStroke(new BasicStroke(1.0f));
                }
                Date barEndTime = TimeUtil.add(bar.barStart, 13, bar.duration);
                Date axisEndTime = TimeUtil.add(axis.startTime, 13, (int)axisDuration);
                if (bar.type.isEnd() && !barEndTime.after(axisEndTime)) {
                    Ellipse2D.Double circle = new Ellipse2D.Double();
                    circle.x = (int)((double)((barEndTime.getTime() - axis.startTime.getTime()) / 1000L) * secondPixel) - axis.tickOffset / 2;
                    circle.y = middleY - axis.tickOffset / 2;
                    circle.width = circle.height = (double)axis.tickOffset;
                    g2d.setColor(Color.WHITE);
                    g2d.fill(circle);
                    g2d.setStroke(new BasicStroke(3.0f));
                    g2d.setColor(PeppergisConstants.TRACKING_CURRENT_COLOR);
                    g2d.draw(circle);
                    TimeBarChartPane.this.drawed.put(circle, CollectionUtil.buildHashSet(bar.barObject));
                    g2d.setStroke(new BasicStroke(1.0f));
                }
                if (bar.allowedMouseClick) {
                    long l;
                    Collection<Object> set = CollectionUtil.buildHashSet(bar.barObject);
                    if (pred != null && pred.allowedMouseClick && (l = bar.barStart.getTime() - pred.barStart.getTime() - (long)pred.duration * 1000L) < 60000L) {
                        set = (Collection)TimeBarChartPane.this.drawed.remove(predRectangle);
                        set.add(bar.barObject);
                        ((Rectangle2D)rectangle).setRect(((RectangularShape)predRectangle).getX(), ((RectangularShape)predRectangle).getY(), ((RectangularShape)predRectangle).getWidth() + ((RectangularShape)rectangle).getWidth(), ((RectangularShape)predRectangle).getHeight());
                    }
                    TimeBarChartPane.this.drawed.put(rectangle, set);
                }
                predRectangle = rectangle;
                pred = bar;
            }
        }

        private BufferedImage createDiagonal(double width, double height, Color color) {
            BufferedImage bi = new BufferedImage((int)width, (int)height, 2);
            Graphics2D big = bi.createGraphics();
            big.setColor(color);
            Line2D.Double p = new Line2D.Double();
            for (double x = -height; x < width; x += height / 3.0) {
                p.setLine(x, height, x + height, 0.0);
                big.draw(p);
            }
            return bi;
        }
    }

    private class TimeAxis {
        private int increment = 3600;
        private int topOffset = 35;
        private int tickOffset = 10;
        private int barMaxHeight = 40;
        private Date currentTime;
        private Date startTime;
        private int blockCount;
        private Polygon toPred;
        private Polygon toNext;

        private TimeAxis(Date currentTime, Date startTime, int increment, int blockCount) {
            this.currentTime = currentTime;
            this.increment = increment;
            this.blockCount = blockCount;
            this.setStartTime(startTime);
        }

        private void drawAxis(Graphics2D g2d, JComponent parent) {
            int width = TimeBarChartPane.this.getWidth();
            int height = TimeBarChartPane.this.getHeight();
            g2d.setColor(Color.WHITE);
            g2d.fillRect(0, 0, width, height);
            this.drawLabels(g2d, parent);
            g2d.setColor(Color.BLACK);
            g2d.drawLine(0, this.topOffset + this.tickOffset, width, this.topOffset + this.tickOffset);
            this.drawTick(this.increment, height - this.topOffset, false, g2d);
            this.drawTick(this.increment / 2, height - this.topOffset, true, g2d);
            this.drawTick(this.increment / 4, this.tickOffset, false, g2d);
            this.drawCurrentTime(g2d);
        }

        private void drawCurrentTime(Graphics2D g2d) {
            double durationInSecond = this.increment * this.blockCount;
            double inPixel = (double)TimeBarChartPane.this.getWidth() / durationInSecond;
            int fromLeft = (int)((double)((this.currentTime.getTime() - this.startTime.getTime()) / 1000L) * inPixel);
            if (fromLeft > 0) {
                g2d.setColor(PeppergisConstants.TRACKING_CURRENT_COLOR);
                int y1 = this.topOffset + this.tickOffset;
                g2d.drawLine(fromLeft, y1, fromLeft, TimeBarChartPane.this.getHeight());
                int r = this.tickOffset * 2 / 3;
                int y2 = y1 - r;
                int[] xs = new int[]{fromLeft, fromLeft - this.tickOffset / 3, fromLeft + this.tickOffset / 3, fromLeft};
                int[] ys = new int[]{y1, y2, y2, y1};
                Polygon pinTriangle = new Polygon(xs, ys, 4);
                g2d.fill(pinTriangle);
                Ellipse2D.Double circle = new Ellipse2D.Double();
                circle.x = fromLeft - r;
                circle.y = this.topOffset - r;
                circle.width = 2 * r;
                circle.height = 2 * r;
                g2d.fill(circle);
            }
        }

        private void drawTick(int increment, int tickHeight, boolean b, Graphics2D g2d) {
            double durationInSecond = this.increment * this.blockCount;
            double incrementInPixel = (double)increment * ((double)TimeBarChartPane.this.getWidth() / durationInSecond);
            int i = 1;
            while ((double)i < durationInSecond / (double)increment) {
                int fromLeft = (int)((double)i * incrementInPixel);
                if (b) {
                    float f = 5.0f;
                    BasicStroke strokeDash = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{f, f}, 0.0f);
                    g2d.setStroke(strokeDash);
                } else {
                    BasicStroke stroke = new BasicStroke(1.0f);
                    g2d.setStroke(stroke);
                }
                g2d.drawLine(fromLeft, this.topOffset, fromLeft, this.topOffset + tickHeight);
                ++i;
            }
        }

        private void drawLabels(Graphics2D g2d, JComponent parent) {
            double durationInSecond = this.increment * this.blockCount;
            int paneWidth = TimeBarChartPane.this.getWidth();
            double incrementInPixel = (double)this.increment * ((double)paneWidth / durationInSecond);
            g2d.setColor(Color.BLACK);
            FontMetrics fm = parent.getFontMetrics(TimeBarChartPane.this.getFont());
            for (int i = 1; i < this.blockCount; ++i) {
                int fromLeft = (int)((double)i * incrementInPixel);
                Date date = new Date(this.startTime.getTime() + (long)(i * this.increment * 1000));
                String timeLabel = "" + TimeUtil.formatDate(date, FormUtil.CLOCKFORMAT);
                int textWidth = fm.stringWidth(timeLabel);
                int textHeight = fm.getHeight();
                g2d.drawString(timeLabel, fromLeft - textWidth / 2, this.topOffset - textHeight / 2);
            }
            g2d.setColor(new Color(89, 189, 197));
            int x1 = 5;
            int x2 = (int)(incrementInPixel / 5.0);
            int[] xs = new int[]{x1, x2, x2, x1};
            int offset = this.topOffset - this.tickOffset;
            int[] ys = new int[]{offset, offset - fm.getHeight() / 2, offset + fm.getHeight() / 2, offset};
            this.toPred = new Polygon(xs, ys, 4);
            g2d.fill(this.toPred);
            xs = new int[]{paneWidth - x1, paneWidth - x2, paneWidth - x2, paneWidth - x1};
            this.toNext = new Polygon(xs, ys, 4);
            g2d.fill(this.toNext);
        }

        private void setStartTime(Date startTime) {
            Calendar c = Calendar.getInstance();
            c.setTime(startTime);
            c.set(12, 0);
            c.set(13, 0);
            this.startTime = c.getTime();
        }

        private void handleClick(int x, int y, boolean changeDate) {
            Date newStartTime = null;
            if (this.toPred.contains(x, y)) {
                newStartTime = TimeUtil.add(this.startTime, 11, -1);
                if (!changeDate && !TimeUtil.isSamedDay(this.startTime, newStartTime)) {
                    newStartTime = null;
                }
            } else if (this.toNext.contains(x, y)) {
                newStartTime = TimeUtil.add(this.startTime, 11, 1);
                int duration = this.increment * this.blockCount - 3600;
                Date endTime = TimeUtil.add(this.startTime, 13, duration);
                Date newEndTime = TimeUtil.add(newStartTime, 13, duration);
                if (!changeDate && !TimeUtil.isSamedDay(endTime, newEndTime)) {
                    newStartTime = null;
                }
            }
            if (newStartTime != null) {
                this.startTime = newStartTime;
                TimeBarChartPane.this.repaint(10L);
            }
        }

        private Date getTime(Point location) {
            int width = TimeBarChartPane.this.getWidth();
            double durationInSecond = this.increment * this.blockCount;
            double offsetInSecond = durationInSecond / (double)width * location.getX();
            return TimeUtil.add(this.startTime, 13, (int)Math.round(offsetInSecond));
        }
    }
}

