/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;

public class TableCellComponentEditor<C extends JComponent>
implements TableCellEditor {
    private JTable table;
    private Hashtable<Integer, TableCellEditor> editors;
    protected TableCellEditor comboBoxEditor;
    private TableCellEditor defaultEditor;

    public TableCellComponentEditor(JTable table) {
        this.table = table;
        this.editors = new Hashtable();
        this.defaultEditor = new DefaultCellEditor(new JTextField());
    }

    public void setEditorAt(int row, C c) {
        if (c instanceof JCheckBox) {
            this.editors.put(row, new DefaultCellEditor((JCheckBox)c));
        } else if (c instanceof JComboBox) {
            this.editors.put(row, new DefaultCellEditor((JComboBox)c));
        } else if (c instanceof JTextField) {
            this.editors.put(row, new DefaultCellEditor((JTextField)c));
        } else {
            this.editors.put(row, null);
        }
    }

    public C getEditorAt(int row) {
        return (C)((JComponent)((DefaultCellEditor)this.editors.get(row)).getComponent());
    }

    @Override
    public Object getCellEditorValue() {
        return this.comboBoxEditor.getCellEditorValue();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.comboBoxEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public boolean stopCellEditing() {
        return this.comboBoxEditor.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.comboBoxEditor.cancelCellEditing();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        this.selectEditor((MouseEvent)anEvent);
        return this.comboBoxEditor.isCellEditable(anEvent);
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.comboBoxEditor.addCellEditorListener(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.comboBoxEditor.removeCellEditorListener(l);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        this.selectEditor((MouseEvent)anEvent);
        return this.comboBoxEditor.shouldSelectCell(anEvent);
    }

    public void selectEditor(MouseEvent e) {
        int row = e == null ? this.table.getSelectionModel().getAnchorSelectionIndex() : this.table.rowAtPoint(e.getPoint());
        this.comboBoxEditor = this.editors.get(new Integer(row));
        if (this.comboBoxEditor == null) {
            this.comboBoxEditor = this.defaultEditor;
        }
    }
}

