/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common;

import java.awt.Color;
import java.awt.event.ItemEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class ScrollablePopupMenuButton
extends JButton {
    private static final long serialVersionUID = 1224991863538292753L;
    public static final Color MENU_HIGHLIGHT_BG_COLOR = UIManager.getColor("MenuItem.selectionBackground");
    public static final Color MENU_HIGHLIGHT_FG_COLOR = UIManager.getColor("MenuItem.selectionForeground");
    public static final Color MENUITEM_BG_COLOR = UIManager.getColor("MenuItem.background");
    public static final Color MENUITEM_FG_COLOR = UIManager.getColor("MenuItem.foreground");

    public ScrollablePopupMenuButton() {
        this.init();
    }

    public ScrollablePopupMenuButton(String text) {
        super(text);
        this.init();
    }

    public ScrollablePopupMenuButton(Action action) {
        super(action);
        this.init();
    }

    private void init() {
        ComponentUI ui = BasicButtonUI.createUI(this);
        this.setUI(ui);
        this.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 2));
        this.setMenuItemDefaultColors();
        this.setHorizontalTextPosition(4);
        this.setHorizontalAlignment(2);
        this.setModel(new XCheckedButtonModel());
        this.setSelected(false);
    }

    private void setMenuItemDefaultColors() {
        this.setBackground(MENUITEM_BG_COLOR);
        this.setForeground(MENUITEM_FG_COLOR);
    }

    private class XCheckedButtonModel
    extends JToggleButton.ToggleButtonModel {
        private static final long serialVersionUID = -2470653444216382785L;

        private XCheckedButtonModel() {
        }

        @Override
        public void setSelected(boolean b) {
            ButtonGroup group = this.getGroup();
            if (group != null) {
                group.setSelected(this, b);
                b = group.isSelected(this);
            }
            if (this.isSelected() == b) {
                return;
            }
            this.stateMask = b ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
            this.fireStateChanged();
            this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
        }
    }
}

