/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;

public class ScrollablePopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = 36173552701187862L;
    private Box menuItems;
    private Dimension preferredSize;

    public ScrollablePopupMenu(Dimension preferredSize) {
        this.setLayout(new BorderLayout());
        this.menuItems = Box.createVerticalBox();
        this.menuItems.setBackground(UIManager.getColor("MenuItem.background"));
        this.preferredSize = preferredSize;
    }

    public void show(Component invoker, Point point) {
        this.menuItems.validate();
        super.add(new JScrollPane(this.menuItems));
        super.pack();
        this.setInvoker(invoker);
        this.setPopupSize(this.preferredSize);
        Point invokerPoint = invoker.getLocationOnScreen();
        this.setLocation((int)invokerPoint.getX() + point.x, (int)invokerPoint.getY() + point.y);
        this.setVisible(true);
    }

    @Override
    public void removeAll() {
        this.menuItems.removeAll();
        super.removeAll();
    }

    public void hidemenu() {
        if (this.isVisible()) {
            this.setVisible(false);
        }
    }

    public void add(AbstractButton menuItem) {
        this.menuItems.add(menuItem);
    }

    public void add(AbstractButton menuItem, ActionListener actionListener) {
        if (menuItem == null) {
            return;
        }
        this.menuItems.add(menuItem);
        menuItem.addActionListener(actionListener);
    }

    @Override
    public void addSeparator() {
        this.menuItems.add(new PopMenuSeperator());
    }

    private static class PopMenuSeperator
    extends JSeparator {
        private static final long serialVersionUID = 8909999434884280938L;

        PopMenuSeperator() {
            ComponentUI ui = XBasicSeparatorUI.createUI(this);
            this.setUI(ui);
        }

        private static class XBasicSeparatorUI
        extends BasicSeparatorUI {
            private XBasicSeparatorUI() {
            }

            public static ComponentUI createUI(JComponent c) {
                return new XBasicSeparatorUI();
            }

            @Override
            public void paint(Graphics g, JComponent c) {
                Dimension s = c.getSize();
                if (((JSeparator)c).getOrientation() == 1) {
                    g.setColor(c.getForeground());
                    g.drawLine(0, 0, 0, s.height);
                    g.setColor(c.getBackground());
                    g.drawLine(1, 0, 1, s.height);
                } else {
                    g.setColor(c.getForeground());
                    g.drawLine(0, 7, s.width, 7);
                    g.setColor(c.getBackground());
                    g.drawLine(0, 8, s.width, 8);
                }
            }
        }
    }
}

