/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common;

import de.datomino.peppergis.client.gui.common.EnumItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class EnumComboBox<T extends Enum<T>>
extends JComboBox<Object> {
    private static final long serialVersionUID = -8666309019194158792L;
    private Class<T> clazz;

    public EnumComboBox(Class<T> clazz, boolean withEmpty) {
        super(EnumComboBox.createEnumItems(clazz, EnumSet.allOf(clazz), withEmpty, new String[0]));
        this.clazz = clazz;
    }

    public EnumComboBox(Class<T> clazz, boolean withEmpty, T ... ts) {
        super(EnumComboBox.createEnumItems(clazz, Arrays.asList(ts), withEmpty, new String[0]));
        this.clazz = clazz;
    }

    public EnumComboBox(Class<T> clazz, boolean withEmpty, Collection<T> ts) {
        super(EnumComboBox.createEnumItems(clazz, ts, withEmpty, new String[0]));
        this.clazz = clazz;
    }

    protected EnumComboBox(Class<T> clazz, boolean withEmpty, Collection<T> ts, String ... preAdditonalElements) {
        super(EnumComboBox.createEnumItems(clazz, ts, withEmpty, preAdditonalElements));
        this.clazz = clazz;
    }

    private static <T extends Enum<T>> Vector<Object> createEnumItems(Class<T> clazz, Collection<T> items, boolean withEmpty, String ... preAdditonalElements) {
        Vector<Object> vector = new Vector<Object>(items.size() + (withEmpty ? 1 : 0));
        if (withEmpty) {
            vector.addElement("");
        }
        for (String add : preAdditonalElements) {
            vector.add(add);
        }
        for (Enum t : items) {
            vector.addElement(new EnumItem<Enum>(t));
        }
        return vector;
    }

    public T getSelectedValue() {
        Object o = super.getSelectedItem();
        if (o == null || o instanceof String) {
            return null;
        }
        return ((EnumItem)o).getT();
    }

    public void setSelectedValue(T t) {
        if (t == null) {
            super.setSelectedIndex(0);
        } else {
            super.setSelectedItem(new EnumItem<T>(t));
        }
    }

    public void setElements(boolean withEmpty, T ... t) {
        this.setElements(withEmpty, false, (Enum[])t);
    }

    public void setElements(boolean withEmpty, boolean keepSelection, T ... t) {
        T selected = this.getSelectedValue();
        DefaultComboBoxModel<Object> dcm = new DefaultComboBoxModel<Object>(EnumComboBox.createEnumItems(this.clazz, Arrays.asList(t), withEmpty, new String[0]));
        this.setModel(dcm);
        if (keepSelection) {
            this.setSelectedValue(selected);
        }
    }
}

