/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common;

import de.datomino.tools.maven.SpringUtilities;
import de.datomino.util.swing.WidthUnifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DurationPicker
extends JPanel {
    private static final long serialVersionUID = -2368041111520086094L;
    private JSpinner hour;
    private JSpinner minute;
    private JSpinner second;
    private List<ChangeListener> listeners = new LinkedList<ChangeListener>();

    public DurationPicker() {
        this(true, true, true);
    }

    public DurationPicker(boolean hour, boolean minute, boolean second) {
        super(new BorderLayout());
        this.buildLayout(hour, minute, second);
    }

    private void buildLayout(boolean hour, boolean minute, boolean second) {
        JPanel panel = new JPanel(new SpringLayout());
        DurationPickerChangeListener durationPickerChangeListener = new DurationPickerChangeListener();
        WidthUnifier widthUnifier = new WidthUnifier();
        if (hour) {
            this.hour = new JSpinner(new SpinnerNumberModel(0, 0, 23, 1));
            this.hour.addChangeListener(durationPickerChangeListener);
            panel.add(this.hour);
            widthUnifier.add(this.hour);
        }
        if (minute) {
            if (hour) {
                panel.add(new JLabel(":"));
            }
            this.minute = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
            this.minute.addChangeListener(durationPickerChangeListener);
            panel.add(this.minute);
            widthUnifier.add(this.minute);
        }
        if (second) {
            if (hour || minute) {
                panel.add(new JLabel(":"));
            }
            this.second = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
            this.second.addChangeListener(durationPickerChangeListener);
            panel.add(this.second);
            widthUnifier.add(this.second);
        }
        widthUnifier.unifyWidth();
        int size = widthUnifier.size();
        if (size > 0) {
            SpringUtilities.makeCompactGrid(panel, 1, size + (size - 1), 0, 0, 0, 0);
        }
        this.add((Component)panel, "West");
    }

    public void setDurationInSeconds(int seconds) {
        int sSeconds = seconds % 60;
        int minutes = seconds / 60;
        if (this.second == null) {
            if (sSeconds >= 30) {
                ++minutes;
            }
        } else {
            this.second.setValue(sSeconds);
        }
        int sMinutes = minutes % 60;
        int hours = minutes / 60;
        if (this.minute == null) {
            if (sMinutes >= 30) {
                ++hours;
            }
        } else {
            this.minute.setValue(sMinutes);
        }
        if (hours > 23) {
            if (this.hour != null) {
                this.hour.setValue(23);
            }
            if (this.minute != null) {
                this.minute.setValue(59);
            }
            if (this.second != null) {
                this.second.setValue(59);
            }
        } else if (this.hour != null) {
            this.hour.setValue(hours);
        }
        this.fireChangeEvent(new ChangeEvent(this));
    }

    public int getDurationInSeconds() {
        int result = 0;
        if (this.second != null) {
            result += ((Integer)this.second.getValue()).intValue();
        }
        if (this.minute != null) {
            result += (Integer)this.minute.getValue() * 60;
        }
        if (this.hour != null) {
            result += (Integer)this.hour.getValue() * 60 * 60;
        }
        return result;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.second != null) {
            this.second.setEnabled(enabled);
        }
        if (this.minute != null) {
            this.minute.setEnabled(enabled);
        }
        if (this.hour != null) {
            this.hour.setEnabled(enabled);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    protected void fireChangeEvent(ChangeEvent e) {
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    private class DurationPickerChangeListener
    implements ChangeListener {
        private DurationPickerChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            DurationPicker.this.fireChangeEvent(e);
        }
    }
}

