/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DatePicker
extends JPanel {
    private static final long serialVersionUID = 3699713704315753781L;
    private JSpinner spinnerYear;
    private JComboBox<String> comboBoxMonth;
    private JComboBox<Integer> comboBoxDay;
    private Collection<ChangeListener> changeListener;

    public DatePicker() {
        this(new Date());
    }

    public DatePicker(Date date) {
        super(new FlowLayout());
        String[] months = new DateFormatSymbols().getMonths();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.changeListener = new LinkedList<ChangeListener>();
        this.spinnerYear = new JSpinner(new SpinnerNumberModel((Number)cal.get(1), null, null, (Number)1));
        this.spinnerYear.setEditor(new JSpinner.NumberEditor(this.spinnerYear, "#"));
        DefaultComboBoxModel<String> modelMonths = new DefaultComboBoxModel<String>(months);
        if (months[months.length - 1] == "") {
            modelMonths.removeElementAt(modelMonths.getSize() - 1);
        }
        this.comboBoxMonth = new JComboBox<String>(modelMonths);
        this.comboBoxMonth.setSelectedIndex(cal.get(2));
        Integer[] init = new Integer[]{1};
        this.comboBoxDay = new JComboBox<Integer>(new DefaultComboBoxModel<Integer>(init));
        this.handleChange();
        DatePickerListener datePickerListener = new DatePickerListener();
        this.spinnerYear.addChangeListener(datePickerListener);
        this.comboBoxMonth.addActionListener(datePickerListener);
        this.comboBoxDay.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && DatePicker.this.comboBoxDay.isFocusOwner()) {
                    DatePicker.this.fireStateChanged();
                }
            }
        });
        this.add(this.comboBoxDay);
        this.add(this.comboBoxMonth);
        this.add(this.spinnerYear);
    }

    private void handleChange() {
        Integer year = (Integer)this.spinnerYear.getValue();
        int month = this.comboBoxMonth.getSelectedIndex();
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        int maximum = cal.getActualMaximum(5);
        Integer selected = (Integer)this.comboBoxDay.getSelectedItem();
        if (this.comboBoxDay.getItemCount() == 1) {
            selected = cal.get(5);
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.comboBoxDay.getModel();
        model.removeAllElements();
        for (int i = 1; i <= maximum; ++i) {
            model.addElement(i);
        }
        this.comboBoxDay.setSelectedItem(Math.min(maximum, selected));
        this.fireStateChanged();
    }

    public Date getValue() {
        return this.getSelectedItem();
    }

    public Date getSelectedItem() {
        Calendar cal = Calendar.getInstance();
        cal.set((Integer)this.spinnerYear.getValue(), this.comboBoxMonth.getSelectedIndex(), (Integer)this.comboBoxDay.getSelectedItem(), 0, 0, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public void setSelectedItem(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.spinnerYear.setValue(cal.get(1));
        this.comboBoxMonth.setSelectedIndex(cal.get(2));
        this.handleChange();
        this.comboBoxDay.setSelectedItem(cal.get(5));
        this.fireStateChanged();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.spinnerYear.setEnabled(enabled);
        this.comboBoxDay.setEnabled(enabled);
        this.comboBoxMonth.setEnabled(enabled);
    }

    public void addChangeListener(ChangeListener listener) {
        if (listener != null) {
            this.changeListener.add(listener);
        }
    }

    private void fireStateChanged() {
        for (ChangeListener listener : this.changeListener) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    private class DatePickerListener
    implements ActionListener,
    ChangeListener {
        private DatePickerListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            DatePicker.this.handleChange();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DatePicker.this.handleChange();
        }
    }
}

