/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common;

import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public abstract class CommonDialog
extends JDialog {
    private static final long serialVersionUID = -5717404490053464458L;
    private Component parent;
    private boolean button;
    private Image imageIcon;

    public CommonDialog(Component parent, String title, Dialog.ModalityType modalityType) {
        this(parent, title, modalityType, true);
    }

    public CommonDialog(Component parent, String title, Dialog.ModalityType modalityType, boolean button) {
        super(SwingUtils.findWindowParent(parent), title, modalityType);
        this.parent = parent;
        this.button = button;
    }

    public void buildLayout() {
        try {
            this.imageIcon = ImageIO.read(CommonDialog.class.getResourceAsStream("/images/pepper.png"));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.setIconImage(this.imageIcon);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.getMainComponent(), "Center");
        if (this.button) {
            JPanel buttonPanel = new JPanel(new BorderLayout());
            JPanel subButtonPanel = new JPanel(new FlowLayout());
            for (Action action : this.getAdditionalActions()) {
                JButton button = new JButton(action);
                subButtonPanel.add(button);
            }
            JButton ok = new JButton(this.getOkAction());
            subButtonPanel.add(ok);
            Action cancelAction = this.getCancelAction();
            if (cancelAction != null) {
                JButton cancel = new JButton(cancelAction);
                subButtonPanel.add(cancel);
            }
            buttonPanel.add((Component)subButtonPanel, "East");
            Action[] additionalWestActions = this.getAdditionalWestActions();
            if (additionalWestActions != null && additionalWestActions.length > 0) {
                subButtonPanel = new JPanel(new FlowLayout());
                for (Action action : additionalWestActions) {
                    JButton button = new JButton(action);
                    subButtonPanel.add(button);
                    buttonPanel.add((Component)subButtonPanel, "West");
                }
            }
            this.getContentPane().add((Component)buttonPanel, "South");
        }
    }

    protected abstract Action getOkAction();

    protected abstract Action getCancelAction();

    protected abstract Component getMainComponent();

    protected void center() {
        SwingUtils.centerDialog(this, this.parent);
    }

    protected Action[] getAdditionalActions() {
        return new Action[0];
    }

    protected Action[] getAdditionalWestActions() {
        return new Action[0];
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        boolean b = true;
        if (e.getID() == 201) {
            b = this.close();
        }
        if (b) {
            super.processWindowEvent(e);
        }
    }

    protected boolean close() {
        return true;
    }

    protected Image getImageIcon() {
        return this.imageIcon;
    }
}

