/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.common;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractEditableJList<T>
extends JPanel {
    private static final long serialVersionUID = -7356807635552906870L;
    private JList list;
    private AddAction addAction;
    private RemoveAction removeAction;
    private Set<T> uneditableElements = new HashSet<T>();

    public AbstractEditableJList() {
        super(new BorderLayout());
        this.buildLayout(true, true, false);
    }

    public AbstractEditableJList(boolean addable, boolean removeable, boolean updateable) {
        super(new BorderLayout());
        this.buildLayout(addable, removeable, updateable);
    }

    private void buildLayout(boolean addable, boolean removeable, boolean updateable) {
        this.list = new JList(new DefaultListModel());
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new EditableListSelectionListener());
        this.list.setCellRenderer(new EditableListRenderer());
        JScrollPane scroll = new JScrollPane(this.list);
        scroll.setHorizontalScrollBarPolicy(32);
        this.add((Component)scroll, "Center");
        if (addable || removeable) {
            JPanel buttonPanel = new JPanel(new BorderLayout());
            if (addable) {
                this.addAction = new AddAction();
                buttonPanel.add((Component)new JButton(this.addAction), "East");
            }
            if (removeable) {
                this.removeAction = new RemoveAction();
                this.removeAction.setEnabled(false);
                buttonPanel.add((Component)new JButton(this.removeAction), "West");
            }
            this.add((Component)buttonPanel, "South");
        }
        if (updateable) {
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Object item;
                    super.mouseClicked(e);
                    if (e.getClickCount() > 1 && (item = AbstractEditableJList.this.list.getSelectedValue()) != null) {
                        AbstractEditableJList.this.update(item);
                    }
                }
            });
        }
    }

    protected abstract void update(T var1);

    protected abstract T getAdd();

    protected abstract void remove(T var1);

    protected abstract String getStringRepresentation(T var1);

    public DefaultListModel getModel() {
        return (DefaultListModel)this.list.getModel();
    }

    public JList getList() {
        return this.list;
    }

    public List<T> getSelectedValues() {
        Object[] selected = this.list.getSelectedValues();
        ArrayList<Object> list = new ArrayList<Object>(selected.length);
        for (Object o : selected) {
            list.add(o);
        }
        return list;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.addAction.setEnabled(enabled);
        boolean removeEnabled = enabled;
        if (enabled) {
            int s = this.list.getSelectedIndex();
            removeEnabled = s >= 0;
        }
        this.removeAction.setEnabled(removeEnabled);
    }

    public void setSelectedValues(Collection<T> selects, boolean b) {
        DefaultListModel dlm = (DefaultListModel)this.list.getModel();
        ArrayList<Integer> s = new ArrayList<Integer>(selects.size());
        for (int i = 0; i < dlm.size(); ++i) {
            for (T select : selects) {
                if (!dlm.elementAt(i).equals(select)) continue;
                s.add(i);
            }
        }
        int[] sa = new int[s.size()];
        int count = 0;
        Integer min = null;
        for (Integer i : s) {
            sa[count++] = i;
            min = min == null ? i : Math.min(min, i);
        }
        this.list.setSelectedIndices(sa);
        if (b && min != null) {
            this.list.ensureIndexIsVisible(min);
        }
    }

    public void addUneditableElement(T t) {
        this.uneditableElements.add(t);
    }

    public void clearUneditableElements() {
        this.uneditableElements.clear();
    }

    private class EditableListRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 7926932122470800243L;

        private EditableListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String string = AbstractEditableJList.this.getStringRepresentation(value);
            return super.getListCellRendererComponent((JList<?>)list, string, index, isSelected, cellHasFocus);
        }
    }

    private class EditableListSelectionListener
    implements ListSelectionListener {
        private EditableListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (AbstractEditableJList.this.removeAction != null) {
                Object t = AbstractEditableJList.this.list.getSelectedValue();
                AbstractEditableJList.this.removeAction.setEnabled(t != null && !AbstractEditableJList.this.uneditableElements.contains(t));
            }
        }
    }

    private class RemoveAction
    extends AbstractAction {
        private static final long serialVersionUID = -311024077851973501L;

        public RemoveAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.remove", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] deletes;
            for (Object t : deletes = AbstractEditableJList.this.list.getSelectedValues()) {
                AbstractEditableJList.this.remove(t);
            }
            int[] selected = AbstractEditableJList.this.list.getSelectedIndices();
            DefaultListModel dlm = (DefaultListModel)AbstractEditableJList.this.list.getModel();
            for (int i = selected.length - 1; i >= 0; --i) {
                dlm.removeElementAt(selected[i]);
            }
        }
    }

    private class AddAction
    extends AbstractAction {
        private static final long serialVersionUID = 1173246523785284619L;

        public AddAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object t = AbstractEditableJList.this.getAdd();
            if (t != null) {
                DefaultListModel dlm = (DefaultListModel)AbstractEditableJList.this.list.getModel();
                dlm.addElement(t);
            }
        }
    }
}

