/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.attribute.filter.simple;

import de.datomino.peppergis.client.gui.attribute.filter.simple.AbstractSimpleAttributeSingleValuePane;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.filter.SimpleAttributeValueFilterModel;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueDescriptorModel;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.peppergis.type.attribute.StaticChoiceValue;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;

public class StaticSimpleAttributeSingleValuePane<T extends Model, S extends Model>
extends AbstractSimpleAttributeSingleValuePane<T, S> {
    private static final long serialVersionUID = -4682011457164463777L;
    private JComboBox staticChoices;
    private Collection<AttributeValueDescriptorModel<T, S>> descriptorModels;

    public StaticSimpleAttributeSingleValuePane(Collection<AttributeValueDescriptorModel<T, S>> descriptorModels) {
        super(AttributeValueType.STATIC_CHOICE, descriptorModels);
        this.descriptorModels = descriptorModels;
        super.initialize(AttributeValueType.STATIC_CHOICE, descriptorModels);
    }

    @Override
    protected void initialize(AttributeValueType attributeValueType, Collection<AttributeValueDescriptorModel<T, S>> descriptorModels) {
    }

    @Override
    protected void adaptConstantValueToModel(SimpleAttributeValueFilterModel simpleAttributeValueFilterModel) {
        int select = this.getStaticChoices().getSelectedIndex();
        StaticChoiceValue staticChoiceValue = (StaticChoiceValue)this.getStaticChoices().getItemAt(select);
        if (staticChoiceValue != null) {
            simpleAttributeValueFilterModel.setStaticChoiceValue(staticChoiceValue.getValue());
        }
    }

    @Override
    protected Component getConstantWidget() {
        return this.getStaticChoices();
    }

    @Override
    protected void setConstantValue(SimpleAttributeValueFilterModel simpleAttributeValueFilterModel) {
        this.keyChanged(simpleAttributeValueFilterModel.getKey());
        String value = simpleAttributeValueFilterModel.getStaticChoiceValue();
        int select = 0;
        JComboBox staticChoiceComboBox = this.getStaticChoices();
        if (value != null) {
            for (int i = 0; i < staticChoiceComboBox.getItemCount(); ++i) {
                StaticChoiceValue staticChoiceValue = (StaticChoiceValue)staticChoiceComboBox.getItemAt(i);
                if (!value.equals(staticChoiceValue.getValue())) continue;
                select = i;
                break;
            }
        }
        if (staticChoiceComboBox.getModel().getSize() > 0) {
            staticChoiceComboBox.setSelectedIndex(select);
        }
    }

    @Override
    protected void setConstantWidgetEnabled(boolean b) {
        this.getStaticChoices().setEnabled(b);
    }

    private JComboBox getStaticChoices() {
        if (this.staticChoices == null) {
            this.staticChoices = new JComboBox();
            this.staticChoices.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StaticSimpleAttributeSingleValuePane.this.fireChangeEvent(new ChangeEvent(StaticSimpleAttributeSingleValuePane.this));
                }
            });
        }
        return this.staticChoices;
    }

    @Override
    public void keyChanged(String key) {
        super.keyChanged(key);
        this.getStaticChoices().removeAllItems();
        for (AttributeValueDescriptorModel<T, S> attributeValueDescriptorModel : this.descriptorModels) {
            if (!attributeValueDescriptorModel.getKey().equals(key)) continue;
            for (StaticChoiceValue staticChoiceValue : attributeValueDescriptorModel.getStaticChoiceValues()) {
                this.getStaticChoices().addItem(staticChoiceValue);
            }
        }
    }
}

