/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.attribute.filter.simple;

import de.datomino.peppergis.client.gui.attribute.filter.simple.AbstractSimpleAttributeSingleValuePane;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.filter.SimpleAttributeValueFilterModel;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueDescriptorModel;
import de.datomino.peppergis.type.AttributeValueType;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Collection;
import javax.swing.JFormattedTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;

public class IntegerSimpleAttributeSingleValuePane<T extends Model, S extends Model>
extends AbstractSimpleAttributeSingleValuePane<T, S> {
    private static final long serialVersionUID = 2549630042011821420L;
    private JFormattedTextField formattedTextField;
    private AbstractDocument abstractDocumentTextField;
    private IntegerDocumentFilter intDocumentFilter = new IntegerDocumentFilter();

    public IntegerSimpleAttributeSingleValuePane(Collection<AttributeValueDescriptorModel<T, S>> descriptorModels) {
        super(AttributeValueType.INTEGER, descriptorModels);
    }

    @Override
    protected void adaptConstantValueToModel(SimpleAttributeValueFilterModel simpleAttributeValueFilterModel) {
        try {
            this.getFormattedTextField().commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Number number = (Number)this.getFormattedTextField().getValue();
        simpleAttributeValueFilterModel.setIntegerValue(number == null ? null : Integer.valueOf(number.intValue()));
    }

    @Override
    protected Component getConstantWidget() {
        return this.getFormattedTextField();
    }

    @Override
    protected void setConstantValue(SimpleAttributeValueFilterModel simpleAttributeValueFilterModel) {
        Integer value = simpleAttributeValueFilterModel.getIntegerValue();
        this.getFormattedTextField().setValue(value);
    }

    @Override
    protected void setConstantWidgetEnabled(boolean b) {
        this.getFormattedTextField().setEditable(b);
    }

    private JFormattedTextField getFormattedTextField() {
        if (this.formattedTextField == null) {
            this.formattedTextField = new JFormattedTextField(new DecimalFormat("#"));
            PlainDocument docTextField = (PlainDocument)this.formattedTextField.getDocument();
            if (docTextField instanceof AbstractDocument) {
                this.abstractDocumentTextField = docTextField;
                this.abstractDocumentTextField.setDocumentFilter(this.intDocumentFilter);
            }
            this.formattedTextField.getDocument().addDocumentListener(new DocumentListener(){
                private String currentValue = " ";
                private String[] memory = new String[2];
                private byte i = 0;

                @Override
                public void removeUpdate(DocumentEvent e) {
                    try {
                        if (!e.getDocument().getText(0, e.getDocument().getLength()).equals(this.memory[0]) || !this.memory[0].equals(this.memory[1])) {
                            IntegerSimpleAttributeSingleValuePane.this.fireChangeEvent(new ChangeEvent(IntegerSimpleAttributeSingleValuePane.this));
                            this.i = (byte)(this.i + 1);
                            this.memory[Math.abs((int)(this.i % 2))] = e.getDocument().getText(0, e.getDocument().getLength());
                        }
                    }
                    catch (BadLocationException e1) {
                        throw new RuntimeException(e1);
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    try {
                        if (!this.currentValue.equals(e.getDocument().getText(0, e.getDocument().getLength()))) {
                            this.currentValue = e.getDocument().getText(0, e.getDocument().getLength());
                            IntegerSimpleAttributeSingleValuePane.this.fireChangeEvent(new ChangeEvent(IntegerSimpleAttributeSingleValuePane.this));
                        }
                    }
                    catch (BadLocationException e1) {
                        throw new RuntimeException(e1);
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
        }
        return this.formattedTextField;
    }

    private class IntegerDocumentFilter
    extends DocumentFilter {
        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            System.out.println(fb.toString() + "***" + offset + "***");
            super.insertString(fb, offset, string, attr);
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            System.out.println(fb.toString() + "***" + offset + "***" + length);
            super.remove(fb, offset, length);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            System.out.println(fb.toString() + "***" + offset + "***" + length);
            super.replace(fb, offset, length, text, attrs);
        }
    }
}

