/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.attribute.filter.simple;

import de.datomino.peppergis.client.gui.attribute.filter.simple.AbstractSimpleAttributeSingleValuePane;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.filter.SimpleAttributeValueFilterModel;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueDescriptorModel;
import de.datomino.peppergis.type.AttributeValueType;
import java.awt.Component;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class DateSimpleAttributeSingleValuePane<T extends Model, S extends Model>
extends AbstractSimpleAttributeSingleValuePane<T, S> {
    private static final long serialVersionUID = -8574584868751253373L;
    private static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private JFormattedTextField dateField;

    public DateSimpleAttributeSingleValuePane(Collection<AttributeValueDescriptorModel<T, S>> descriptorModels) {
        super(AttributeValueType.DATE, descriptorModels);
    }

    @Override
    protected void adaptConstantValueToModel(SimpleAttributeValueFilterModel simpleAttributeValueFilterModel) {
        try {
            this.getDateField().commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Date date = (Date)this.getDateField().getValue();
        Long l = date == null ? null : Long.valueOf(date.getTime());
        simpleAttributeValueFilterModel.setLongValue(l);
    }

    @Override
    protected Component getConstantWidget() {
        return this.getDateField();
    }

    @Override
    protected void setConstantValue(SimpleAttributeValueFilterModel simpleAttributeValueFilterModel) {
        Long l = simpleAttributeValueFilterModel.getLongValue();
        Date date = l == null ? null : new Date(l);
        this.getDateField().setValue(date);
    }

    @Override
    protected void setConstantWidgetEnabled(boolean b) {
        this.getDateField().setEnabled(b);
    }

    private JFormattedTextField getDateField() {
        if (this.dateField == null) {
            this.dateField = new JFormattedTextField(new SimpleDateFormat(TIME_FORMAT));
            this.dateField.getDocument().addDocumentListener(new DocumentListener(){
                private String currentValue = " ";
                private String[] memory = new String[2];
                private byte i = 0;

                @Override
                public void removeUpdate(DocumentEvent e) {
                    try {
                        if (!e.getDocument().getText(0, e.getDocument().getLength()).equals(this.memory[0]) || !this.memory[0].equals(this.memory[1])) {
                            DateSimpleAttributeSingleValuePane.this.fireChangeEvent(new ChangeEvent(DateSimpleAttributeSingleValuePane.this));
                            this.i = (byte)(this.i + 1);
                            this.memory[Math.abs((int)(this.i % 2))] = e.getDocument().getText(0, e.getDocument().getLength());
                        }
                    }
                    catch (BadLocationException e1) {
                        throw new RuntimeException(e1);
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    try {
                        if (!this.currentValue.equals(e.getDocument().getText(0, e.getDocument().getLength()))) {
                            this.currentValue = e.getDocument().getText(0, e.getDocument().getLength());
                            DateSimpleAttributeSingleValuePane.this.fireChangeEvent(new ChangeEvent(DateSimpleAttributeSingleValuePane.this));
                        }
                    }
                    catch (BadLocationException e1) {
                        throw new RuntimeException(e1);
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
        }
        return this.dateField;
    }
}

