/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.attribute.filter.simple;

import de.datomino.peppergis.client.gui.attribute.filter.simple.AbstractSimpleAttributeSingleValuePane;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.filter.SimpleAttributeValueFilterModel;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueDescriptorModel;
import de.datomino.peppergis.type.AttributeValueType;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;

public class BooleanSimpleAttributeSingleValuePane<T extends Model, S extends Model>
extends AbstractSimpleAttributeSingleValuePane<T, S> {
    private static final long serialVersionUID = 48613326652920390L;
    private JCheckBox booleanValue;

    public BooleanSimpleAttributeSingleValuePane(Collection<AttributeValueDescriptorModel<T, S>> descriptorModels) {
        super(AttributeValueType.BOOLEAN, descriptorModels);
    }

    @Override
    protected void adaptConstantValueToModel(SimpleAttributeValueFilterModel simpleAttributeValueFilterModel) {
        simpleAttributeValueFilterModel.setBooleanValue(this.getCheckbox().isSelected());
    }

    @Override
    protected Component getConstantWidget() {
        return this.getCheckbox();
    }

    private JCheckBox getCheckbox() {
        if (this.booleanValue == null) {
            this.booleanValue = new JCheckBox();
            this.booleanValue.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BooleanSimpleAttributeSingleValuePane.this.fireChangeEvent(new ChangeEvent(BooleanSimpleAttributeSingleValuePane.this));
                }
            });
        }
        return this.booleanValue;
    }

    @Override
    protected void setConstantValue(SimpleAttributeValueFilterModel simpleAttributeValueFilterModel) {
        Boolean value = simpleAttributeValueFilterModel.getBooleanValue();
        this.getCheckbox().setSelected(value != null && value != false);
    }

    @Override
    protected void setConstantWidgetEnabled(boolean b) {
        this.getCheckbox().setEnabled(b);
    }
}

