/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.attribute.filter;

import de.datomino.peppergis.client.gui.attribute.filter.AbstractAttributeFilterPane;
import de.datomino.peppergis.client.gui.attribute.filter.simple.AbstractSimpleAttributeSingleValuePane;
import de.datomino.peppergis.client.gui.attribute.filter.simple.BooleanSimpleAttributeSingleValuePane;
import de.datomino.peppergis.client.gui.attribute.filter.simple.DateSimpleAttributeSingleValuePane;
import de.datomino.peppergis.client.gui.attribute.filter.simple.FloatSimpleAttributeSingleValuePane;
import de.datomino.peppergis.client.gui.attribute.filter.simple.IntegerSimpleAttributeSingleValuePane;
import de.datomino.peppergis.client.gui.attribute.filter.simple.StaticSimpleAttributeSingleValuePane;
import de.datomino.peppergis.client.gui.attribute.filter.simple.StringSimpleAttributeSingleValuePane;
import de.datomino.peppergis.client.gui.attribute.filter.simple.TextSimpleAttributeSingleValuePane;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.filter.SimpleAttributeValueFilterModel;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueDescriptorModel;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.peppergis.type.Relation;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class SimpleAttriubteFilterPane<T extends Model, S extends Model>
extends JPanel {
    private static final long serialVersionUID = 5777632524763809910L;
    private JComboBox descriptorComboBox;
    private JComboBox relationComboBox;
    private JPanel valuePane;
    private CardLayout cardLayout;
    private Map<AttributeValueType, AbstractSimpleAttributeSingleValuePane<T, S>> singleValueMap = new HashMap<AttributeValueType, AbstractSimpleAttributeSingleValuePane<T, S>>();
    private SimpleAttributeValueFilterModel simpleAttributeValueFilterModel;
    private AbstractAttributeFilterPane<T, S> absAttributeFilterPane;
    private boolean filterExternallyChanged = false;
    private boolean renewingRelations = false;

    public SimpleAttriubteFilterPane(AbstractAttributeFilterPane<T, S> absAttributeFilterPane) {
        super(new BorderLayout());
        this.absAttributeFilterPane = absAttributeFilterPane;
        Collection<AttributeValueDescriptorModel<T, S>> attributeValueDescriptorModels = this.getDescriptors();
        this.buildLayout(attributeValueDescriptorModels);
        this.fillDescriptors(attributeValueDescriptorModels);
    }

    private void fillDescriptors(Collection<AttributeValueDescriptorModel<T, S>> attributeValueDescriptorModels) {
        DefaultComboBoxModel dcm = (DefaultComboBoxModel)this.descriptorComboBox.getModel();
        block3: for (AttributeValueDescriptorModel<T, S> attributeValueDescriptorModel : attributeValueDescriptorModels) {
            switch (attributeValueDescriptorModel.getAttributeValueType()) {
                case MULTIPLE_LIST_CHOICE: 
                case IMAGE: 
                case PDF_DOWN: 
                case MULTI_INTEGER: {
                    continue block3;
                }
            }
            dcm.addElement(new DescriptorItem(attributeValueDescriptorModel));
        }
    }

    protected abstract Collection<AttributeValueDescriptorModel<T, S>> getDescriptors();

    private void buildLayout(Collection<AttributeValueDescriptorModel<T, S>> attributeValueDescriptorModels) {
        JPanel commonPane = new JPanel(new SpringLayout());
        commonPane.add(new JLabel("Attribut"));
        this.descriptorComboBox = new JComboBox(new DefaultComboBoxModel());
        this.descriptorComboBox.addActionListener(new DescriptorComboBoxActionListener());
        commonPane.add(this.descriptorComboBox);
        commonPane.add(new JLabel("Relation"));
        this.relationComboBox = new JComboBox(new DefaultComboBoxModel());
        this.relationComboBox.addActionListener(new RelationComboBoxActionListener());
        commonPane.add(this.relationComboBox);
        JLabel label = new JLabel("Wert");
        label.setVerticalAlignment(1);
        commonPane.add(label);
        this.cardLayout = new CardLayout();
        this.valuePane = new JPanel(this.cardLayout);
        JPanel emptyPane = new JPanel();
        this.valuePane.add((Component)emptyPane, "");
        BooleanSimpleAttributeSingleValuePane<T, S> booleanSimpleAttributeSingleValuePane = new BooleanSimpleAttributeSingleValuePane<T, S>(attributeValueDescriptorModels);
        this.valuePane.add(booleanSimpleAttributeSingleValuePane, AttributeValueType.BOOLEAN.name());
        this.singleValueMap.put(AttributeValueType.BOOLEAN, booleanSimpleAttributeSingleValuePane);
        DateSimpleAttributeSingleValuePane<T, S> dateSimpleAttributeSingleValuePane = new DateSimpleAttributeSingleValuePane<T, S>(attributeValueDescriptorModels);
        this.valuePane.add(dateSimpleAttributeSingleValuePane, AttributeValueType.DATE.name());
        this.singleValueMap.put(AttributeValueType.DATE, dateSimpleAttributeSingleValuePane);
        IntegerSimpleAttributeSingleValuePane<T, S> intSimpleAttributeSingleValuePane = new IntegerSimpleAttributeSingleValuePane<T, S>(attributeValueDescriptorModels);
        this.valuePane.add(intSimpleAttributeSingleValuePane, AttributeValueType.INTEGER.name());
        this.singleValueMap.put(AttributeValueType.INTEGER, intSimpleAttributeSingleValuePane);
        StaticSimpleAttributeSingleValuePane<T, S> staticSimpleAttributeSingleValuePane = new StaticSimpleAttributeSingleValuePane<T, S>(attributeValueDescriptorModels);
        this.valuePane.add(staticSimpleAttributeSingleValuePane, AttributeValueType.STATIC_CHOICE.name());
        this.singleValueMap.put(AttributeValueType.STATIC_CHOICE, staticSimpleAttributeSingleValuePane);
        StringSimpleAttributeSingleValuePane<T, S> stringSimpleAttributeSingleValuePane = new StringSimpleAttributeSingleValuePane<T, S>(attributeValueDescriptorModels);
        this.valuePane.add(stringSimpleAttributeSingleValuePane, AttributeValueType.STRING.name());
        this.singleValueMap.put(AttributeValueType.STRING, stringSimpleAttributeSingleValuePane);
        TextSimpleAttributeSingleValuePane<T, S> textSimpleAttributeSingleValuePane = new TextSimpleAttributeSingleValuePane<T, S>(attributeValueDescriptorModels);
        this.valuePane.add(textSimpleAttributeSingleValuePane, AttributeValueType.TEXT.name());
        this.singleValueMap.put(AttributeValueType.TEXT, textSimpleAttributeSingleValuePane);
        FloatSimpleAttributeSingleValuePane<T, S> floatSimpleAttributeSingleValuePane = new FloatSimpleAttributeSingleValuePane<T, S>(attributeValueDescriptorModels);
        this.valuePane.add(floatSimpleAttributeSingleValuePane, AttributeValueType.FLOAT.name());
        this.singleValueMap.put(AttributeValueType.FLOAT, floatSimpleAttributeSingleValuePane);
        for (Map.Entry<AttributeValueType, AbstractSimpleAttributeSingleValuePane<T, S>> entry : this.singleValueMap.entrySet()) {
            entry.getValue().addChangeListener(new ElementsChangeListener());
        }
        commonPane.add(this.valuePane);
        this.cardLayout.show(this.valuePane, "");
        SpringUtilities.makeCompactGrid(commonPane, 3, 2, 5, 5, 2, 2);
        this.add((Component)commonPane, "North");
    }

    public void setFilter(SimpleAttributeValueFilterModel simpleAttributeValueFilterModel) {
        this.filterExternallyChanged = true;
        this.simpleAttributeValueFilterModel = simpleAttributeValueFilterModel;
        if (simpleAttributeValueFilterModel == null) {
            this.setEnabled(false);
            this.clearValues();
        } else {
            AbstractSimpleAttributeSingleValuePane<T, S> pane;
            AttributeValueType attributeValueType;
            String key = simpleAttributeValueFilterModel.getKey();
            DefaultComboBoxModel dcm = (DefaultComboBoxModel)this.descriptorComboBox.getModel();
            AttributeValueDescriptorModel attributeValueDescriptorModel = null;
            for (int i = 0; i < dcm.getSize(); ++i) {
                DescriptorItem item = (DescriptorItem)dcm.getElementAt(i);
                AttributeValueDescriptorModel currentAttributeValueDescriptorModel = item.getAttributeValueDescriptorModel();
                if (!currentAttributeValueDescriptorModel.getKey().equals(key)) continue;
                this.descriptorComboBox.setSelectedIndex(i);
                attributeValueDescriptorModel = currentAttributeValueDescriptorModel;
                break;
            }
            if (attributeValueDescriptorModel == null && this.descriptorComboBox.getItemCount() != 0) {
                this.descriptorComboBox.setSelectedIndex(0);
                DescriptorItem item = (DescriptorItem)dcm.getElementAt(0);
                attributeValueDescriptorModel = item.getAttributeValueDescriptorModel();
            }
            dcm = (DefaultComboBoxModel)this.relationComboBox.getModel();
            boolean found = false;
            for (int i = 0; i < dcm.getSize(); ++i) {
                RelationItem item = (RelationItem)dcm.getElementAt(i);
                if (item.getRelation() != simpleAttributeValueFilterModel.getRelation()) continue;
                this.relationComboBox.setSelectedIndex(i);
                found = true;
                break;
            }
            if (!found && this.relationComboBox.getModel().getSize() > 0) {
                this.relationComboBox.setSelectedIndex(0);
            }
            AttributeValueType attributeValueType2 = attributeValueType = attributeValueDescriptorModel == null ? null : attributeValueDescriptorModel.getAttributeValueType();
            if (attributeValueType != null && (pane = this.singleValueMap.get((Object)attributeValueType)) != null) {
                pane.setValue(simpleAttributeValueFilterModel);
            }
            this.cardLayout.show(this.valuePane, attributeValueType == null ? "" : attributeValueType.name());
            this.valuePane.repaint(10L);
        }
        this.filterExternallyChanged = false;
    }

    private void clearValues() {
        this.cardLayout.show(this.valuePane, "");
    }

    public void adaptValuesToModel() {
        DescriptorItem descriptorItem;
        if (this.simpleAttributeValueFilterModel != null && (descriptorItem = (DescriptorItem)this.descriptorComboBox.getSelectedItem()) != null) {
            AttributeValueDescriptorModel attributeValueDescriptorModel = descriptorItem.getAttributeValueDescriptorModel();
            AttributeValueType attributeValueType = attributeValueDescriptorModel.getAttributeValueType();
            AbstractSimpleAttributeSingleValuePane<T, S> simpleAttributeSingleValuePane = this.singleValueMap.get((Object)attributeValueType);
            if (simpleAttributeSingleValuePane != null) {
                simpleAttributeSingleValuePane.adaptValuesToModel(this.simpleAttributeValueFilterModel);
            }
            this.simpleAttributeValueFilterModel.setKey(attributeValueDescriptorModel.getKey());
            this.simpleAttributeValueFilterModel.setServiceValueType(attributeValueType);
            RelationItem relationItem = (RelationItem)this.relationComboBox.getSelectedItem();
            if (relationItem != null) {
                this.simpleAttributeValueFilterModel.setRelation(relationItem.getRelation());
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled &= this.simpleAttributeValueFilterModel != null);
        this.descriptorComboBox.setEnabled(enabled);
        this.relationComboBox.setEnabled(enabled);
        for (AbstractSimpleAttributeSingleValuePane<T, S> simpleAttributeSingleValuePane : this.singleValueMap.values()) {
            simpleAttributeSingleValuePane.setEnabled(enabled);
        }
    }

    private class DescriptorItem {
        private AttributeValueDescriptorModel<T, S> attributeValueDescriptorModel;

        public DescriptorItem(AttributeValueDescriptorModel<T, S> attributeValueDescriptorModel) {
            this.attributeValueDescriptorModel = attributeValueDescriptorModel;
        }

        public AttributeValueDescriptorModel<T, S> getAttributeValueDescriptorModel() {
            return this.attributeValueDescriptorModel;
        }

        public String toString() {
            return this.getAttributeValueDescriptorModel().getName();
        }
    }

    private class RelationItem {
        private Relation relation;

        public RelationItem(Relation relation) {
            this.relation = relation;
        }

        public Relation getRelation() {
            return this.relation;
        }

        public String toString() {
            switch (this.getRelation()) {
                case EQUALS: {
                    return "=";
                }
                case GE: {
                    return ">=";
                }
                case GT: {
                    return ">";
                }
                case LE: {
                    return "<=";
                }
                case LT: {
                    return "<";
                }
            }
            return "";
        }
    }

    private class DescriptorComboBoxActionListener
    implements ActionListener {
        private DescriptorComboBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DescriptorItem descriptorItem = (DescriptorItem)SimpleAttriubteFilterPane.this.descriptorComboBox.getSelectedItem();
            AttributeValueDescriptorModel attributeValueDescriptorModel = descriptorItem.getAttributeValueDescriptorModel();
            List<Object> relations = null;
            AttributeValueType attributeValueType = attributeValueDescriptorModel.getAttributeValueType();
            SimpleAttriubteFilterPane.this.cardLayout.show(SimpleAttriubteFilterPane.this.valuePane, attributeValueType.name());
            AbstractSimpleAttributeSingleValuePane pane = (AbstractSimpleAttributeSingleValuePane)SimpleAttriubteFilterPane.this.singleValueMap.get((Object)attributeValueType);
            if (pane != null) {
                pane.keyChanged(attributeValueDescriptorModel.getKey());
            }
            switch (attributeValueType) {
                case BOOLEAN: {
                    relations = Collections.singletonList(Relation.EQUALS);
                    break;
                }
                case DATE: {
                    relations = Arrays.asList(Relation.values());
                    break;
                }
                case INTEGER: {
                    relations = Arrays.asList(Relation.values());
                    break;
                }
                case STATIC_CHOICE: {
                    relations = Collections.singletonList(Relation.EQUALS);
                    break;
                }
                case STRING: {
                    relations = Arrays.asList(Relation.values());
                    break;
                }
                case TEXT: {
                    relations = Arrays.asList(Relation.values());
                    break;
                }
                case FLOAT: {
                    relations = Arrays.asList(Relation.values());
                    break;
                }
                case MULTIPLE_LIST_CHOICE: 
                case IMAGE: 
                case PDF_DOWN: 
                case MULTI_INTEGER: {
                    relations = Collections.emptyList();
                    break;
                }
            }
            SimpleAttriubteFilterPane.this.renewingRelations = true;
            DefaultComboBoxModel dcm = (DefaultComboBoxModel)SimpleAttriubteFilterPane.this.relationComboBox.getModel();
            dcm.removeAllElements();
            for (Relation relation : relations) {
                dcm.addElement(new RelationItem(relation));
            }
            SimpleAttriubteFilterPane.this.renewingRelations = false;
            if (!SimpleAttriubteFilterPane.this.filterExternallyChanged && SimpleAttriubteFilterPane.this.absAttributeFilterPane.simpleAttributeFilterPaneIsNotNull()) {
                SimpleAttriubteFilterPane.this.absAttributeFilterPane.refreshTree();
            }
        }
    }

    private class RelationComboBoxActionListener
    implements ActionListener {
        private RelationComboBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SimpleAttriubteFilterPane.this.filterExternallyChanged && !SimpleAttriubteFilterPane.this.renewingRelations && SimpleAttriubteFilterPane.this.absAttributeFilterPane.simpleAttributeFilterPaneIsNotNull()) {
                SimpleAttriubteFilterPane.this.absAttributeFilterPane.refreshTree();
            }
        }
    }

    private class ElementsChangeListener
    implements ChangeListener {
        private ElementsChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SimpleAttriubteFilterPane.this.absAttributeFilterPane.refreshTree();
        }
    }
}

