/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.attribute.filter;

import de.datomino.peppergis.client.gui.attribute.filter.SimpleAttriubteFilterPane;
import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModel;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModelImpl;
import de.datomino.peppergis.client.model.filter.SimpleAttributeValueFilterModel;
import de.datomino.peppergis.client.model.filter.SimpleAttributeValueFilterModelImpl;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueDescriptorModel;
import de.datomino.peppergis.type.Relation;
import de.datomino.peppergis.type.attribute.AttributeValueFilterType;
import de.datomino.peppergis.type.attribute.StaticChoiceValue;
import de.datomino.util.message.MessageResolver;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.ktde.util.StringUtil;

public abstract class AbstractAttributeFilterPane<T extends Model, S extends Model>
extends JPanel {
    private static final long serialVersionUID = 6522586706521909155L;
    private JTree tree;
    private Action addFilterAction;
    private Action removeFilterAction;
    private SimpleAttriubteFilterPane<T, S> simpleAttriubteFilterPane;
    private Map<String, AttributeValueDescriptorModel<T, S>> descriptorMap;
    private List<AttributeValueDescriptorModel<T, S>> descriptorList;
    private Window parent;

    public AbstractAttributeFilterPane(Window parent, Collection<T> descriptors) {
        super(new BorderLayout());
        this.parent = parent;
        this.descriptorMap = new LinkedHashMap<String, AttributeValueDescriptorModel<T, S>>();
        this.descriptorList = new ArrayList<AttributeValueDescriptorModel<T, S>>(descriptors.size());
        for (Model t : descriptors) {
            AttributeValueDescriptorModel<Model, S> attributeValueDescriptorModel = this.createAttributeValueDescriptorModel(t);
            this.descriptorMap.put(attributeValueDescriptorModel.getKey(), attributeValueDescriptorModel);
            this.descriptorList.add(attributeValueDescriptorModel);
        }
        this.buildLayout();
    }

    private void buildLayout() {
        final JSplitPane splitPane = new JSplitPane();
        JPanel treePanel = new JPanel(new BorderLayout());
        this.tree = new JTree(new DefaultTreeModel(new DefaultMutableTreeNode("Filter")));
        this.tree.setRootVisible(true);
        this.tree.setExpandsSelectedPaths(true);
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(1);
        this.tree.setSelectionModel(selectionModel);
        this.tree.addTreeSelectionListener(new FilterTreeSelectionListener());
        JScrollPane scroll = new JScrollPane(this.tree);
        scroll.setHorizontalScrollBarPolicy(32);
        treePanel.add((Component)scroll, "Center");
        JPanel treeButtonPanel = new JPanel(new BorderLayout());
        this.addFilterAction = new AddFilterAction();
        JButton add = new JButton(this.addFilterAction);
        treeButtonPanel.add((Component)add, "East");
        this.removeFilterAction = new RemoveFilterAction();
        JButton remove = new JButton(this.removeFilterAction);
        this.removeFilterAction.setEnabled(false);
        treeButtonPanel.add((Component)remove, "West");
        treePanel.add((Component)treeButtonPanel, "South");
        splitPane.setLeftComponent(treePanel);
        this.simpleAttriubteFilterPane = new SimpleAttriubteFilterPane<T, S>(this){
            private static final long serialVersionUID = -6705040578164729365L;

            @Override
            protected Collection<AttributeValueDescriptorModel<T, S>> getDescriptors() {
                return AbstractAttributeFilterPane.this.descriptorList;
            }
        };
        splitPane.setRightComponent(this.simpleAttriubteFilterPane);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                splitPane.setDividerLocation(0.7);
            }
        });
        this.add((Component)splitPane, "Center");
    }

    public boolean simpleAttributeFilterPaneIsNotNull() {
        return this.simpleAttriubteFilterPane != null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.tree.setEnabled(enabled);
        this.refreshSelection();
        this.simpleAttriubteFilterPane.setEnabled(enabled);
    }

    public AttributeValueFilterModel getCurrentAttributeValueFilter() {
        this.adaptValuesToModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        FilterNode filterNode = (FilterNode)(root.isLeaf() ? null : root.getChildAt(0));
        return filterNode == null ? null : filterNode.getAttributeValueFilterModel();
    }

    public void adaptValuesToModel() {
        if (this.simpleAttriubteFilterPane != null) {
            this.simpleAttriubteFilterPane.adaptValuesToModel();
        }
    }

    public void setFilter(AttributeValueFilterModel attributeValueFilterModel) {
        this.adaptValuesToModel();
        DefaultTreeModel dtm = (DefaultTreeModel)this.tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)dtm.getRoot();
        if (!root.isLeaf()) {
            dtm.removeNodeFromParent((MutableTreeNode)root.getChildAt(0));
        }
        if (attributeValueFilterModel != null) {
            FilterNode filterNode = new FilterNode(attributeValueFilterModel);
            this.buildTree(filterNode, attributeValueFilterModel);
            dtm.insertNodeInto(filterNode, root, 0);
        }
    }

    private void buildTree(FilterNode current, AttributeValueFilterModel attributeValueFilterModel) {
        if (attributeValueFilterModel.getAttributeValueFilterType() != AttributeValueFilterType.SIMPLE) {
            for (AttributeValueFilterModel subAttributeValueFilterModel : attributeValueFilterModel.iterableChildAttributeValueFilters()) {
                FilterNode filterNode = new FilterNode(subAttributeValueFilterModel);
                current.add(filterNode);
                this.buildTree(filterNode, subAttributeValueFilterModel);
            }
        }
    }

    private void addFilter(AttributeValueFilterModel attributeValueFilterModel) {
        TreePath expand;
        FilterNode filterNode = new FilterNode(attributeValueFilterModel);
        DefaultTreeModel dtm = (DefaultTreeModel)this.tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)dtm.getRoot();
        if (root.isLeaf()) {
            dtm.insertNodeInto(filterNode, root, 0);
            expand = new TreePath(new Object[]{root, filterNode});
        } else {
            TreePath treePath = this.tree.getSelectionPath();
            FilterNode selectedNode = (FilterNode)treePath.getLastPathComponent();
            AttributeValueFilterModel parentAttributeValueFilterModel = selectedNode.getAttributeValueFilterModel();
            attributeValueFilterModel.setParentAttributeFilter(parentAttributeValueFilterModel);
            dtm.insertNodeInto(filterNode, selectedNode, selectedNode.getChildCount());
            int pathCount = treePath.getPathCount();
            Object[] expandPath = new Object[pathCount + 1];
            System.arraycopy(treePath.getPath(), 0, expandPath, 0, pathCount);
            expandPath[pathCount] = filterNode;
            expand = new TreePath(expandPath);
        }
        this.tree.treeDidChange();
        this.tree.setSelectionPath(expand);
    }

    private void deleteCascading(AttributeValueFilterModel attributeValueFilterModel) {
        AttributeValueFilterType attributeValueFilterType = attributeValueFilterModel.getAttributeValueFilterType();
        if (attributeValueFilterType != null) {
            switch (attributeValueFilterType) {
                case SIMPLE: {
                    attributeValueFilterModel.getSimpleAttriubteValueFilter().delete();
                    break;
                }
                case AND: 
                case NOT: 
                case OR: {
                    for (AttributeValueFilterModel subAttributeValueFilterModel : attributeValueFilterModel.iterableChildAttributeValueFilters()) {
                        this.deleteCascading(subAttributeValueFilterModel);
                    }
                    break;
                }
            }
        }
        attributeValueFilterModel.delete();
    }

    protected abstract AttributeValueDescriptorModel<T, S> createAttributeValueDescriptorModel(T var1);

    private void refreshSelection() {
        this.simpleAttriubteFilterPane.adaptValuesToModel();
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null || treePath.getPathCount() == 0 || !FilterNode.class.isInstance(treePath.getLastPathComponent())) {
            this.simpleAttriubteFilterPane.setFilter(null);
            this.removeFilterAction.setEnabled(false);
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
            this.addFilterAction.setEnabled(this.isEnabled() && root.isLeaf());
        } else {
            this.removeFilterAction.setEnabled(this.isEnabled());
            FilterNode filterNode = (FilterNode)treePath.getLastPathComponent();
            AttributeValueFilterModel attributeValueFilterModel = filterNode.getAttributeValueFilterModel();
            AttributeValueFilterType attributeValueFilterType = attributeValueFilterModel.getAttributeValueFilterType();
            this.addFilterAction.setEnabled(this.isEnabled() && attributeValueFilterType != AttributeValueFilterType.SIMPLE && (attributeValueFilterType != AttributeValueFilterType.NOT || attributeValueFilterModel.isChildAttributeValueFiltersEmpty()));
            if (attributeValueFilterType == AttributeValueFilterType.SIMPLE) {
                this.simpleAttriubteFilterPane.setFilter(attributeValueFilterModel.getSimpleAttriubteValueFilter());
                this.simpleAttriubteFilterPane.setEnabled(this.isEnabled());
            } else {
                this.simpleAttriubteFilterPane.setFilter(null);
            }
        }
        this.tree.treeDidChange();
    }

    public JTree getTree() {
        return this.tree;
    }

    public void refreshTree() {
        this.adaptValuesToModel();
        if (this.tree.getUI() instanceof BasicTreeUI) {
            this.tree.setEditable(true);
            ((BasicTreeUI)this.tree.getUI()).startEditingAtPath(this.tree, this.tree.getSelectionPath());
            ((BasicTreeUI)this.tree.getUI()).stopEditing(this.tree);
            this.tree.setEditable(false);
        }
    }

    private class FilterTypeChooserDialog
    extends CommonDialog {
        private static final long serialVersionUID = 1692002199643886469L;
        private JRadioButton simple;
        private JRadioButton and;
        private JRadioButton or;
        private JRadioButton not;

        public FilterTypeChooserDialog(Window parent) {
            super((Component)parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.filter.chooseType", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
            this.buildLayout();
            this.pack();
            SwingUtils.centerDialog(this, parent);
        }

        @Override
        protected Action getCancelAction() {
            return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
                private static final long serialVersionUID = -7684038984762591704L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    FilterTypeChooserDialog.this.dispose();
                }
            };
        }

        @Override
        protected Component getMainComponent() {
            JPanel nPanel = new JPanel(new BorderLayout());
            JPanel panel = new JPanel(new SpringLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            this.and = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.and", new Serializable[0]));
            buttonGroup.add(this.and);
            panel.add(this.and);
            this.or = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.or", new Serializable[0]));
            buttonGroup.add(this.or);
            panel.add(this.or);
            this.not = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.not", new Serializable[0]));
            buttonGroup.add(this.not);
            panel.add(this.not);
            this.simple = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.filter.simple", new Serializable[0]));
            buttonGroup.add(this.simple);
            panel.add(this.simple);
            SpringUtilities.makeCompactGrid(panel, 4, 1, 5, 5, 2, 2);
            nPanel.add((Component)panel, "North");
            return nPanel;
        }

        @Override
        protected Action getOkAction() {
            return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
                private static final long serialVersionUID = -7684038984762591704L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (FilterTypeChooserDialog.this.simple.isSelected()) {
                        AttributeValueFilterModelImpl attributeValueFilterModel = new AttributeValueFilterModelImpl();
                        attributeValueFilterModel.setAttributeValueFilterType(AttributeValueFilterType.SIMPLE);
                        SimpleAttributeValueFilterModelImpl simpleAttributeValueFilterModel = new SimpleAttributeValueFilterModelImpl();
                        attributeValueFilterModel.setSimpleAttriubteValueFilter(simpleAttributeValueFilterModel);
                        AbstractAttributeFilterPane.this.addFilter(attributeValueFilterModel);
                    } else if (FilterTypeChooserDialog.this.and.isSelected()) {
                        AttributeValueFilterModelImpl attributeValueFilterModel = new AttributeValueFilterModelImpl();
                        attributeValueFilterModel.setAttributeValueFilterType(AttributeValueFilterType.AND);
                        AbstractAttributeFilterPane.this.addFilter(attributeValueFilterModel);
                    } else if (FilterTypeChooserDialog.this.or.isSelected()) {
                        AttributeValueFilterModelImpl attributeValueFilterModel = new AttributeValueFilterModelImpl();
                        attributeValueFilterModel.setAttributeValueFilterType(AttributeValueFilterType.OR);
                        AbstractAttributeFilterPane.this.addFilter(attributeValueFilterModel);
                    } else if (FilterTypeChooserDialog.this.not.isSelected()) {
                        AttributeValueFilterModelImpl attributeValueFilterModel = new AttributeValueFilterModelImpl();
                        attributeValueFilterModel.setAttributeValueFilterType(AttributeValueFilterType.NOT);
                        AbstractAttributeFilterPane.this.addFilter(attributeValueFilterModel);
                    }
                    AbstractAttributeFilterPane.this.refreshSelection();
                    FilterTypeChooserDialog.this.dispose();
                }
            };
        }
    }

    private class FilterNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 5795383280817808138L;
        private AttributeValueFilterModel attributeValueFilterModel;

        public FilterNode(AttributeValueFilterModel attributeValueFilterModel) {
            this.attributeValueFilterModel = attributeValueFilterModel;
        }

        public AttributeValueFilterModel getAttributeValueFilterModel() {
            return this.attributeValueFilterModel;
        }

        @Override
        public String toString() {
            AttributeValueFilterModel attributeValueFilterModel = this.getAttributeValueFilterModel();
            AttributeValueFilterType attributeValueFilterType = attributeValueFilterModel.getAttributeValueFilterType();
            if (attributeValueFilterType != null) {
                switch (attributeValueFilterType) {
                    case SIMPLE: {
                        SimpleAttributeValueFilterModel simpleAttributeValueFilterModel = attributeValueFilterModel.getSimpleAttriubteValueFilter();
                        return this.toStringSimple(simpleAttributeValueFilterModel);
                    }
                    case AND: {
                        return ModelEnviroment.getMessageResolver().resolveMessage("messages.default.and", new Serializable[0]);
                    }
                    case OR: {
                        return ModelEnviroment.getMessageResolver().resolveMessage("messages.default.or", new Serializable[0]);
                    }
                    case NOT: {
                        return ModelEnviroment.getMessageResolver().resolveMessage("messages.default.not", new Serializable[0]);
                    }
                }
            }
            return "?";
        }

        private String toStringSimple(SimpleAttributeValueFilterModel simpleAttributeValueFilterModel) {
            StringBuilder sb = new StringBuilder();
            String key = simpleAttributeValueFilterModel.getKey();
            AttributeValueDescriptorModel attributeValueDescriptorModel = null;
            if (key == null) {
                sb.append("?");
            } else {
                attributeValueDescriptorModel = (AttributeValueDescriptorModel)AbstractAttributeFilterPane.this.descriptorMap.get(key);
                sb.append(attributeValueDescriptorModel == null ? key : attributeValueDescriptorModel.getName());
            }
            Relation relation = simpleAttributeValueFilterModel.getRelation();
            if (relation != null) {
                sb.append(" ").append((Object)relation);
            }
            if (attributeValueDescriptorModel != null) {
                MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
                String value = simpleAttributeValueFilterModel.getRefKeyValue();
                if (value == null) {
                    switch (attributeValueDescriptorModel.getAttributeValueType()) {
                        case BOOLEAN: {
                            Boolean booleanValue = simpleAttributeValueFilterModel.getBooleanValue();
                            if (booleanValue == null) {
                                booleanValue = false;
                            }
                            value = messageResolver.resolveMessage("messages.default." + booleanValue, new Serializable[0]);
                            break;
                        }
                        case DATE: {
                            Long longValue = simpleAttributeValueFilterModel.getLongValue();
                            value = longValue == null ? "?" : new SimpleDateFormat().format(new Date(longValue));
                            break;
                        }
                        case INTEGER: {
                            Integer intValue = simpleAttributeValueFilterModel.getIntegerValue();
                            value = intValue == null ? "?" : intValue.toString();
                            break;
                        }
                        case STATIC_CHOICE: {
                            String staticChoiceValueValue = simpleAttributeValueFilterModel.getStaticChoiceValue();
                            if (staticChoiceValueValue == null) {
                                value = "?";
                            } else {
                                for (StaticChoiceValue staticChoiceValue : attributeValueDescriptorModel.getStaticChoiceValues()) {
                                    if (!staticChoiceValue.getValue().equals(staticChoiceValueValue)) continue;
                                    value = staticChoiceValue.getName();
                                    break;
                                }
                            }
                            if (value != null) break;
                            value = "?";
                            break;
                        }
                        case STRING: {
                            value = StringUtil.nullToEmpty(simpleAttributeValueFilterModel.getStringValue());
                            break;
                        }
                        case TEXT: {
                            value = StringUtil.nullToEmpty(simpleAttributeValueFilterModel.getTextValue());
                            break;
                        }
                        case FLOAT: {
                            value = StringUtil.nullToEmpty(simpleAttributeValueFilterModel.getFloatValue());
                        }
                    }
                }
                if (value != null) {
                    sb.append(" ").append(value);
                }
            }
            String s = sb.toString();
            return s;
        }
    }

    private class RemoveFilterAction
    extends AbstractAction {
        private static final long serialVersionUID = -3125846709606115200L;

        private RemoveFilterAction() {
            super("Entfernen");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = AbstractAttributeFilterPane.this.tree.getSelectionPath();
            DefaultTreeModel dtm = (DefaultTreeModel)AbstractAttributeFilterPane.this.tree.getModel();
            FilterNode filterNode = (FilterNode)treePath.getLastPathComponent();
            dtm.removeNodeFromParent(filterNode);
            AttributeValueFilterModel attributeValueFilterModel = filterNode.getAttributeValueFilterModel();
            AbstractAttributeFilterPane.this.deleteCascading(attributeValueFilterModel);
            attributeValueFilterModel.setParentAttributeFilter(null);
            AbstractAttributeFilterPane.this.tree.treeDidChange();
        }
    }

    private class AddFilterAction
    extends AbstractAction {
        private static final long serialVersionUID = -835842436873362086L;

        private AddFilterAction() {
            super("Hinzuf\u00fcgen");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterTypeChooserDialog filterTypeChooserDialog = new FilterTypeChooserDialog(AbstractAttributeFilterPane.this.parent);
            filterTypeChooserDialog.setVisible(true);
        }
    }

    private class FilterTreeSelectionListener
    implements TreeSelectionListener {
        private FilterTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            AbstractAttributeFilterPane.this.adaptValuesToModel();
            AbstractAttributeFilterPane.this.refreshSelection();
        }
    }
}

