/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.attribute;

import de.datomino.util.swing.SpringUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.ktde.util.StringUtil;

public class MultipleChoiceListPane
extends JPanel {
    private static final long serialVersionUID = 7572518783084366295L;
    private List<String> values;
    private List<JCheckBox> boxes;

    public MultipleChoiceListPane(String values, String selectedValues, boolean editable) {
        super(new SpringLayout());
        String[] valueArray = StringUtil.unflatArrayString(values);
        String[] selectedArray = StringUtil.unflatArrayString(selectedValues);
        this.values = new ArrayList<String>(valueArray.length);
        this.boxes = new ArrayList<JCheckBox>(valueArray.length);
        HashSet<String> selected = new HashSet<String>(Arrays.asList(selectedArray));
        for (String value : valueArray) {
            this.values.add(value);
            JCheckBox box = new JCheckBox(value);
            box.setSelected(selected.contains(value));
            box.setEnabled(editable);
            this.boxes.add(box);
            this.add(box);
        }
        SpringUtilities.makeCompactGrid(this, valueArray.length, 1, 5, 5, 2, 2);
    }

    public String getSelectedString() {
        LinkedList<String> selectedList = new LinkedList<String>();
        Iterator<JCheckBox> boxIterator = this.boxes.iterator();
        Iterator<String> valueIterator = this.values.iterator();
        while (boxIterator.hasNext()) {
            JCheckBox box = boxIterator.next();
            String value = valueIterator.next();
            if (!box.isSelected()) continue;
            selectedList.add(value);
        }
        String[] valueArray = new String[selectedList.size()];
        valueArray = selectedList.toArray(valueArray);
        return StringUtil.flatArrayString(valueArray);
    }
}

