/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.gui.attribute;

import de.datomino.peppergis.client.gui.attribute.AbstractAttributeSpinnerPanel;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class AttributeNumberSpinnerPanel
extends AbstractAttributeSpinnerPanel<AttributeNumberSpinnerPanelOptions, Number> {
    private static final long serialVersionUID = 8676365412572947280L;

    public AttributeNumberSpinnerPanel(Double value, Double lowerLimit, Double upperLimit, Double stepSize) {
        this(new AttributeNumberSpinnerPanelOptions(value, lowerLimit, upperLimit, stepSize));
    }

    private AttributeNumberSpinnerPanel(AttributeNumberSpinnerPanelOptions attributeNumberSpinnerPanelOptions) {
        super(attributeNumberSpinnerPanelOptions);
    }

    @Override
    protected void modifySpinner(JSpinner spinner, AttributeNumberSpinnerPanelOptions t) {
        super.modifySpinner(spinner, t);
        JFormattedTextField jftf = ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField();
        Double upperLimit = t.getUpperLimit();
        double log10Upper = Math.log10(upperLimit == null ? 10000.0 : Math.abs(upperLimit));
        Double lowerLimit = t.getLowerLimit();
        double log10Lower = Math.log10(lowerLimit == null ? 10000.0 : Math.abs(lowerLimit));
        jftf.setColumns((int)(Math.max(log10Upper, log10Lower) + 2.0));
    }

    @Override
    protected SpinnerModel createSpinnerModel(AttributeNumberSpinnerPanelOptions t) {
        return new SpinnerNumberModel(t.getValue(), t.getLowerLimit(), t.getUpperLimit(), t.getStepSize());
    }

    public static class AttributeNumberSpinnerPanelOptions {
        private Double value;
        private Double lowerLimit;
        private Double upperLimit;
        private Double stepSize;

        public AttributeNumberSpinnerPanelOptions(Double value, Double lowerLimit, Double upperLimit, Double stepSize) {
            this.value = value;
            this.lowerLimit = lowerLimit;
            this.upperLimit = upperLimit;
            this.stepSize = stepSize;
        }

        public Double getValue() {
            return this.value;
        }

        public Double getLowerLimit() {
            return this.lowerLimit;
        }

        public Double getUpperLimit() {
            return this.upperLimit;
        }

        public Double getStepSize() {
            return this.stepSize;
        }
    }
}

